package com.usercentrics.tcf.core

internal data class TCFKeys(
    val IABTCF_CmpSdkID: Int?,
    val IABTCF_CmpSdkVersion: Int?,
    val IABTCF_PolicyVersion: Int?,
    val IABTCF_gdprApplies: Int?,
    val IABTCF_PublisherCC: String,
    val IABTCF_PurposeOneTreatment: Int?,
    val IABTCF_UseNonStandardStacks: Int?,
    val IABTCF_TCString: String?,
    val IABTCF_VendorConsents: String,
    val IABTCF_VendorLegitimateInterests: String,
    val IABTCF_PurposeConsents: String,
    val IABTCF_PurposeLegitimateInterests: String,
    val IABTCF_SpecialFeaturesOptIns: String,
    val IABTCF_PublisherRestrictions: Map<Int, String>,
    val IABTCF_PublisherConsent: String,
    val IABTCF_PublisherLegitimateInterests: String,
    val IABTCF_PublisherCustomPurposesConsents: String,
    val IABTCF_PublisherCustomPurposesLegitimateInterests: String,
    val IABTCF_EnableAdvertiserConsentMode: Int
) {
    /**
     * Fields and its type are defined in the IAB specification:
     * https://github.com/InteractiveAdvertisingBureau/GDPR-Transparency-and-Consent-Framework/blob/master/TCFv2/IAB%20Tech%20Lab%20-%20CMP%20API%20v2.md#what-is-the-cmp-in-app-internal-structure-for-the-defined-api
     */
    fun saveKeys(): TCFStoragePayload {
        val stringValues = mutableMapOf<String, String>()
        val intValues = mutableMapOf<String, Int>()

        if (IABTCF_CmpSdkID != null) {
            intValues[IABTCFKeys.CMP_SDK_ID.key] = IABTCF_CmpSdkID
        }
        if (IABTCF_CmpSdkVersion != null) {
            intValues[IABTCFKeys.CMP_SDK_VERSION.key] = IABTCF_CmpSdkVersion
        }
        if (IABTCF_PolicyVersion != null) {
            intValues[IABTCFKeys.POLICY_VERSION.key] = IABTCF_PolicyVersion
        }
        if (IABTCF_gdprApplies != null) {
            intValues[IABTCFKeys.GDPR_APPLIES.key] = IABTCF_gdprApplies
        }
        if (IABTCF_PurposeOneTreatment != null) {
            intValues[IABTCFKeys.PURPOSE_ONE_TREATMENT.key] = IABTCF_PurposeOneTreatment
        }
        if (IABTCF_TCString != null) {
            stringValues[IABTCFKeys.TC_STRING.key] = IABTCF_TCString
        }

        stringValues[IABTCFKeys.PUBLISHER_CC.key] = IABTCF_PublisherCC

        if (IABTCF_UseNonStandardStacks != null) {
            intValues[IABTCFKeys.USE_NON_STANDARD_STACKS.key] = IABTCF_UseNonStandardStacks
        }

        stringValues[IABTCFKeys.VENDOR_CONSENTS.key] = IABTCF_VendorConsents
        stringValues[IABTCFKeys.VENDOR_LEGIT_INTERESTS.key] = IABTCF_VendorLegitimateInterests
        stringValues[IABTCFKeys.PURPOSE_CONSENTS.key] = IABTCF_PurposeConsents
        stringValues[IABTCFKeys.PURPOSE_LEGIT_INTERESTS.key] = IABTCF_PurposeLegitimateInterests
        stringValues[IABTCFKeys.SPECIAL_FEATURES_OPT_INS.key] = IABTCF_SpecialFeaturesOptIns
        stringValues[IABTCFKeys.PUBLISHER_CONSENT.key] = IABTCF_PublisherConsent
        stringValues[IABTCFKeys.PUBLISHER_LEGIT_INTERESTS.key] = IABTCF_PublisherLegitimateInterests
        stringValues[IABTCFKeys.PUBLISHER_CUSTOM_PURPOSES_CONSENTS.key] = IABTCF_PublisherCustomPurposesConsents
        stringValues[IABTCFKeys.PUBLISHER_CUSTOM_PURPOSES_LEGIT_INTERESTS.key] = IABTCF_PublisherCustomPurposesLegitimateInterests
        intValues[IABTCFKeys.ENABLE_ADVERTISER_CONSENT_MODE.key] = IABTCF_EnableAdvertiserConsentMode

        IABTCF_PublisherRestrictions.entries.forEach { (purpose, purposeValue) ->
            stringValues[IABTCFKeys.publisherRestrictionsKeyOf(purpose)] = purposeValue
        }

        return TCFStoragePayload(stringValues, intValues)
    }
}
