package com.usercentrics.tcf.core.encoder.field

import com.usercentrics.tcf.core.errors.DecodingError

internal class DateEncoder {

    companion object {

        fun encode(value: Long, numBits: Int) = IntEncoder.encodeLong(value / 100, numBits)

        fun decode(value: String, numBits: Int): Long {
            if (numBits != value.length) {
                throw DecodingError("Invalid bit length")
            }
            return IntEncoder.decode(value, numBits) * 100
        }
    }
}
