package com.usercentrics.tcf.core.encoder.field

import com.usercentrics.tcf.core.errors.DecodingError
import com.usercentrics.tcf.core.model.Vector

internal class FixedVectorEncoder {

    companion object {
        fun encode(value: Vector, numBits: Int?): String {
            val maxRange = numBits ?: value.getMaxId()
            val output = StringBuilder()
            for (i in 1..maxRange) {
                output.append(BooleanEncoder.encode(value.has(i)))
            }
            return output.toString()
        }

        fun decode(value: String, numBits: Int?): Vector {
            if (numBits != null && value.length != numBits) {
                throw DecodingError("bitfield encoding length mismatch")
            }
            val vectorOutput = Vector()
            value.forEachIndexed { index, indexValue ->
                if (BooleanEncoder.decode(indexValue)) vectorOutput.set(
                    index + 1
                )
            }
            vectorOutput.bitLength = value.length
            return vectorOutput
        }
    }
}
