package com.usercentrics.tcf.core.encoder.field

import com.usercentrics.tcf.core.StringOrNumber
import com.usercentrics.tcf.core.errors.DecodingError
import com.usercentrics.tcf.core.errors.EncodingError

internal class IntEncoder {

    companion object {

        fun encodeLong(value: Long, numBits: Int): String {

            var bitString: String

            bitString = value.toString(2)

            if (bitString.length > numBits || value < 0) {
                throw EncodingError("$value too large to encode into $numBits")
            }

            // Pad the string if not filling all bits
            if (bitString.length < numBits) {

                // pad left
                bitString = "0".repeat(numBits - bitString.length) + bitString

            }

            return bitString
        }

        fun encode(value: StringOrNumber, numBits: Int): String {

            var bitString: String
            var internalValue: Int? = null

            if (value is StringOrNumber.String) {

                try {
                    internalValue = value.value.toInt()

                } catch (nfe: NumberFormatException) {
                    throw EncodingError("IntEncoder value: $value")
                }
            }

            if (value is StringOrNumber.Int) {
                internalValue = value.value
            }

            if (internalValue != null) {

                bitString = internalValue.toString(2)

                if (bitString.length > numBits || internalValue < 0) {
                    throw EncodingError("$value too large to encode into $numBits")
                }

                // Pad the string if not filling all bits
                if (bitString.length < numBits) {

                    // pad left
                    bitString = "0".repeat(numBits - bitString.length) + bitString
                }

            } else {
                throw EncodingError("Invalid value: $value")
            }

            return bitString
        }

        fun decode(value: String, numBits: Int): Long {
            if (numBits != value.length) {
                throw DecodingError("Invalid Bit Length")
            }
            return value.toLong(2)
        }
    }
}
