package com.usercentrics.tcf.core.encoder.field

import com.usercentrics.tcf.core.model.PurposeRestrictionVector
import com.usercentrics.tcf.core.model.gvl.MAX_PURPOSE_ID

internal class PublisherRestrictionsEncoder {

    companion object {

        /**
         * The UC implementation of this feature consist on a restriction applied to
         * the purpose. It is not possible to define different restrictions for different vendors
         * and the same purpose. IAB-TCF did not define an 'undefined' value for the array, so
         * we have to skip the purposes that have no restriction defined at all.
         * @suppress
         */

        fun encode(value: PurposeRestrictionVector): Map<Int, String> {
            val mapOutput = mutableMapOf<Int, String>()
            val maxVendor = value.getMaxVendorId()
            val maxPurpose = value.getGVL()?.purposes?.size ?: MAX_PURPOSE_ID

            (1..maxPurpose).forEach { purpose ->
                val restriction = (1..maxVendor).mapNotNull { vendor -> value.getRestrictionType(vendor, purpose) }.maxByOrNull { -it.value }

                mapOutput[purpose] = if (restriction == null) {
                    ""
                } else {
                    val output = StringBuilder()
                    repeat(maxVendor) { output.append(restriction.value) }
                    output.toString()
                }
            }
            return mapOutput
        }
    }
}
