package com.usercentrics.tcf.core.encoder.field

internal enum class VectorEncodingType(val value: Int) {
    FIELD(0),
    RANGE(1);

    companion object {

        fun getVectorEncodingTypeByValue(value: Int): VectorEncodingType {
            return when (value) {
                0 -> FIELD
                1 -> RANGE
                else -> {
                    throw Throwable("Invalid Value for VectorEncodingType: $value, valid values are 0 and 1")
                }
            }
        }
    }
}
