package com.usercentrics.tcf.core.encoder.sequence

import com.usercentrics.tcf.core.model.Fields
import com.usercentrics.tcf.core.model.Segment

internal class FieldSequence : SequenceVersionMap() {

    override var two: SequenceVersionMapType = SequenceVersionMapType.SVMItemMap(
        map = mapOf(
            Segment.CORE to listOf(
                Fields.version.label,
                Fields.created.label,
                Fields.lastUpdated.label,
                Fields.cmpId.label,
                Fields.cmpVersion.label,
                Fields.consentScreen.label,
                Fields.consentLanguage.label,
                Fields.vendorListVersion.label,
                Fields.policyVersion.label,
                Fields.isServiceSpecific.label,
                Fields.useNonStandardStacks.label,
                Fields.specialFeatureOptins.label,
                Fields.purposeConsents.label,
                Fields.purposeLegitimateInterests.label,
                Fields.purposeOneTreatment.label,
                Fields.publisherCountryCode.label,
                Fields.vendorConsents.label,
                Fields.vendorLegitimateInterests.label,
                Fields.publisherRestrictions.label
            ),
            Segment.PUBLISHER_TC to listOf(
                Fields.publisherConsents.label,
                Fields.publisherLegitimateInterests.label,
                Fields.numCustomPurposes.label,
                Fields.publisherCustomConsents.label,
                Fields.publisherCustomLegitimateInterests.label
            ),
            Segment.VENDORS_ALLOWED to listOf(
                Fields.vendorsAllowed.label
            ),
            Segment.VENDORS_DISCLOSED to listOf(
                Fields.vendorsDisclosed.label
            )
        )
    )
}
