package com.usercentrics.tcf.core.encoder.sequence

import com.usercentrics.tcf.core.TCModel
import com.usercentrics.tcf.core.model.Segment

internal class SegmentSequence(tcModel: TCModel) : SequenceVersionMap() {

    override var two: SequenceVersionMapType = SequenceVersionMapType.List(listOf(Segment.CORE))

    init {
        if (tcModel.getIsServiceSpecific()) {
            /**
             * If it's service specific only, then the publisher TC String can be
             * stored in the cookie and would be transmitted if it's not for
             * storage.  So it's included regardless of whether or not it's for
             * saving or the cmp api to surface.
             */
            val tempSeqVersionMap = (this.two as SequenceVersionMapType.List).value.toMutableList()
            tempSeqVersionMap.add(Segment.PUBLISHER_TC)
            this.two = SequenceVersionMapType.List(tempSeqVersionMap.toList())
        } else {
            /**
             * including vendors disclosed only if it is for saving (to the global
             * scope and not for vendors through the CMP API) or supportOOB is
             * turned on (either or both).  The compliment of this being not for
             * saving (surfaced to CMP) and no support of OOB.
             */
            if (tcModel.getSupportOOB()) {
                val tempSeqVersionMap = (this.two as SequenceVersionMapType.List).value.toMutableList()
                tempSeqVersionMap.add(Segment.VENDORS_DISCLOSED)
                this.two = SequenceVersionMapType.List(tempSeqVersionMap.toList())
            }
        }
    }
}
