package com.usercentrics.tcf.core.model

import com.usercentrics.sdk.services.tcf.Constants

internal object ConsentLanguages {

    private val values: Set<String> = setOf(
        "AR",
        "BG",
        "BS",
        "CA",
        "CS",
        "CY",
        "DA",
        "DE",
        "EL",
        "EN",
        "ES",
        "ET",
        "EU",
        "FI",
        "FR",
        "GL",
        "HE",
        "HI",
        "HR",
        "HU",
        "ID",
        "IT",
        "JA",
        "KA",
        "KO",
        "LT",
        "LV",
        "MK",
        "MS",
        "MT",
        "NL",
        "NO",
        "PL",
        "PT", // pt-pt
        "PT_BR",
        "RO",
        "RU",
        "SK",
        "SL",
        "SQ",
        "SR", // sr-cyrl
        "SR_LATN",
        "SV",
        "TH",
        "TL",
        "TR",
        "UK",
        "VI",
        "ZH",
        "ZH-HANT"
    )

    fun getLanguageOrSimilarDialect(language: String): String {
        val isLanguageAvailable = isLanguageAvailable(language)
        if (isLanguageAvailable) {
            return language
        }

        val similarDialect = getSimilarDialect(language)
        if (similarDialect != null) {
            return similarDialect
        }
        return Constants.FALLBACK_LANGUAGE
    }

    fun isLanguageAvailableOrSimilarDialectSupported(language: String): Boolean {
        val isLanguageAvailable = isLanguageAvailable(language)
        if (isLanguageAvailable) {
            return true
        }

        val hasSimilarDialect = getSimilarDialect(language.uppercase())
        return hasSimilarDialect != null
    }

    private fun isLanguageAvailable(language: String): Boolean {
        return values.contains(language.uppercase())
    }

    private fun getSimilarDialect(language: String): String? {
        val upperLanguage = language.uppercase()
        val parts = upperLanguage.split("_")

        return values.find { it.contains(parts[0]) }?.lowercase()
    }
}
