package com.usercentrics.tcf.core.model

/**
 * if a Vendor has declared flexible purposes (see: [[Vendor]] under
 * `flexiblePurposeIds`) on the Global Vendor List ([[Declarations]]) a CMP may
 * change their legal basis for processing in the encoding.
 */
enum class RestrictionType(val value: Int) {
    /**
     * under no circumstances is this purpose allowed.
     */
    NOT_ALLOWED(0),

    /**
     * if the default declaration is legitimate interest then this flips the purpose to consent in the encoding.
     */
    REQUIRE_CONSENT(1),

    /**
     * if the default declaration is consent then this flips the purpose to Legitimate Interest in the encoding.
     */
    REQUIRE_LI(2);

    companion object {
        fun getRestrictionTypeByValue(value: Int): RestrictionType {
            return when (value) {
                0 -> NOT_ALLOWED
                1 -> REQUIRE_CONSENT
                2 -> REQUIRE_LI
                else -> {
                    throw Throwable("Invalid Value for RestrictionType: $value")
                }
            }
        }
    }
}
