package com.usercentrics.tcf.core.model

internal enum class Segment(val type: String) {
    CORE("core"),
    VENDORS_DISCLOSED("vendorsDisclosed"),
    VENDORS_ALLOWED("vendorsAllowed"),
    PUBLISHER_TC("publisherTC");

    companion object {
        fun getSegmentByType(type: String): Segment {
            return when (type) {
                "core" -> CORE
                "vendorsDisclosed" -> VENDORS_DISCLOSED
                "vendorsAllowed" -> VENDORS_ALLOWED
                "publisherTC" -> PUBLISHER_TC
                else -> {
                    throw Throwable("Invalid Value for Segment Type: $type")
                }
            }
        }
    }
}
