package com.usercentrics.tcf.core.model

internal class SegmentIDs {

    /**
     * 0 = default - reserved for core string (does not need to be present in the core string)
     * 1 = OOB vendors disclosed
     * 2 = OOB vendors allowed
     * 3 = PublisherTC
     */
    companion object {
        val ID_TO_KEY: List<Segment> = listOf(
            Segment.CORE,
            Segment.VENDORS_DISCLOSED,
            Segment.VENDORS_ALLOWED,
            Segment.PUBLISHER_TC
        )

        val KEY_TO_ID: Map<Segment, Int> = mapOf(
            Segment.CORE to 0,
            Segment.VENDORS_DISCLOSED to 1,
            Segment.VENDORS_ALLOWED to 2,
            Segment.PUBLISHER_TC to 3
        )

    }

}
