package com.usercentrics.tcf.core.model.gvl

import kotlinx.serialization.Serializable

@Serializable
data class DataRetention(
    val stdRetention: Int? = null,
    val purposes: RetentionPeriod,
    val specialPurposes: RetentionPeriod,
)

@Serializable
data class RetentionPeriod(
    val idAndPeriod: Map<Int, Int>,
) {

    companion object {

        fun parseFromGvlMap(idAndPeriod: Map<String, Int>?): RetentionPeriod {
            return RetentionPeriod(idAndPeriod = idAndPeriod?.map { it.key.toInt() to it.value }?.toMap() ?: mapOf())
        }
    }
}
