package com.usercentrics.tcf.core.model.gvl

import kotlinx.serialization.Serializable

@Serializable
internal data class Overflow(
    val httpGetLimit: Int
)

@Serializable
internal data class Vendor(
    val purposes: List<Int>,
    val legIntPurposes: List<Int>,
    val flexiblePurposes: List<Int>,
    val specialPurposes: List<Int>,
    val features: List<Int>,
    var specialFeatures: List<Int>,
    val policyUrl: String = "", //TODO remove later
    val deletedDate: String? = null,
    val overflow: Overflow? = null,
    val cookieMaxAgeSeconds: Double? = null,
    val usesNonCookieAccess: Boolean,
    val deviceStorageDisclosureUrl: String? = null,
    val usesCookies: Boolean = false,
    val cookieRefresh: Boolean? = false,
    val id: Int,
    val name: String,
    val dataRetention: GvlDataRetention?,
    val urls: List<VendorUrl>?,
    val dataDeclaration: List<Int>? = null,
)

@Serializable
internal data class GvlDataRetention(
    val stdRetention: Int? = null,
    val purposes: Map<String, Int>,
    val specialPurposes: Map<String, Int>,
)
