/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage.migrations;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.services.dataFacade.DataFacade;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.migrations.AbstractMigrationSettingsV2;
import com.usercentrics.sdk.services.deviceStorage.models.StorageService;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3;", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/AbstractMigrationSettingsV2;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "json", "Lcom/usercentrics/sdk/core/json/JsonParser;", "isTVOS", "", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/core/json/JsonParser;Z)V", "migrate", "", "processSettings", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSettings;", "settings", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMigrationToVersion3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationToVersion3.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n40#2:75\n1549#3:76\n1620#3,3:77\n*S KotlinDebug\n*F\n+ 1 MigrationToVersion3.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3\n*L\n38#1:75\n63#1:76\n63#1:77,3\n*E\n"})
public final class MigrationToVersion3
extends AbstractMigrationSettingsV2 {
    @NotNull
    private final JsonParser json;
    private final boolean isTVOS;

    public MigrationToVersion3(@NotNull StorageHolder storageHolder, @NotNull JsonParser json2, boolean isTVOS) {
        Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        super(3, storageHolder, json2);
        this.json = json2;
        this.isTVOS = isTVOS;
    }

    @Override
    public void migrate() {
        if (!this.isTVOS) {
            return;
        }
        String settingsValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString("settings", null);
        CharSequence charSequence = settingsValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        int storageVersionValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getNumber("storage_version", -1);
        String ccpaTimestampValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString("ccpa_timestamp_millis", null);
        String consentsBufferValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString("consents_buffer", null);
        String sessionTimestampValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString("session_timestamp", null);
        String tcfValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString("tcf", null);
        this.getStorageHolder().getUsercentricsKeyValueStorage().purgeStorage();
        StorageSettings newSettings = this.processSettings(this.storageSettingsFromCache(settingsValue));
        JsonParser jsonParser = this.json;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageSettings.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.getStorageHolder().getUsercentricsKeyValueStorage().put("settings", JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)newSettings));
        if (storageVersionValue != -1) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put("storage_version", storageVersionValue);
        }
        if (ccpaTimestampValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put("ccpa_timestamp_millis", ccpaTimestampValue);
        }
        if (consentsBufferValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put("consents_buffer", consentsBufferValue);
        }
        if (sessionTimestampValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put("session_timestamp", sessionTimestampValue);
        }
        if (tcfValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put("tcf", tcfValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final StorageSettings processSettings(StorageSettings settings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = settings.getServices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageService storageService = (StorageService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHistory().size() > DataFacade.Companion.getMaxStorageHistorySize() ? StorageService.copy$default((StorageService)it, CollectionsKt.takeLast(it.getHistory(), (int)DataFacade.Companion.getMaxStorageHistorySize()), null, null, false, 14, null) : it);
        }
        List servicesWithHistorySize = (List)destination$iv$iv;
        return StorageSettings.copy$default(settings, null, null, null, servicesWithHistorySize, null, 23, null);
    }
}

