/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.settings;

import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.gdpr.DefaultLabels;
import com.usercentrics.sdk.models.gdpr.DefaultUISettings;
import com.usercentrics.sdk.models.settings.GDPROptions;
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIAriaLabels;
import com.usercentrics.sdk.models.settings.PredefinedUICookieInformationLabels;
import com.usercentrics.sdk.models.settings.PredefinedUICustomization;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColor;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorButton;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorToggles;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationFont;
import com.usercentrics.sdk.models.settings.PredefinedUIDataDistributionTitle;
import com.usercentrics.sdk.models.settings.PredefinedUIDescriptionTitle;
import com.usercentrics.sdk.models.settings.PredefinedUIGeneralLabels;
import com.usercentrics.sdk.models.settings.PredefinedUILanguage;
import com.usercentrics.sdk.models.settings.PredefinedUILanguageSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceLabels;
import com.usercentrics.sdk.models.settings.PredefinedUIURLsTitle;
import com.usercentrics.sdk.models.settings.SettingsVersion;
import com.usercentrics.sdk.models.settings.USAFrameworks;
import com.usercentrics.sdk.models.tcf.TCFLabels;
import com.usercentrics.sdk.models.tcf.TCFUISettings;
import com.usercentrics.sdk.services.settings.IGeneratorIds;
import com.usercentrics.sdk.services.settings.ISettingsMapper;
import com.usercentrics.sdk.services.settings.ISettingsServiceMapper;
import com.usercentrics.sdk.ui.color.Color;
import com.usercentrics.sdk.ui.color.PredefinedUIColorMachine;
import com.usercentrics.sdk.ui.color.UsercentricsShadedColor;
import com.usercentrics.sdk.v2.settings.data.CustomizationColor;
import com.usercentrics.sdk.v2.settings.data.CustomizationFont;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCustomization;
import com.usercentrics.sdk.v2.settings.data.UsercentricsService;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization;
import com.usercentrics.sdk.v2.translation.data.TranslationAriaLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/usercentrics/sdk/services/settings/SettingsMapper;", "Lcom/usercentrics/sdk/services/settings/ISettingsMapper;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "servicesMapper", "Lcom/usercentrics/sdk/services/settings/ISettingsServiceMapper;", "generatorIds", "Lcom/usercentrics/sdk/services/settings/IGeneratorIds;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/settings/ISettingsServiceMapper;Lcom/usercentrics/sdk/services/settings/IGeneratorIds;)V", "getValidControllerId", "", "controllerId", "map", "Lcom/usercentrics/sdk/models/settings/LegacyExtendedSettings;", "apiSettings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "apiServices", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsService;", "translations", "Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;", "mapCustomization", "Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;", "mapLanguage", "Lcom/usercentrics/sdk/models/settings/PredefinedUILanguageSettings;", "mapLegacyTCFUISettings", "Lcom/usercentrics/sdk/models/tcf/TCFUISettings;", "mapShowFirstLayerOnVersionChange", "", "showInitialViewForVersionChange", "mapUILabelsFromApiSettings", "Lcom/usercentrics/sdk/models/gdpr/DefaultLabels;", "mapUISettings", "Lcom/usercentrics/sdk/models/gdpr/DefaultUISettings;", "validateRawColor", "name", "rawValue", "defaultValue", "emptyToNull", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nSettingsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsMapper.kt\ncom/usercentrics/sdk/services/settings/SettingsMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1#2:318\n1549#3:319\n1620#3,3:320\n1549#3:323\n1620#3,3:324\n1045#3:327\n*S KotlinDebug\n*F\n+ 1 SettingsMapper.kt\ncom/usercentrics/sdk/services/settings/SettingsMapper\n*L\n206#1:319\n206#1:320,3\n221#1:323\n221#1:324,3\n222#1:327\n*E\n"})
public final class SettingsMapper
implements ISettingsMapper {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final ISettingsServiceMapper servicesMapper;
    @NotNull
    private final IGeneratorIds generatorIds;

    public SettingsMapper(@NotNull UsercentricsLogger logger2, @NotNull ISettingsServiceMapper servicesMapper, @NotNull IGeneratorIds generatorIds2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)servicesMapper, (String)"servicesMapper");
        Intrinsics.checkNotNullParameter((Object)generatorIds2, (String)"generatorIds");
        this.logger = logger2;
        this.servicesMapper = servicesMapper;
        this.generatorIds = generatorIds2;
    }

    @Override
    @NotNull
    public LegacyExtendedSettings map(@NotNull UsercentricsSettings apiSettings, @NotNull List<UsercentricsService> apiServices, @NotNull LegalBasisLocalization translations, @Nullable String controllerId) {
        Intrinsics.checkNotNullParameter((Object)apiSettings, (String)"apiSettings");
        Intrinsics.checkNotNullParameter(apiServices, (String)"apiServices");
        Intrinsics.checkNotNullParameter((Object)translations, (String)"translations");
        List list = apiSettings.getCategories$usercentrics_release();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        USAFrameworks uSAFrameworks = apiSettings.getFramework();
        return new LegacyExtendedSettings(list, this.servicesMapper.map(apiSettings, apiServices, translations), new GDPROptions(apiSettings.getDisplayOnlyForEU(), apiSettings.getReshowBanner()), apiSettings.getCcpa(), this.getValidControllerId(controllerId), apiSettings.getSettingsId(), apiSettings.getTcf2Enabled(), this.mapShowFirstLayerOnVersionChange(apiSettings.getShowInitialViewForVersionChange()), this.mapLegacyTCFUISettings(translations, apiSettings), this.mapUISettings(apiSettings, translations), apiSettings.getVersion(), uSAFrameworks != null ? uSAFrameworks.name() : null, null, apiSettings.getRenewConsentsTimestamp(), 4096, null);
    }

    private final String getValidControllerId(String controllerId) {
        CharSequence charSequence = controllerId;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.generatorIds.generateControllerId() : controllerId;
    }

    private final DefaultUISettings mapUISettings(UsercentricsSettings apiSettings, LegalBasisLocalization translations) {
        DefaultUISettings defaultUISettings;
        if (apiSettings.getTcf2Enabled()) {
            defaultUISettings = null;
        } else {
            PredefinedUICustomization predefinedUICustomization = this.mapCustomization(apiSettings);
            DefaultLabels defaultLabels = this.mapUILabelsFromApiSettings(apiSettings, translations);
            PredefinedUILanguageSettings predefinedUILanguageSettings = this.mapLanguage(apiSettings);
            defaultUISettings = new DefaultUISettings(predefinedUICustomization, predefinedUILanguageSettings, defaultLabels);
        }
        return defaultUISettings;
    }

    private final TCFUISettings mapLegacyTCFUISettings(LegalBasisLocalization translations, UsercentricsSettings apiSettings) {
        TCFUISettings tCFUISettings;
        if (apiSettings.getTcf2Enabled() && apiSettings.getTcf2() != null) {
            PredefinedUICustomization predefinedUICustomization = this.mapCustomization(apiSettings);
            TCFLabels tCFLabels = new TCFLabels(translations.getLabels$usercentrics_release().getVendorsOutsideEU(), this.mapUILabelsFromApiSettings(apiSettings, translations), new PredefinedUICookieInformationLabels(apiSettings.getLabels().getAnyDomain(), apiSettings.getLabels().getDay(), apiSettings.getLabels().getDays(), apiSettings.getLabels().getDomain(), apiSettings.getLabels().getDuration(), apiSettings.getLabels().getInformationLoadingNotPossible(), apiSettings.getLabels().getHour(), apiSettings.getLabels().getHours(), apiSettings.getLabels().getIdentifier(), apiSettings.getLabels().getLoadingStorageInformation(), apiSettings.getLabels().getMaximumAgeCookieStorage(), apiSettings.getLabels().getMinute(), apiSettings.getLabels().getMinutes(), apiSettings.getLabels().getMonth(), apiSettings.getLabels().getMonths(), apiSettings.getLabels().getMultipleDomains(), apiSettings.getLabels().getNo(), apiSettings.getLabels().getNonCookieStorage(), apiSettings.getLabels().getSecond(), apiSettings.getLabels().getSeconds(), apiSettings.getLabels().getSession(), apiSettings.getLabels().getStorageInformation(), apiSettings.getLabels().getDetailedStorageInformation(), apiSettings.getLabels().getTryAgain(), apiSettings.getLabels().getType(), apiSettings.getLabels().getYear(), apiSettings.getLabels().getYears(), apiSettings.getLabels().getYes(), apiSettings.getLabels().getStorageInformationDescription(), translations.getLabels$usercentrics_release().getCookieStorage(), translations.getLabels$usercentrics_release().getCookieRefresh(), apiSettings.getTcf2().getLabelsPurposes()));
            PredefinedUILanguageSettings predefinedUILanguageSettings = this.mapLanguage(apiSettings);
            boolean bl = apiSettings.getTcf2().isAdditionalConsentModeEnabled$usercentrics_release();
            List<Integer> list = apiSettings.getTcf2().getSelectedATPIds();
            tCFUISettings = new TCFUISettings(predefinedUICustomization, predefinedUILanguageSettings, tCFLabels, bl, list);
        } else {
            tCFUISettings = null;
        }
        return tCFUISettings;
    }

    private final String validateRawColor(String name, String rawValue, String defaultValue) {
        if (Color.Companion.isValid(rawValue)) {
            return rawValue;
        }
        UsercentricsLogger.DefaultImpls.warning$default(this.logger, "Configured color (" + rawValue + ") for '" + name + "' should be a valid hexadecimal, default color will be used " + defaultValue, null, 2, null);
        return defaultValue;
    }

    private final PredefinedUICustomization mapCustomization(UsercentricsSettings apiSettings) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object $this$mapCustomization_u24lambda_u240;
        CustomizationColor customizationColor;
        UsercentricsCustomization customization;
        UsercentricsCustomization usercentricsCustomization = customization = apiSettings.getCustomization();
        CustomizationColor customizationColor2 = customizationColor = usercentricsCustomization != null ? usercentricsCustomization.getColor() : null;
        String string = customizationColor2 != null ? customizationColor2.getPrimary() : null;
        if (string == null) {
            string = "";
        }
        String rawLegacyPrimaryColor = string;
        String legacyPrimaryColor = this.validateRawColor("primary", rawLegacyPrimaryColor, "#0045A5");
        UsercentricsShadedColor legacyPrimaryShadedColor = PredefinedUIColorMachine.INSTANCE.generateShadedColor(legacyPrimaryColor);
        CustomizationColor customizationColor3 = customizationColor;
        String string2 = customizationColor3 != null ? customizationColor3.getText() : null;
        if (string2 == null) {
            string2 = "";
        }
        String rawTextColor = string2;
        String textColor = this.validateRawColor("text", rawTextColor, "#303030");
        UsercentricsShadedColor textShadedColor = PredefinedUIColorMachine.INSTANCE.generateShadedColor(textColor);
        CustomizationColor customizationColor4 = customizationColor;
        String string3 = customizationColor4 != null ? customizationColor4.getOverlay() : null;
        if (string3 == null) {
            string3 = "";
        }
        String rawOverlayColor = string3;
        String baseOverlayColor = this.validateRawColor("overlay", rawOverlayColor, "#333333");
        Object object5 = customization;
        int buttonCornerRadius = object5 != null && (object5 = ((UsercentricsCustomization)object5).getBorderRadiusButton()) != null ? (Integer)object5 : 4;
        Object object6 = this;
        try {
            $this$mapCustomization_u24lambda_u240 = object6;
            boolean bl = false;
            Object object7 = customization;
            $this$mapCustomization_u24lambda_u240 = Result.constructor-impl(object7 != null && (object7 = ((UsercentricsCustomization)object7).getOverlayOpacity()) != null ? Double.valueOf(((Float)object7).floatValue()) : null);
        }
        catch (Throwable bl) {
            $this$mapCustomization_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object6 = $this$mapCustomization_u24lambda_u240;
        Double d = (Double)(Result.isFailure-impl((Object)object6) ? null : object6);
        double overlayOpacity = d != null ? d : 1.0;
        CustomizationColor customizationColor5 = customizationColor;
        String string4 = customizationColor5 != null ? customizationColor5.getLayerBackground() : null;
        if (string4 == null) {
            string4 = "";
        }
        String rawLayerBackgroundColor = string4;
        String layerBackgroundColor = this.validateRawColor("layerBackground", rawLayerBackgroundColor, "#FFFFFF");
        String layerBackgroundLightenColor = PredefinedUIColorMachine.INSTANCE.lightenColor(layerBackgroundColor, 0.05);
        CustomizationColor customizationColor6 = customizationColor;
        String string5 = customizationColor6 != null ? customizationColor6.getTabsBorderColor() : null;
        if (string5 == null) {
            string5 = "";
        }
        String rawTabsBorderColor = string5;
        String tabsBorderColor = this.validateRawColor("tabsBorderColor", rawTabsBorderColor, "#DDDDDD");
        CustomizationColor customizationColor7 = customizationColor;
        Object object8 = this.emptyToNull(customizationColor7 != null ? customizationColor7.getAcceptBtnBackground() : null);
        if (object8 == null) {
            object8 = object4 = "#0045A5";
        }
        if ((object3 = customizationColor) == null || (object3 = ((CustomizationColor)object3).getAcceptBtnText()) == null || (object3 = this.emptyToNull((String)object3)) == null) {
            object3 = "#FAFAFA";
        }
        Object object9 = object3;
        PredefinedUICustomizationColorButton predefinedUICustomizationColorButton = new PredefinedUICustomizationColorButton((String)object9, (String)object4, buttonCornerRadius);
        CustomizationColor customizationColor8 = customizationColor;
        String string6 = this.emptyToNull(customizationColor8 != null ? customizationColor8.getDenyBtnBackground() : null);
        if (string6 == null) {
            string6 = "#0045A5";
        }
        object9 = string6;
        CustomizationColor customizationColor9 = customizationColor;
        String string7 = this.emptyToNull(customizationColor9 != null ? customizationColor9.getDenyBtnText() : null);
        if (string7 == null) {
            string7 = "#FAFAFA";
        }
        Object object10 = string7;
        object4 = new PredefinedUICustomizationColorButton((String)object10, (String)object9, buttonCornerRadius);
        CustomizationColor customizationColor10 = customizationColor;
        String string8 = this.emptyToNull(customizationColor10 != null ? customizationColor10.getSaveBtnBackground() : null);
        if (string8 == null) {
            string8 = "#F5F5F5";
        }
        object10 = string8;
        CustomizationColor customizationColor11 = customizationColor;
        String string9 = this.emptyToNull(customizationColor11 != null ? customizationColor11.getSaveBtnText() : null);
        if (string9 == null) {
            string9 = "#303030";
        }
        Object object11 = string9;
        object9 = new PredefinedUICustomizationColorButton((String)object11, (String)object10, buttonCornerRadius);
        CustomizationColor customizationColor12 = customizationColor;
        String string10 = this.emptyToNull(customizationColor12 != null ? customizationColor12.getSaveBtnBackground() : null);
        if (string10 == null) {
            string10 = "#F5F5F5";
        }
        object11 = string10;
        CustomizationColor customizationColor13 = customizationColor;
        String string11 = this.emptyToNull(customizationColor13 != null ? customizationColor13.getSaveBtnText() : null);
        if (string11 == null) {
            string11 = "#303030";
        }
        Object object12 = string11;
        object10 = new PredefinedUICustomizationColorButton((String)object12, (String)object11, buttonCornerRadius);
        CustomizationColor customizationColor14 = customizationColor;
        Object object13 = this.emptyToNull(customizationColor14 != null ? customizationColor14.getCcpaButtonColor() : null);
        if (object13 == null) {
            object13 = object12 = "#F5F5F5";
        }
        if ((object2 = customizationColor) == null || (object2 = ((CustomizationColor)object2).getCcpaButtonTextColor()) == null || (object2 = this.emptyToNull((String)object2)) == null) {
            object2 = "#303030";
        }
        Object object14 = object2;
        object11 = new PredefinedUICustomizationColorButton((String)object14, (String)object12, buttonCornerRadius);
        CustomizationColor customizationColor15 = customizationColor;
        String string12 = this.emptyToNull(customizationColor15 != null ? customizationColor15.getToggleActiveBackground() : null);
        if (string12 == null) {
            string12 = legacyPrimaryShadedColor.getColor80();
        }
        object14 = string12;
        CustomizationColor customizationColor16 = customizationColor;
        String string13 = this.emptyToNull(customizationColor16 != null ? customizationColor16.getToggleInactiveBackground() : null);
        if (string13 == null) {
            string13 = textShadedColor.getColor80();
        }
        String string14 = string13;
        CustomizationColor customizationColor17 = customizationColor;
        String string15 = this.emptyToNull(customizationColor17 != null ? customizationColor17.getToggleDisabledBackground() : null);
        if (string15 == null) {
            string15 = textShadedColor.getColor16();
        }
        String string16 = string15;
        CustomizationColor customizationColor18 = customizationColor;
        String string17 = this.emptyToNull(customizationColor18 != null ? customizationColor18.getToggleActiveIcon() : null);
        if (string17 == null) {
            string17 = "#FFFFFF";
        }
        String string18 = string17;
        CustomizationColor customizationColor19 = customizationColor;
        String string19 = this.emptyToNull(customizationColor19 != null ? customizationColor19.getToggleDisabledIcon() : null);
        if (string19 == null) {
            string19 = "#FFFFFF";
        }
        String string20 = string19;
        CustomizationColor customizationColor20 = customizationColor;
        String string21 = this.emptyToNull(customizationColor20 != null ? customizationColor20.getToggleInactiveIcon() : null);
        if (string21 == null) {
            string21 = "#FFFFFF";
        }
        String string22 = string21;
        object12 = new PredefinedUICustomizationColorToggles((String)object14, string14, string16, string18, string22, string20);
        CustomizationColor customizationColor21 = customizationColor;
        String string23 = this.emptyToNull(customizationColor21 != null ? customizationColor21.getLinkFont() : null);
        if (string23 == null) {
            string23 = "#303030";
        }
        object14 = string23;
        CustomizationColor customizationColor22 = customizationColor;
        String string24 = this.emptyToNull(customizationColor22 != null ? customizationColor22.getSecondLayerTab() : null);
        if (string24 == null) {
            string24 = legacyPrimaryColor;
        }
        string14 = string24;
        PredefinedUICustomizationColor predefinedUICustomizationColor = new PredefinedUICustomizationColor(textShadedColor, predefinedUICustomizationColorButton, (PredefinedUICustomizationColorButton)object4, (PredefinedUICustomizationColorButton)object9, (PredefinedUICustomizationColorButton)object11, (PredefinedUICustomizationColorButton)object10, (PredefinedUICustomizationColorToggles)object12, layerBackgroundColor, layerBackgroundLightenColor, (String)object14, string14, baseOverlayColor, overlayOpacity, tabsBorderColor);
        Object object15 = customization;
        String string25 = this.emptyToNull(object15 != null && (object15 = ((UsercentricsCustomization)object15).getFont()) != null ? ((CustomizationFont)object15).getFamily() : null);
        if (string25 == null) {
            string25 = "";
        }
        UsercentricsCustomization usercentricsCustomization2 = customization;
        Object object16 = customization;
        return new PredefinedUICustomization(predefinedUICustomizationColor, new PredefinedUICustomizationFont(string25, object16 != null && (object16 = ((UsercentricsCustomization)object16).getFont()) != null && (object16 = ((CustomizationFont)object16).getSize()) != null ? (Integer)object16 : 14), usercentricsCustomization2 != null ? usercentricsCustomization2.getLogoUrl() : null, (object = customization) != null && (object = ((UsercentricsCustomization)object).getBorderRadiusLayer()) != null ? (Integer)object : 8);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> mapShowFirstLayerOnVersionChange(List<String> showInitialViewForVersionChange) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = showInitialViewForVersionChange;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            void element;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SettingsMapper $this$mapShowFirstLayerOnVersionChange_u24lambda_u242_u24lambda_u241 = this;
            boolean bl2 = false;
            void var13_13 = element;
            String string2 = "MAJOR".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)var13_13, (Object)string2)) {
                n = SettingsVersion.MAJOR.ordinal();
            } else {
                String string3 = "MINOR".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)var13_13, (Object)string3)) {
                    n = SettingsVersion.MINOR.ordinal();
                } else {
                    String string4 = "PATCH".toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    n = Intrinsics.areEqual((Object)var13_13, (Object)string4) ? SettingsVersion.PATCH.ordinal() : -1;
                }
            }
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedUILanguageSettings mapLanguage(UsercentricsSettings apiSettings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = apiSettings.getLanguagesAvailable();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PredefinedUILanguage((String)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        PredefinedUILanguage predefinedUILanguage = new PredefinedUILanguage(apiSettings.getLanguage());
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PredefinedUILanguage it = (PredefinedUILanguage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getFullName());
                it = (PredefinedUILanguage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFullName())));
            }
        });
        return new PredefinedUILanguageSettings(list, predefinedUILanguage);
    }

    private final DefaultLabels mapUILabelsFromApiSettings(UsercentricsSettings apiSettings, LegalBasisLocalization translations) {
        String string = apiSettings.getLabels().getDataCollectedList();
        String string2 = apiSettings.getLabels().getDataCollectedInfo();
        PredefinedUIDescriptionTitle predefinedUIDescriptionTitle = new PredefinedUIDescriptionTitle(string2, string);
        string = apiSettings.getLabels().getDataPurposes();
        string2 = apiSettings.getLabels().getDataPurposesInfo();
        PredefinedUIDescriptionTitle predefinedUIDescriptionTitle2 = new PredefinedUIDescriptionTitle(string2, string);
        string = apiSettings.getLabels().getHistory();
        string2 = apiSettings.getLabels().getHistoryDescription();
        PredefinedUIDescriptionTitle predefinedUIDescriptionTitle3 = new PredefinedUIDescriptionTitle(string2, string);
        string = apiSettings.getLabels().getLegalBasisList();
        string2 = apiSettings.getLabels().getLegalBasisInfo();
        PredefinedUIDescriptionTitle predefinedUIDescriptionTitle4 = new PredefinedUIDescriptionTitle(string2, string);
        string = apiSettings.getLabels().getTechnologiesUsed();
        string2 = apiSettings.getLabels().getTechnologiesUsedInfo();
        TranslationAriaLabels translationAriaLabels = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels2 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels3 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels4 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels5 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels6 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels7 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels8 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels9 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels10 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels11 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels12 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels13 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels14 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels15 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels16 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels17 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels18 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels19 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels20 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels21 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels22 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels23 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels24 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels25 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels26 = translations.getLabelsAria();
        TranslationAriaLabels translationAriaLabels27 = translations.getLabelsAria();
        UsercentricsCustomization usercentricsCustomization = apiSettings.getCustomization();
        return new DefaultLabels(new PredefinedUIGeneralLabels(translations.getLabels$usercentrics_release().getControllerIdTitle(), apiSettings.getLabels().getDate(), apiSettings.getLabels().getDecision(), apiSettings.getLabels().getBtnBannerReadMore(), apiSettings.getLabels().getBtnMore(), apiSettings.getLabels().getBtnAcceptAll(), apiSettings.getLabels().getBtnDeny(), translations.getLabels$usercentrics_release().getCnilDenyLinkText()), new PredefinedUIServiceLabels(predefinedUIDescriptionTitle, new PredefinedUIDataDistributionTitle(apiSettings.getLabels().getLocationOfProcessing(), apiSettings.getLabels().getTransferToThirdCountries(), apiSettings.getLabels().getTransferToThirdCountriesInfo()), predefinedUIDescriptionTitle2, apiSettings.getLabels().getDataRecipientsList(), apiSettings.getLabels().getDescriptionOfService(), predefinedUIDescriptionTitle3, predefinedUIDescriptionTitle4, apiSettings.getLabels().getProcessingCompanyTitle(), apiSettings.getLabels().getRetentionPeriod(), new PredefinedUIDescriptionTitle(string2, string), new PredefinedUIURLsTitle(apiSettings.getLabels().getCookiePolicyInfo(), apiSettings.getLabels().getLinkToDpaInfo(), apiSettings.getLabels().getOptOut(), apiSettings.getLabels().getPolicyOf())), new PredefinedUIAriaLabels(translationAriaLabels != null ? translationAriaLabels.getAcceptAllButton() : null, translationAriaLabels2 != null ? translationAriaLabels2.getCcpaButton() : null, translationAriaLabels3 != null ? translationAriaLabels3.getCcpaMoreInformation() : null, translationAriaLabels4 != null ? translationAriaLabels4.getCloseButton() : null, translationAriaLabels5 != null ? translationAriaLabels5.getCollapse() : null, translationAriaLabels6 != null ? translationAriaLabels6.getCookiePolicyButton() : null, translationAriaLabels7 != null ? translationAriaLabels7.getCopyControllerId() : null, translationAriaLabels8 != null ? translationAriaLabels8.getDenyAllButton() : null, translationAriaLabels9 != null ? translationAriaLabels9.getExpand() : null, translationAriaLabels10 != null ? translationAriaLabels10.getFullscreenButton() : null, translationAriaLabels11 != null ? translationAriaLabels11.getImprintButton() : null, translationAriaLabels12 != null ? translationAriaLabels12.getLanguageSelector() : null, translationAriaLabels13 != null ? translationAriaLabels13.getPrivacyButton() : null, translationAriaLabels14 != null ? translationAriaLabels14.getPrivacyPolicyButton() : null, translationAriaLabels15 != null ? translationAriaLabels15.getSaveButton() : null, translationAriaLabels16 != null ? translationAriaLabels16.getServiceInCategoryDetails() : null, translationAriaLabels17 != null ? translationAriaLabels17.getServicesInCategory() : null, translationAriaLabels18 != null ? translationAriaLabels18.getTabButton() : null, translationAriaLabels19 != null ? translationAriaLabels19.getUsercentricsCMPButtons() : null, translationAriaLabels20 != null ? translationAriaLabels20.getUsercentricsCMPContent() : null, translationAriaLabels21 != null ? translationAriaLabels21.getUsercentricsCMPHeader() : null, translationAriaLabels22 != null ? translationAriaLabels22.getUsercentricsCMPUI() : null, translationAriaLabels23 != null ? translationAriaLabels23.getUsercentricsCard() : null, translationAriaLabels24 != null ? translationAriaLabels24.getUsercentricsList() : null, translationAriaLabels25 != null ? translationAriaLabels25.getVendorConsentToggle() : null, translationAriaLabels26 != null ? translationAriaLabels26.getVendorDetailedStorageInformation() : null, translationAriaLabels27 != null ? translationAriaLabels27.getVendorLegIntToggle() : null, usercentricsCustomization != null ? usercentricsCustomization.getLogoAltTag() : null));
    }

    private final String emptyToNull(String $this$emptyToNull) {
        String string = $this$emptyToNull;
        return (string != null ? ((CharSequence)string).length() == 0 : false) ? null : $this$emptyToNull;
    }
}

