/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/usercentrics/sdk/ui/color/Color;", "", "red", "", "green", "blue", "(III)V", "getBlue", "()I", "getGreen", "getRed", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toHex", "", "toString", "Companion", "usercentrics_release"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public final int getRed() {
        return this.red;
    }

    public final int getGreen() {
        return this.green;
    }

    public final int getBlue() {
        return this.blue;
    }

    @NotNull
    public final String toHex() {
        return "#" + Color.Companion.hexToString(this.red) + Color.Companion.hexToString(this.blue) + Color.Companion.hexToString(this.green);
    }

    public final int component1() {
        return this.red;
    }

    public final int component2() {
        return this.green;
    }

    public final int component3() {
        return this.blue;
    }

    @NotNull
    public final Color copy(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static /* synthetic */ Color copy$default(Color color, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = color.red;
        }
        if ((n4 & 2) != 0) {
            n2 = color.green;
        }
        if ((n4 & 4) != 0) {
            n3 = color.blue;
        }
        return color.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "Color(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.red);
        result = result * 31 + Integer.hashCode(this.green);
        result = result * 31 + Integer.hashCode(this.blue);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        Color color = (Color)other;
        if (this.red != color.red) {
            return false;
        }
        if (this.green != color.green) {
            return false;
        }
        return this.blue == color.blue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/usercentrics/sdk/ui/color/Color$Companion;", "", "()V", "fromHex", "Lcom/usercentrics/sdk/ui/color/Color;", "input", "", "hexToString", "", "isValid", "", "sanitizeBaseColor", "baseColor", "stringToHexInt", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color fromHex(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String sanitizedBaseColor = this.sanitizeBaseColor(input);
            String string = sanitizedBaseColor.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String red = string;
            String string2 = sanitizedBaseColor.substring(2, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String green = string2;
            String string3 = sanitizedBaseColor.substring(4, 6);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String blue = string3;
            return new Color(this.stringToHexInt(red), this.stringToHexInt(blue), this.stringToHexInt(green));
        }

        public final boolean isValid(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String sanitizedBaseColor = this.sanitizeBaseColor(input);
            if (((CharSequence)sanitizedBaseColor).length() == 0) {
                return false;
            }
            return sanitizedBaseColor.length() == 6;
        }

        private final String sanitizeBaseColor(String baseColor) {
            String string;
            if (StringsKt.startsWith$default((CharSequence)baseColor, (char)'#', (boolean)false, (int)2, null)) {
                String string2 = baseColor.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = baseColor;
            }
            return string;
        }

        private final int stringToHexInt(String input) {
            return Integer.parseInt(input, CharsKt.checkRadix((int)16));
        }

        private final String hexToString(int input) {
            String string = Integer.toString(input, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.padStart((String)string, (int)2, (char)'0');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

