/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.color;

import com.usercentrics.sdk.ui.color.Color;
import com.usercentrics.sdk.ui.color.UsercentricsShadedColor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/usercentrics/sdk/ui/color/PredefinedUIColorMachine;", "", "()V", "white", "Lcom/usercentrics/sdk/ui/color/Color;", "generateShadedColor", "Lcom/usercentrics/sdk/ui/color/UsercentricsShadedColor;", "baseHexColor", "", "lightenColor", "amount", "", "shadedColorBy", "baseColor", "percentage", "usercentrics_release"})
public final class PredefinedUIColorMachine {
    @NotNull
    public static final PredefinedUIColorMachine INSTANCE = new PredefinedUIColorMachine();
    @NotNull
    private static final Color white = new Color(255, 255, 255);

    private PredefinedUIColorMachine() {
    }

    @NotNull
    public final UsercentricsShadedColor generateShadedColor(@NotNull String baseHexColor) {
        Intrinsics.checkNotNullParameter((Object)baseHexColor, (String)"baseHexColor");
        Color baseColor = Color.Companion.fromHex(baseHexColor);
        return new UsercentricsShadedColor(baseColor.toHex(), this.shadedColorBy(baseColor, 0.8), this.shadedColorBy(baseColor, 0.16), this.shadedColorBy(baseColor, 0.02));
    }

    @NotNull
    public final String lightenColor(@NotNull String baseHexColor, double amount) {
        Intrinsics.checkNotNullParameter((Object)baseHexColor, (String)"baseHexColor");
        Color baseColor = Color.Companion.fromHex(baseHexColor);
        double red = Math.min(255.0, (double)baseColor.getRed() + (double)255 * amount);
        double green = Math.min(255.0, (double)baseColor.getGreen() + (double)255 * amount);
        double blue = Math.min(255.0, (double)baseColor.getBlue() + (double)255 * amount);
        return new Color((int)red, (int)green, (int)blue).toHex();
    }

    private final String shadedColorBy(Color baseColor, double percentage) {
        double normalizedWeight = percentage * (double)2 - 1.0;
        double weight1 = (normalizedWeight + 1.0) / 2.0;
        double weight2 = 1.0 - weight1;
        double red = Math.floor((double)baseColor.getRed() * weight1 + (double)white.getRed() * weight2);
        double blue = Math.floor((double)baseColor.getBlue() * weight1 + (double)white.getBlue() * weight2);
        double green = Math.floor((double)baseColor.getGreen() * weight1 + (double)white.getGreen() * weight2);
        return new Color((int)red, (int)green, (int)blue).toHex();
    }
}

