/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.tcf;

import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerDetailsEntry;
import com.usercentrics.sdk.models.tcf.TCFLabels;
import com.usercentrics.sdk.services.tcf.interfaces.IdAndName;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.TCfVendorUrlsKt;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.tcf.core.model.gvl.DataRetention;
import com.usercentrics.tcf.core.model.gvl.VendorUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFDetailsMapperTV;", "", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "labels", "Lcom/usercentrics/sdk/models/tcf/TCFLabels;", "(Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/models/tcf/TCFLabels;)V", "tcf2", "Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "getTcf2", "()Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "getCategoriesOfData", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerDetailsEntry;", "vendor", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendor;", "getDataRetentionPeriod", "getDataSharedOutsideEU", "getFeatures", "getLegitimateInterestPurposes", "getLegitimateInterestURL", "getPolicyURL", "getPurposesProcessedByConsent", "getSpecialFeatures", "getSpecialPurposes", "map", "", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCFDetailsMapperTV.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCFDetailsMapperTV.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFDetailsMapperTV\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1549#2:155\n1620#2,3:156\n1549#2:159\n1620#2,3:160\n1549#2:163\n1620#2,3:164\n1549#2:167\n1620#2,3:168\n*S KotlinDebug\n*F\n+ 1 TCFDetailsMapperTV.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFDetailsMapperTV\n*L\n54#1:155\n54#1:156,3\n80#1:159\n80#1:160,3\n91#1:163\n91#1:164,3\n105#1:167\n105#1:168,3\n*E\n"})
public final class TCFDetailsMapperTV {
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final TCFLabels labels;

    public TCFDetailsMapperTV(@NotNull UsercentricsSettings settings, @NotNull TCFLabels labels) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.settings = settings;
        this.labels = labels;
    }

    private final TCF2Settings getTcf2() {
        TCF2Settings tCF2Settings = this.settings.getTcf2();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        return tCF2Settings;
    }

    @NotNull
    public final List<PredefinedTVSecondLayerDetailsEntry> map(@NotNull TCFVendor vendor) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Object[] objectArray = new PredefinedTVSecondLayerDetailsEntry[]{this.getPurposesProcessedByConsent(vendor), this.getLegitimateInterestPurposes(vendor), this.getSpecialPurposes(vendor), this.getFeatures(vendor), this.getSpecialFeatures(vendor), this.getCategoriesOfData(vendor), this.getDataSharedOutsideEU(vendor), this.getPolicyURL(vendor), this.getLegitimateInterestURL(vendor), this.getDataRetentionPeriod(vendor)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final PredefinedTVSecondLayerDetailsEntry getPurposesProcessedByConsent(TCFVendor vendor) {
        PredefinedTVSecondLayerDetailsEntry predefinedTVSecondLayerDetailsEntry;
        if (!((Collection)vendor.getPurposes()).isEmpty()) {
            DataRetention dataRetention = vendor.getDataRetention();
            predefinedTVSecondLayerDetailsEntry = new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.getTcf2().getVendorPurpose(), PredefinedTVSecondLayerDetailsEntry.Companion.mapPurposesWithRetention$usercentrics_release(vendor.getPurposes(), dataRetention != null ? dataRetention.getPurposes() : null, this.getTcf2().getDataRetentionPeriodLabel()));
        } else {
            predefinedTVSecondLayerDetailsEntry = null;
        }
        return predefinedTVSecondLayerDetailsEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerDetailsEntry getLegitimateInterestPurposes(TCFVendor vendor) {
        PredefinedTVSecondLayerDetailsEntry predefinedTVSecondLayerDetailsEntry;
        if (!((Collection)vendor.getLegitimateInterestPurposes()).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = vendor.getLegitimateInterestPurposes();
            PredefinedTVSecondLayerDetailsEntry.Companion companion = PredefinedTVSecondLayerDetailsEntry.Companion;
            String string = this.getTcf2().getVendorLegitimateInterestPurposes();
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdAndName idAndName = (IdAndName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            String string2 = PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release$default(companion, collection, null, 2, null);
            String string3 = string;
            predefinedTVSecondLayerDetailsEntry = new PredefinedTVSecondLayerDetailsEntry.TitleContent(string3, string2);
        } else {
            predefinedTVSecondLayerDetailsEntry = null;
        }
        return predefinedTVSecondLayerDetailsEntry;
    }

    private final PredefinedTVSecondLayerDetailsEntry getSpecialPurposes(TCFVendor vendor) {
        PredefinedTVSecondLayerDetailsEntry predefinedTVSecondLayerDetailsEntry;
        if (!((Collection)vendor.getSpecialPurposes()).isEmpty()) {
            DataRetention dataRetention = vendor.getDataRetention();
            predefinedTVSecondLayerDetailsEntry = new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.getTcf2().getVendorSpecialPurposes(), PredefinedTVSecondLayerDetailsEntry.Companion.mapPurposesWithRetention$usercentrics_release(vendor.getSpecialPurposes(), dataRetention != null ? dataRetention.getSpecialPurposes() : null, this.getTcf2().getDataRetentionPeriodLabel()));
        } else {
            predefinedTVSecondLayerDetailsEntry = null;
        }
        return predefinedTVSecondLayerDetailsEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerDetailsEntry getFeatures(TCFVendor vendor) {
        PredefinedTVSecondLayerDetailsEntry predefinedTVSecondLayerDetailsEntry;
        if (!((Collection)vendor.getFeatures()).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = vendor.getFeatures();
            PredefinedTVSecondLayerDetailsEntry.Companion companion = PredefinedTVSecondLayerDetailsEntry.Companion;
            String string = this.getTcf2().getVendorFeatures();
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdAndName idAndName = (IdAndName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            String string2 = PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release$default(companion, collection, null, 2, null);
            String string3 = string;
            predefinedTVSecondLayerDetailsEntry = new PredefinedTVSecondLayerDetailsEntry.TitleContent(string3, string2);
        } else {
            predefinedTVSecondLayerDetailsEntry = null;
        }
        return predefinedTVSecondLayerDetailsEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerDetailsEntry getSpecialFeatures(TCFVendor vendor) {
        PredefinedTVSecondLayerDetailsEntry predefinedTVSecondLayerDetailsEntry;
        if (!((Collection)vendor.getSpecialFeatures()).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = vendor.getSpecialFeatures();
            PredefinedTVSecondLayerDetailsEntry.Companion companion = PredefinedTVSecondLayerDetailsEntry.Companion;
            String string = this.getTcf2().getVendorSpecialFeatures();
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdAndName idAndName = (IdAndName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            String string2 = PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release$default(companion, collection, null, 2, null);
            String string3 = string;
            predefinedTVSecondLayerDetailsEntry = new PredefinedTVSecondLayerDetailsEntry.TitleContent(string3, string2);
        } else {
            predefinedTVSecondLayerDetailsEntry = null;
        }
        return predefinedTVSecondLayerDetailsEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerDetailsEntry getCategoriesOfData(TCFVendor vendor) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (vendor.getDataCategories().isEmpty()) {
            return null;
        }
        Iterable iterable = vendor.getDataCategories();
        PredefinedTVSecondLayerDetailsEntry.Companion companion = PredefinedTVSecondLayerDetailsEntry.Companion;
        String string = this.getTcf2().getCategoriesOfDataLabel();
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdAndName idAndName = (IdAndName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        String string2 = PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release$default(companion, collection, null, 2, null);
        String string3 = string;
        return new PredefinedTVSecondLayerDetailsEntry.TitleContent(string3, string2);
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataSharedOutsideEU(TCFVendor vendor) {
        String title = this.settings.getLabels().getTransferToThirdCountries();
        String description = this.labels.getVendorsOutsideEU();
        boolean hasInfo = !StringsKt.isBlank((CharSequence)title) && !StringsKt.isBlank((CharSequence)description);
        return Intrinsics.areEqual((Object)vendor.getDataSharedOutsideEU(), (Object)true) && hasInfo ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(title, description) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getPolicyURL(TCFVendor vendor) {
        Object object = TCfVendorUrlsKt.getVendorUrls(vendor, this.settings);
        if (object == null || (object = ((VendorUrl)object).getPrivacy()) == null) {
            return null;
        }
        Object policyUrl = object;
        return new PredefinedTVSecondLayerDetailsEntry.Link(this.settings.getLabels().getPrivacyPolicyLinkText(), this.settings.getLabels().getPolicyOf(), (String)policyUrl);
    }

    private final PredefinedTVSecondLayerDetailsEntry getLegitimateInterestURL(TCFVendor vendor) {
        Object object = TCfVendorUrlsKt.getVendorUrls(vendor, this.settings);
        if (object == null || (object = ((VendorUrl)object).getLegIntClaim()) == null) {
            return null;
        }
        Object legIntClaimUrl = object;
        return new PredefinedTVSecondLayerDetailsEntry.Link(this.getTcf2().getLegitimateInterestLabel(), this.settings.getLabels().getPolicyOf(), (String)legIntClaimUrl);
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataRetentionPeriod(TCFVendor vendor) {
        DataRetention dataRetention = vendor.getDataRetention();
        if ((dataRetention != null ? dataRetention.getStdRetention() : null) == null) {
            return null;
        }
        return new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.getTcf2().getDataRetentionPeriodLabel(), vendor.getDataRetention().getStdRetention().toString());
    }
}

