/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.api;

import com.usercentrics.sdk.core.hash.UUID;
import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.extensions.TimeExtensionsKt;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.ui.userAgent.UserAgentProvider;
import com.usercentrics.sdk.ui.userAgent.UsercentricsUserAgentInfo;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsApi;
import com.usercentrics.sdk.v2.consent.data.ConsentStatusDto;
import com.usercentrics.sdk.v2.consent.data.ConsentStringObject;
import com.usercentrics.sdk.v2.consent.data.ConsentStringObjectDto;
import com.usercentrics.sdk.v2.consent.data.DataTransferObjectService;
import com.usercentrics.sdk.v2.consent.data.SaveConsentsData;
import com.usercentrics.sdk.v2.consent.data.SaveConsentsDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002JJ\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001d0!H\u0016J\f\u0010#\u001a\u00020$*\u00020%H\u0002J,\u0010#\u001a\u00020&*\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApiImpl;", "Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApi;", "requests", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "userAgentProvider", "Lcom/usercentrics/sdk/ui/userAgent/UserAgentProvider;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/core/json/JsonParser;Lcom/usercentrics/sdk/ui/userAgent/UserAgentProvider;)V", "userAgentInfo", "Lcom/usercentrics/sdk/ui/userAgent/UsercentricsUserAgentInfo;", "getUserAgentInfo", "()Lcom/usercentrics/sdk/ui/userAgent/UsercentricsUserAgentInfo;", "userAgentInfo$delegate", "Lkotlin/Lazy;", "createPayload", "", "consentsData", "Lcom/usercentrics/sdk/v2/consent/data/SaveConsentsData;", "analyticsFlag", "", "xdeviceFlag", "consentWebhook", "getHeaders", "", "getSaveEndpointUrl", "saveConsents", "", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "", "mapDto", "Lcom/usercentrics/sdk/v2/consent/data/ConsentStatusDto;", "Lcom/usercentrics/sdk/v2/consent/data/DataTransferObjectService;", "Lcom/usercentrics/sdk/v2/consent/data/SaveConsentsDto;", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nSaveConsentsApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveConsentsApiImpl.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsApiImpl\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n40#2:111\n40#2:112\n1549#3:113\n1620#3,3:114\n*S KotlinDebug\n*F\n+ 1 SaveConsentsApiImpl.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsApiImpl\n*L\n66#1:111\n81#1:112\n91#1:113\n91#1:114,3\n*E\n"})
public final class SaveConsentsApiImpl
implements SaveConsentsApi {
    @NotNull
    private final HttpRequests requests;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final UserAgentProvider userAgentProvider;
    @NotNull
    private final Lazy userAgentInfo$delegate;

    public SaveConsentsApiImpl(@NotNull HttpRequests requests, @NotNull NetworkResolver networkResolver2, @NotNull JsonParser jsonParser, @NotNull UserAgentProvider userAgentProvider2) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider2, (String)"userAgentProvider");
        this.requests = requests;
        this.networkResolver = networkResolver2;
        this.jsonParser = jsonParser;
        this.userAgentProvider = userAgentProvider2;
        this.userAgentInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UsercentricsUserAgentInfo>(this){
            final /* synthetic */ SaveConsentsApiImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final UsercentricsUserAgentInfo invoke() {
                return SaveConsentsApiImpl.access$getUserAgentProvider$p(this.this$0).provide();
            }
        }));
    }

    private final UsercentricsUserAgentInfo getUserAgentInfo() {
        Lazy lazy = this.userAgentInfo$delegate;
        return (UsercentricsUserAgentInfo)lazy.getValue();
    }

    @Override
    public void saveConsents(@NotNull SaveConsentsData consentsData, boolean analyticsFlag, boolean xdeviceFlag, boolean consentWebhook, @NotNull Function0<Unit> onSuccess2, @NotNull Function1<? super Throwable, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)consentsData, (String)"consentsData");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.requests.post(this.getSaveEndpointUrl(), this.createPayload(consentsData, analyticsFlag, xdeviceFlag, consentWebhook), this.getHeaders(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(onSuccess2){
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onSuccess.invoke();
            }
        }), onError2);
    }

    private final Map<String, String> getHeaders() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Access-Control-Allow-Origin", (Object)"*"), TuplesKt.to((Object)"X-Request-ID", (Object)UUID.INSTANCE.random())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String createPayload(SaveConsentsData consentsData, boolean analyticsFlag, boolean xdeviceFlag, boolean consentWebhook) {
        SaveConsentsDto dto = this.mapDto(consentsData, this.getUserAgentInfo(), analyticsFlag, xdeviceFlag, consentWebhook);
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)SaveConsentsDto.Companion.serializer();
        boolean $i$f$encodeToString = false;
        return JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)dto);
    }

    private final String getSaveEndpointUrl() {
        return this.networkResolver.saveConsentsBaseUrl() + "/consent/ua/3";
    }

    /*
     * WARNING - void declaration
     */
    private final SaveConsentsDto mapDto(SaveConsentsData $this$mapDto, UsercentricsUserAgentInfo userAgentInfo2, boolean analyticsFlag, boolean xdeviceFlag, boolean consentWebhook) {
        Collection<ConsentStatusDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        ConsentStringObjectDto consentMetaPayload;
        Object consentString;
        Object object = $this$mapDto.getConsentStringObject();
        if (object == null || (object = ((ConsentStringObject)object).getString()) == null) {
            object = consentString = "";
        }
        if ((consentMetaPayload = ConsentStringObjectDto.Companion.create(TimeExtensionsKt.secondsToMillis($this$mapDto.getDataTransferObject().getTimestampInSeconds()), $this$mapDto.getConsentStringObject())) == null) {
            string = "";
        } else {
            JsonParser jsonParser = this.jsonParser;
            SerializationStrategy serializer$iv = (SerializationStrategy)ConsentStringObjectDto.Companion.serializer();
            boolean $i$f$encodeToString = false;
            string = JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)consentMetaPayload);
        }
        String consentMeta = string;
        Iterable this_$iv = $this$mapDto.getDataTransferObject().getServices();
        String string2 = consentMeta;
        Object object2 = consentString;
        String string3 = $this$mapDto.getDataTransferObject().getSettings().getVersion();
        String string4 = $this$mapDto.getDataTransferObject().getSettings().getId();
        String string5 = $this$mapDto.getDataTransferObject().getSettings().getLanguage();
        String string6 = $this$mapDto.getDataTransferObject().getSettings().getControllerId();
        String string7 = userAgentInfo2.getAppVersion();
        String string8 = $this$mapDto.getDataTransferObject().getConsent().getAction().getText$usercentrics_release();
        boolean $i$f$map = false;
        void $i$f$encodeToString = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataTransferObjectService dataTransferObjectService = (DataTransferObjectService)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapDto((DataTransferObjectService)it));
        }
        collection = (List)destination$iv$iv;
        String string9 = userAgentInfo2.getAppID();
        String string10 = userAgentInfo2.getSdkVersion();
        String string11 = userAgentInfo2.getPlatform();
        String string12 = $this$mapDto.getAcString();
        if (string12 == null) {
            string12 = "";
        }
        boolean bl = consentWebhook;
        String string13 = string12;
        boolean bl2 = analyticsFlag;
        boolean bl3 = xdeviceFlag;
        String string14 = string11;
        String string15 = string10;
        String string16 = string9;
        Collection<ConsentStatusDto> collection2 = collection;
        String string17 = string2;
        Object object3 = object2;
        String string18 = string3;
        String string19 = string4;
        String string20 = string5;
        String string21 = string6;
        String string22 = string7;
        String string23 = string8;
        return new SaveConsentsDto(string23, string22, string21, string20, string19, string18, (String)object3, string17, (List<ConsentStatusDto>)collection2, string16, string15, string14, bl3, bl2, string13, bl);
    }

    private final ConsentStatusDto mapDto(DataTransferObjectService $this$mapDto) {
        return new ConsentStatusDto($this$mapDto.getStatus(), $this$mapDto.getId(), $this$mapDto.getVersion());
    }

    public static final /* synthetic */ UserAgentProvider access$getUserAgentProvider$p(SaveConsentsApiImpl $this) {
        return $this.userAgentProvider;
    }
}

