/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.etag.cache;

import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.errors.CacheException;
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher;
import com.usercentrics.sdk.v2.async.dispatcher.DispatcherScope;
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage;
import com.usercentrics.sdk.v2.etag.repository.EtagHolder;
import com.usercentrics.sdk.v2.file.IFileStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/usercentrics/sdk/v2/etag/cache/EtagCacheStorage;", "Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;", "fileStorage", "Lcom/usercentrics/sdk/v2/file/IFileStorage;", "dispatcher", "Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;", "(Lcom/usercentrics/sdk/v2/file/IFileStorage;Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;)V", "identifier", "", "boot", "", "checkIfDirtyDirectoriesExist", "decodeEtagFileName", "etagFileName", "defaultEtagPath", "encodeEtagFileName", "etagValue", "etagDirFor", "key", "getRawEtagFileName", "getStoredFile", "offlineEtagPath", "removeOfflineStaging", "restoreOfflineStaging", "saveOfflineStaging", "storeFileAndEtag", "etagHolder", "Lcom/usercentrics/sdk/v2/etag/repository/EtagHolder;", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nEtagCacheStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EtagCacheStorage.kt\ncom/usercentrics/sdk/v2/etag/cache/EtagCacheStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class EtagCacheStorage
implements IEtagCacheStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IFileStorage fileStorage;
    @NotNull
    private final Dispatcher dispatcher;
    @Nullable
    private String identifier;
    @NotNull
    private static final String eTagsDir = "etags";
    @NotNull
    private static final String eTagsOfflineStagingDir = "etags-staging";
    @NotNull
    private static final String etagLanguageParamSeparator = "-";
    @NotNull
    public static final String cacheControlSeparator = "@#$";
    @NotNull
    public static final String settingsDir = "settings-";
    @NotNull
    public static final String translationsDir = "translations-";
    @NotNull
    public static final String languagesDir = "languages";
    @NotNull
    public static final String tcfVendorListDir = "tcf-vendorlist";
    @NotNull
    public static final String tcfDeclarationsDir = "tcf-declarations-";
    @NotNull
    public static final String aggregatorDir = "aggregator-";
    @NotNull
    public static final String ruleSetDir = "ruleSet";
    @NotNull
    public static final String additionalConsentModeDir = "acp";

    public EtagCacheStorage(@NotNull IFileStorage fileStorage2, @NotNull Dispatcher dispatcher2) {
        Intrinsics.checkNotNullParameter((Object)fileStorage2, (String)"fileStorage");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        this.fileStorage = fileStorage2;
        this.dispatcher = dispatcher2;
    }

    @Override
    public void boot(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.identifier = identifier;
        this.checkIfDirtyDirectoriesExist();
    }

    private final void checkIfDirtyDirectoriesExist() {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EtagCacheStorage this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        List<String> directoriesStored;
                        ResultKt.throwOnFailure((Object)object);
                        List<String> list = directoriesStored = EtagCacheStorage.access$getFileStorage$p(this.this$0).ls("");
                        if (list != null) {
                            void $this$forEach$iv;
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            Iterable iterable = list;
                            EtagCacheStorage etagCacheStorage2 = this.this$0;
                            boolean $i$f$filter = false;
                            Iterator<T> iterator2 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                String it = (String)element$iv$iv;
                                boolean bl = false;
                                if (!(!Intrinsics.areEqual((Object)it, (Object)EtagCacheStorage.access$defaultEtagPath(etagCacheStorage2)))) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            etagCacheStorage2 = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                EtagCacheStorage.access$getFileStorage$p(etagCacheStorage2).rmdir(it);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @Nullable
    public String getRawEtagFileName(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<String> list = this.fileStorage.ls(this.etagDirFor(key));
        if (list != null && (list = (String)CollectionsKt.firstOrNull(list)) != null) {
            List<String> it = list;
            boolean bl = false;
            string = this.decodeEtagFileName((String)((Object)it));
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void storeFileAndEtag(@NotNull EtagHolder etagHolder) {
        Intrinsics.checkNotNullParameter((Object)etagHolder, (String)"etagHolder");
        String etagDir = this.etagDirFor(etagHolder.getEtagKey());
        this.fileStorage.rmdir(etagDir);
        this.fileStorage.mkdir(etagDir);
        String etagFileName = this.encodeEtagFileName(etagHolder.getEtagValue());
        long cacheMaxAge = new DateTime().addSeconds(etagHolder.getCacheMaxAge()).timestamp();
        String fileRelativePath = etagDir + "/" + etagFileName + cacheControlSeparator + cacheMaxAge;
        this.fileStorage.storeFile(fileRelativePath, etagHolder.getResponseBody());
    }

    @Override
    @NotNull
    public String getStoredFile(@NotNull String key, @NotNull String etagValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)etagValue, (String)"etagValue");
        String etagFileName = this.encodeEtagFileName(etagValue);
        String string = this.fileStorage.getFile(this.etagDirFor(key) + "/" + etagFileName);
        if (string == null) {
            throw new CacheException(key);
        }
        return string;
    }

    @Override
    public void saveOfflineStaging() {
        this.fileStorage.rmdir(this.offlineEtagPath());
        this.fileStorage.copy(this.defaultEtagPath(), this.offlineEtagPath());
    }

    @Override
    public void removeOfflineStaging() {
        this.fileStorage.rmdir(this.offlineEtagPath());
    }

    @Override
    public void restoreOfflineStaging() {
        this.fileStorage.rmdir(this.defaultEtagPath());
        this.fileStorage.copy(this.offlineEtagPath(), this.defaultEtagPath());
        this.fileStorage.rmdir(this.offlineEtagPath());
    }

    private final String etagDirFor(String key) {
        return this.defaultEtagPath() + "/" + key;
    }

    private final String defaultEtagPath() {
        return "etags-" + this.identifier;
    }

    private final String offlineEtagPath() {
        return "etags-staging-" + this.identifier;
    }

    private final String encodeEtagFileName(String etagValue) {
        return StringsKt.removeSurrounding((String)etagValue, (CharSequence)"\"");
    }

    private final String decodeEtagFileName(String etagFileName) {
        return "\"" + etagFileName + "\"";
    }

    public static final /* synthetic */ IFileStorage access$getFileStorage$p(EtagCacheStorage $this) {
        return $this.fileStorage;
    }

    public static final /* synthetic */ String access$defaultEtagPath(EtagCacheStorage $this) {
        return $this.defaultEtagPath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/v2/etag/cache/EtagCacheStorage$Companion;", "", "()V", "additionalConsentModeDir", "", "aggregatorDir", "cacheControlSeparator", "eTagsDir", "eTagsOfflineStagingDir", "etagLanguageParamSeparator", "languagesDir", "ruleSetDir", "settingsDir", "tcfDeclarationsDir", "tcfVendorListDir", "translationsDir", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

