/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.ccpa;

import com.usercentrics.ccpa.CCPAData;
import com.usercentrics.ccpa.CCPAException;
import com.usercentrics.ccpa.CCPAStorage;
import com.usercentrics.ccpa.CCPAStringValidator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0006H\u0002J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/usercentrics/ccpa/CcpaApi;", "", "storage", "Lcom/usercentrics/ccpa/CCPAStorage;", "debug", "Lkotlin/Function1;", "", "", "(Lcom/usercentrics/ccpa/CCPAStorage;Lkotlin/jvm/functions/Function1;)V", "checkApiVersion", "apiVersion", "", "getPrivacyData", "Lcom/usercentrics/ccpa/CCPAData;", "getPrivacyDataAsString", "getStringFromStorage", "setPrivacyData", "ccpaData", "Companion", "usercentrics_release"})
public final class CcpaApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CCPAStorage storage;
    @NotNull
    private final Function1<String, Unit> debug;
    @NotNull
    public static final String privacyStringStorageKey = "IABUSPrivacy_String";
    public static final int supportedApiVersion = 1;

    public CcpaApi(@NotNull CCPAStorage storage, @NotNull Function1<? super String, Unit> debug) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(debug, (String)"debug");
        this.storage = storage;
        this.debug = debug;
    }

    public /* synthetic */ CcpaApi(CCPAStorage cCPAStorage, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(cCPAStorage, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public final String getPrivacyDataAsString(int apiVersion) {
        this.checkApiVersion(apiVersion);
        return this.getStringFromStorage();
    }

    @NotNull
    public final CCPAData getPrivacyData(int apiVersion) {
        String ccpaString = this.getPrivacyDataAsString(apiVersion);
        return CCPAData.Companion.fromCCPAString(ccpaString);
    }

    public final void setPrivacyData(int apiVersion, @NotNull CCPAData ccpaData) {
        Intrinsics.checkNotNullParameter((Object)ccpaData, (String)"ccpaData");
        this.checkApiVersion(apiVersion);
        String ccpaString = ccpaData.getUspString();
        if (!CCPAStringValidator.INSTANCE.isValidString(ccpaString)) {
            throw CCPAException.Companion.invalidString(ccpaString);
        }
        this.storage.putValue(privacyStringStorageKey, ccpaString);
    }

    private final void checkApiVersion(int apiVersion) {
        if (apiVersion != 1) {
            throw CCPAException.Companion.invalidVersion(1, apiVersion);
        }
    }

    private final String getStringFromStorage() {
        String storedString;
        String string = storedString = this.storage.getValue(privacyStringStorageKey, "");
        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            boolean isValid = CCPAStringValidator.INSTANCE.isValidString(storedString);
            if (isValid) {
                return storedString;
            }
            this.debug.invoke((Object)("Stored CCPA String is invalid: " + storedString));
            this.storage.deleteKey(privacyStringStorageKey);
        }
        return "1---";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/usercentrics/ccpa/CcpaApi$Companion;", "", "()V", "privacyStringStorageKey", "", "supportedApiVersion", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

