/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.models.settings;

import com.usercentrics.sdk.AdTechProvider;
import com.usercentrics.sdk.UserDecision;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedUIDecision;
import com.usercentrics.sdk.models.settings.serviceType.BaseServiceType;
import com.usercentrics.sdk.models.settings.serviceType.GDPRServiceType;
import com.usercentrics.sdk.models.settings.serviceType.TCFServiceType;
import com.usercentrics.sdk.services.tcf.interfaces.AdTechProviderDecision;
import com.usercentrics.sdk.services.tcf.interfaces.TCFFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFStack;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnSpecialFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnVendor;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisions;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/sdk/models/settings/ServicesIdStrategy;", "", "()V", "Companion", "usercentrics_release"})
public final class ServicesIdStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"J\u0014\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"\u00a8\u0006("}, d2={"Lcom/usercentrics/sdk/models/settings/ServicesIdStrategy$Companion;", "", "()V", "actualServiceId", "", "serviceId", "id", "adTechProvider", "Lcom/usercentrics/sdk/AdTechProvider;", "service", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "feature", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFFeature;", "purpose", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFPurpose;", "specialFeature", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFSpecialFeature;", "specialPurpose", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFSpecialPurpose;", "stack", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFStack;", "vendor", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendor;", "category", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsCategory;", "isGDPRDecision", "", "isTCFDecision", "matchesServiceType", "serviceType", "Lcom/usercentrics/sdk/models/settings/serviceType/BaseServiceType;", "tcfServiceType", "Lcom/usercentrics/sdk/models/settings/serviceType/TCFServiceType;", "userDecisionsGDPR", "", "Lcom/usercentrics/sdk/UserDecision;", "userDecisions", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDecision;", "userDecisionsTCF", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFUserDecisions;", "usercentrics_release"})
    @SourceDebugExtension(value={"SMAP\nServicesIdStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServicesIdStrategy.kt\ncom/usercentrics/sdk/models/settings/ServicesIdStrategy$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n766#2:137\n857#2,2:138\n1603#2,9:140\n1855#2:149\n1856#2:151\n1612#2:152\n766#2:153\n857#2,2:154\n1855#2,2:156\n1#3:150\n1#3:162\n1282#4,2:158\n12474#4,2:160\n*S KotlinDebug\n*F\n+ 1 ServicesIdStrategy.kt\ncom/usercentrics/sdk/models/settings/ServicesIdStrategy$Companion\n*L\n53#1:137\n53#1:138,2\n54#1:140,9\n54#1:149\n54#1:151\n54#1:152\n64#1:153\n64#1:154,2\n79#1:156,2\n54#1:150\n120#1:158,2\n124#1:160,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String id(@NotNull UsercentricsCategory category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            return GDPRServiceType.CATEGORY.getPrefix() + "=" + category.getCategorySlug();
        }

        @NotNull
        public final String id(@NotNull LegacyService service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            return GDPRServiceType.SERVICE.getPrefix() + "=" + service.getId();
        }

        @NotNull
        public final String id(@NotNull TCFVendor vendor) {
            Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
            return TCFServiceType.VENDOR.getPrefix() + "=" + vendor.getId();
        }

        @NotNull
        public final String id(@NotNull TCFStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return TCFServiceType.STACK.getPrefix() + "=" + stack.getId();
        }

        @NotNull
        public final String id(@NotNull TCFSpecialFeature specialFeature) {
            Intrinsics.checkNotNullParameter((Object)specialFeature, (String)"specialFeature");
            return TCFServiceType.SPECIAL_FEATURE.getPrefix() + "=" + specialFeature.getId();
        }

        @NotNull
        public final String id(@NotNull TCFPurpose purpose) {
            Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
            return TCFServiceType.PURPOSE.getPrefix() + "=" + purpose.getId();
        }

        @NotNull
        public final String id(@NotNull TCFSpecialPurpose specialPurpose) {
            Intrinsics.checkNotNullParameter((Object)specialPurpose, (String)"specialPurpose");
            return TCFServiceType.SPECIAL_PURPOSE.getPrefix() + "=" + specialPurpose.getId();
        }

        @NotNull
        public final String id(@NotNull TCFFeature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            return TCFServiceType.FEATURE.getPrefix() + "=" + feature.getId();
        }

        @NotNull
        public final String id(@NotNull AdTechProvider adTechProvider) {
            Intrinsics.checkNotNullParameter((Object)adTechProvider, (String)"adTechProvider");
            return TCFServiceType.AD_TECH_PROVIDER.getPrefix() + "=" + adTechProvider.getId();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<UserDecision> userDecisionsGDPR(@NotNull List<PredefinedUIDecision> userDecisions) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(userDecisions, (String)"userDecisions");
            Iterable $this$filter$iv = userDecisions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PredefinedUIDecision userDecision = (PredefinedUIDecision)element$iv$iv;
                boolean bl = false;
                if (!Companion.isGDPRDecision(userDecision.getServiceId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                UserDecision it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                PredefinedUIDecision userDecision = (PredefinedUIDecision)element$iv$iv;
                boolean bl2 = false;
                Boolean consentStatus = userDecision.consent();
                if ((consentStatus != null ? new UserDecision(Companion.actualServiceId(userDecision.getServiceId()), consentStatus) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TCFUserDecisions userDecisionsTCF(@NotNull List<PredefinedUIDecision> userDecisions) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(userDecisions, (String)"userDecisions");
            Iterable $this$filter$iv = userDecisions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PredefinedUIDecision userDecision = (PredefinedUIDecision)element$iv$iv;
                boolean bl = false;
                if (!Companion.isTCFDecision(userDecision.getServiceId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tcfDecisions = (List)destination$iv$iv;
            if (tcfDecisions.isEmpty()) {
                return new TCFUserDecisions(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            List purposes2 = new ArrayList();
            List specialFeatures = new ArrayList();
            List vendors = new ArrayList();
            List adTechProviders = new ArrayList();
            Iterable $this$forEach$iv = tcfDecisions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PredefinedUIDecision userDecision = (PredefinedUIDecision)element$iv;
                boolean bl = false;
                int actualServiceId = Integer.parseInt(Companion.actualServiceId(userDecision.getServiceId()));
                TCFServiceType tCFServiceType = Companion.tcfServiceType(userDecision.getServiceId());
                switch (tCFServiceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tCFServiceType.ordinal()]) {
                    case 1: {
                        vendors.add(new TCFUserDecisionOnVendor(actualServiceId, userDecision.consent(), userDecision.legitimateInterest()));
                        break;
                    }
                    case 2: {
                        specialFeatures.add(new TCFUserDecisionOnSpecialFeature(actualServiceId, userDecision.consent()));
                        break;
                    }
                    case 3: {
                        purposes2.add(new TCFUserDecisionOnPurpose(actualServiceId, userDecision.consent(), userDecision.legitimateInterest()));
                        break;
                    }
                    case 4: {
                        Boolean bl2 = userDecision.consent();
                        adTechProviders.add(new AdTechProviderDecision(actualServiceId, bl2 != null ? bl2 : false));
                    }
                }
            }
            return new TCFUserDecisions(purposes2, specialFeatures, vendors, adTechProviders);
        }

        private final boolean isTCFDecision(String serviceId) {
            return this.tcfServiceType(serviceId) != null;
        }

        private final TCFServiceType tcfServiceType(String serviceId) {
            TCFServiceType tCFServiceType;
            block1: {
                TCFServiceType[] $this$firstOrNull$iv = TCFServiceType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    TCFServiceType element$iv;
                    TCFServiceType serviceType = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Companion.matchesServiceType(serviceId, serviceType)) continue;
                    tCFServiceType = element$iv;
                    break block1;
                }
                tCFServiceType = null;
            }
            return tCFServiceType;
        }

        private final boolean isGDPRDecision(String serviceId) {
            boolean bl;
            block1: {
                GDPRServiceType[] $this$any$iv = GDPRServiceType.values();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    GDPRServiceType element$iv;
                    GDPRServiceType serviceType = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!Companion.matchesServiceType(serviceId, serviceType)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean matchesServiceType(String serviceId, BaseServiceType serviceType) {
            return StringsKt.startsWith$default((String)serviceId, (String)serviceType.getPrefix(), (boolean)false, (int)2, null);
        }

        private final String actualServiceId(String serviceId) {
            Object object = new char[]{'='};
            int n = 1;
            if (n > CollectionsKt.getLastIndex((List)(object = (Object)StringsKt.split$default((CharSequence)serviceId, (char[])object, (boolean)false, (int)0, (int)6, null)))) {
                int it = n;
                boolean bl = false;
                throw new IllegalStateException("invalid id".toString());
            }
            return (String)object.get(n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TCFServiceType.values().length];
                try {
                    nArray[TCFServiceType.VENDOR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.SPECIAL_FEATURE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.PURPOSE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.AD_TECH_PROVIDER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.SPECIAL_PURPOSE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.FEATURE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TCFServiceType.STACK.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

