/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.predefinedUI;

import com.usercentrics.sdk.UserDecision;
import com.usercentrics.sdk.UsercentricsAnalyticsEventType;
import com.usercentrics.sdk.UsercentricsSDK;
import com.usercentrics.sdk.UsercentricsServiceConsent;
import com.usercentrics.sdk.models.common.UsercentricsVariant;
import com.usercentrics.sdk.models.settings.PredefinedUIDecision;
import com.usercentrics.sdk.models.settings.ServicesIdStrategy;
import com.usercentrics.sdk.models.settings.UsercentricsConsentType;
import com.usercentrics.sdk.predefinedUI.PredefinedUIConsentManager;
import com.usercentrics.sdk.services.tcf.TCFDecisionUILayer;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisions;
import com.usercentrics.sdk.ui.PredefinedUIInteraction;
import com.usercentrics.sdk.ui.PredefinedUIResponse;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eH\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eH\u0002J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/usercentrics/sdk/predefinedUI/PredefinedUIConsentManagerImpl;", "Lcom/usercentrics/sdk/predefinedUI/PredefinedUIConsentManager;", "usercentricsSDK", "Lcom/usercentrics/sdk/UsercentricsSDK;", "variant", "Lcom/usercentrics/sdk/models/common/UsercentricsVariant;", "controllerId", "", "(Lcom/usercentrics/sdk/UsercentricsSDK;Lcom/usercentrics/sdk/models/common/UsercentricsVariant;Ljava/lang/String;)V", "acceptAll", "Lcom/usercentrics/sdk/ui/PredefinedUIResponse;", "fromLayer", "Lcom/usercentrics/sdk/services/tcf/TCFDecisionUILayer;", "acceptAllCCPA", "", "Lcom/usercentrics/sdk/UsercentricsServiceConsent;", "acceptAllDefault", "acceptAllTCF", "close", "denyAll", "denyAllCCPA", "denyAllDefault", "denyAllTCF", "save", "userDecisions", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDecision;", "saveDecisionsDefault", "saveDecisionsTCF", "trackAnalyticsEvent", "", "eventType", "Lcom/usercentrics/sdk/UsercentricsAnalyticsEventType;", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nPredefinedUIConsentManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PredefinedUIConsentManagerImpl.kt\ncom/usercentrics/sdk/predefinedUI/PredefinedUIConsentManagerImpl\n+ 2 Assertions.kt\ncom/usercentrics/sdk/AssertionsKt\n*L\n1#1,156:1\n5#2:157\n5#2:158\n5#2:159\n5#2:160\n5#2:161\n*S KotlinDebug\n*F\n+ 1 PredefinedUIConsentManagerImpl.kt\ncom/usercentrics/sdk/predefinedUI/PredefinedUIConsentManagerImpl\n*L\n54#1:157\n95#1:158\n104#1:159\n110#1:160\n135#1:161\n*E\n"})
public final class PredefinedUIConsentManagerImpl
implements PredefinedUIConsentManager {
    @NotNull
    private final UsercentricsSDK usercentricsSDK;
    @NotNull
    private final UsercentricsVariant variant;
    @NotNull
    private final String controllerId;

    public PredefinedUIConsentManagerImpl(@NotNull UsercentricsSDK usercentricsSDK, @NotNull UsercentricsVariant variant, @NotNull String controllerId) {
        Intrinsics.checkNotNullParameter((Object)usercentricsSDK, (String)"usercentricsSDK");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        this.usercentricsSDK = usercentricsSDK;
        this.variant = variant;
        this.controllerId = controllerId;
    }

    @Override
    @NotNull
    public PredefinedUIResponse acceptAll(@NotNull TCFDecisionUILayer fromLayer) {
        List<UsercentricsServiceConsent> list;
        Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
        switch (WhenMappings.$EnumSwitchMapping$0[this.variant.ordinal()]) {
            case 1: {
                list = this.acceptAllDefault();
                break;
            }
            case 2: {
                list = this.acceptAllCCPA();
                break;
            }
            case 3: {
                list = this.acceptAllTCF(fromLayer);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List<UsercentricsServiceConsent> consents = list;
        UsercentricsAnalyticsEventType eventType = fromLayer == TCFDecisionUILayer.FIRST_LAYER ? UsercentricsAnalyticsEventType.ACCEPT_ALL_FIRST_LAYER : UsercentricsAnalyticsEventType.ACCEPT_ALL_SECOND_LAYER;
        this.trackAnalyticsEvent(eventType);
        return new PredefinedUIResponse(PredefinedUIInteraction.ACCEPT_ALL, consents, this.controllerId);
    }

    private final List<UsercentricsServiceConsent> acceptAllDefault() {
        return this.usercentricsSDK.acceptAll(UsercentricsConsentType.EXPLICIT);
    }

    private final List<UsercentricsServiceConsent> acceptAllCCPA() {
        return this.usercentricsSDK.saveOptOutForCCPA(false, UsercentricsConsentType.EXPLICIT);
    }

    private final List<UsercentricsServiceConsent> acceptAllTCF(TCFDecisionUILayer fromLayer) {
        boolean value$iv = fromLayer != null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string = "Failed while trying to accept all services: fromLayer parameter cannot be null";
            throw new AssertionError((Object)string);
        }
        TCFDecisionUILayer tCFDecisionUILayer = fromLayer;
        if (tCFDecisionUILayer == null) {
            tCFDecisionUILayer = TCFDecisionUILayer.FIRST_LAYER;
        }
        return this.usercentricsSDK.acceptAllForTCF(tCFDecisionUILayer, UsercentricsConsentType.EXPLICIT);
    }

    @Override
    @NotNull
    public PredefinedUIResponse denyAll(@NotNull TCFDecisionUILayer fromLayer) {
        List<UsercentricsServiceConsent> list;
        Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
        switch (WhenMappings.$EnumSwitchMapping$0[this.variant.ordinal()]) {
            case 1: {
                list = this.denyAllDefault();
                break;
            }
            case 2: {
                list = this.denyAllCCPA();
                break;
            }
            case 3: {
                list = this.denyAllTCF(fromLayer);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List<UsercentricsServiceConsent> consents = list;
        UsercentricsAnalyticsEventType eventType = fromLayer == TCFDecisionUILayer.FIRST_LAYER ? UsercentricsAnalyticsEventType.DENY_ALL_FIRST_LAYER : UsercentricsAnalyticsEventType.DENY_ALL_SECOND_LAYER;
        this.trackAnalyticsEvent(eventType);
        return new PredefinedUIResponse(PredefinedUIInteraction.DENY_ALL, consents, this.controllerId);
    }

    private final List<UsercentricsServiceConsent> denyAllDefault() {
        return this.usercentricsSDK.denyAll(UsercentricsConsentType.EXPLICIT);
    }

    private final List<UsercentricsServiceConsent> denyAllCCPA() {
        return this.usercentricsSDK.saveOptOutForCCPA(true, UsercentricsConsentType.EXPLICIT);
    }

    private final List<UsercentricsServiceConsent> denyAllTCF(TCFDecisionUILayer fromLayer) {
        boolean value$iv = fromLayer != null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string = "Failed while trying to deny all services: fromLayer parameter cannot be null";
            throw new AssertionError((Object)string);
        }
        TCFDecisionUILayer tCFDecisionUILayer = fromLayer;
        if (tCFDecisionUILayer == null) {
            tCFDecisionUILayer = TCFDecisionUILayer.FIRST_LAYER;
        }
        return this.usercentricsSDK.denyAllForTCF(tCFDecisionUILayer, UsercentricsConsentType.EXPLICIT);
    }

    @Override
    @NotNull
    public PredefinedUIResponse save(@NotNull TCFDecisionUILayer fromLayer, @NotNull List<PredefinedUIDecision> userDecisions) {
        List<UsercentricsServiceConsent> list;
        Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
        Intrinsics.checkNotNullParameter(userDecisions, (String)"userDecisions");
        boolean value$iv = !((Collection)userDecisions).isEmpty();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string = "Failed while trying to save decisions: userDecisions parameter cannot be empty";
            throw new AssertionError((Object)string);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.variant.ordinal()]) {
            case 3: {
                list = this.saveDecisionsTCF(userDecisions, fromLayer);
                break;
            }
            case 1: {
                list = this.saveDecisionsDefault(userDecisions);
                break;
            }
            case 2: {
                boolean value$iv2 = false;
                boolean $i$f$assert2 = false;
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string = "Failed while trying to save decisions for CCPA: this variant does not allow granular decisions";
                    throw new AssertionError((Object)string);
                }
                list = this.saveDecisionsDefault(userDecisions);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List<UsercentricsServiceConsent> consents = list;
        UsercentricsAnalyticsEventType eventType = fromLayer == TCFDecisionUILayer.FIRST_LAYER ? UsercentricsAnalyticsEventType.SAVE_FIRST_LAYER : UsercentricsAnalyticsEventType.SAVE_SECOND_LAYER;
        this.trackAnalyticsEvent(eventType);
        return new PredefinedUIResponse(PredefinedUIInteraction.GRANULAR, consents, this.controllerId);
    }

    private final List<UsercentricsServiceConsent> saveDecisionsDefault(List<PredefinedUIDecision> userDecisions) {
        List<UserDecision> userDecisionsForDefault = ServicesIdStrategy.Companion.userDecisionsGDPR(userDecisions);
        return this.usercentricsSDK.saveDecisions(userDecisionsForDefault, UsercentricsConsentType.EXPLICIT);
    }

    private final List<UsercentricsServiceConsent> saveDecisionsTCF(List<PredefinedUIDecision> userDecisions, TCFDecisionUILayer fromLayer) {
        boolean value$iv = fromLayer != null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string = "Failed while trying to save TCF decisions: fromLayer parameter cannot be null";
            throw new AssertionError((Object)string);
        }
        UsercentricsSDK usercentricsSDK = this.usercentricsSDK;
        TCFUserDecisions tCFUserDecisions = ServicesIdStrategy.Companion.userDecisionsTCF(userDecisions);
        List<UserDecision> list = ServicesIdStrategy.Companion.userDecisionsGDPR(userDecisions);
        TCFDecisionUILayer tCFDecisionUILayer = fromLayer;
        if (tCFDecisionUILayer == null) {
            tCFDecisionUILayer = TCFDecisionUILayer.FIRST_LAYER;
        }
        TCFDecisionUILayer tCFDecisionUILayer2 = tCFDecisionUILayer;
        UsercentricsConsentType usercentricsConsentType = UsercentricsConsentType.EXPLICIT;
        return usercentricsSDK.saveDecisionsForTCF(tCFUserDecisions, tCFDecisionUILayer2, list, usercentricsConsentType);
    }

    @Override
    @NotNull
    public PredefinedUIResponse close() {
        return new PredefinedUIResponse(PredefinedUIInteraction.NO_INTERACTION, this.usercentricsSDK.getConsents(), this.controllerId);
    }

    private final void trackAnalyticsEvent(UsercentricsAnalyticsEventType eventType) {
        this.usercentricsSDK.track(eventType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UsercentricsVariant.values().length];
            try {
                nArray[UsercentricsVariant.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsercentricsVariant.CCPA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsercentricsVariant.TCF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

