/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.gdpr;

import com.usercentrics.sdk.UsercentricsAnalyticsEventType;
import com.usercentrics.sdk.extensions.ArrayExtensionsKt;
import com.usercentrics.sdk.models.gdpr.DefaultLabels;
import com.usercentrics.sdk.models.settings.LegacyPoweredBy;
import com.usercentrics.sdk.models.settings.PredefinedTVActionButton;
import com.usercentrics.sdk.models.settings.PredefinedTVActionButtonType;
import com.usercentrics.sdk.models.settings.PredefinedTVFirstLayerSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIButtonType;
import com.usercentrics.sdk.models.settings.PredefinedUICustomization;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorButton;
import com.usercentrics.sdk.models.settings.PredefinedUIFirstLayerHeaderSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterButton;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterEntry;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIHeaderSettings;
import com.usercentrics.sdk.models.settings.PredefinedUILink;
import com.usercentrics.sdk.models.settings.UCUIFirstLayerSettings;
import com.usercentrics.sdk.v2.banner.service.mapper.FooterButtonLayoutMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.PoweredByMapper;
import com.usercentrics.sdk.v2.settings.data.FirstLayer;
import com.usercentrics.sdk.v2.settings.data.FirstLayerCloseOption;
import com.usercentrics.sdk.v2.settings.data.FirstLayerLogoPosition;
import com.usercentrics.sdk.v2.settings.data.FirstLayerMobileVariant;
import com.usercentrics.sdk.v2.settings.data.SecondLayerTrigger;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCustomization;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRFirstLayerMapper;", "", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "customization", "Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;", "labels", "Lcom/usercentrics/sdk/models/gdpr/DefaultLabels;", "(Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;Lcom/usercentrics/sdk/models/gdpr/DefaultLabels;)V", "footer", "Lcom/usercentrics/sdk/models/settings/PredefinedUIFooterSettings;", "footerButtonsMapper", "Lcom/usercentrics/sdk/v2/banner/service/mapper/FooterButtonLayoutMapper;", "header", "Lcom/usercentrics/sdk/models/settings/PredefinedUIHeaderSettings;", "headerLinks", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUILink;", "map", "Lcom/usercentrics/sdk/models/settings/UCUIFirstLayerSettings;", "mapTV", "Lcom/usercentrics/sdk/models/settings/PredefinedTVFirstLayerSettings;", "poweredBy", "Lcom/usercentrics/sdk/models/settings/PredefinedUIFooterEntry;", "showDenyAllButton", "", "tvButtons", "Lcom/usercentrics/sdk/models/settings/PredefinedTVActionButton;", "tvLinks", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nGDPRFirstLayerMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GDPRFirstLayerMapper.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRFirstLayerMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n766#2:169\n857#2,2:170\n766#2:172\n857#2,2:173\n766#2:175\n857#2,2:176\n*S KotlinDebug\n*F\n+ 1 GDPRFirstLayerMapper.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRFirstLayerMapper\n*L\n87#1:169\n87#1:170,2\n149#1:172\n149#1:173,2\n161#1:175\n161#1:176,2\n*E\n"})
public final class GDPRFirstLayerMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final PredefinedUICustomization customization;
    @NotNull
    private final DefaultLabels labels;
    @NotNull
    private static final FirstLayerLogoPosition defaultLogoPosition = FirstLayerLogoPosition.LEFT;

    public GDPRFirstLayerMapper(@NotNull UsercentricsSettings settings, @NotNull PredefinedUICustomization customization, @NotNull DefaultLabels labels) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.settings = settings;
        this.customization = customization;
        this.labels = labels;
    }

    @NotNull
    public final UCUIFirstLayerSettings map() {
        Object object = this.settings.getFirstLayer();
        if (object == null || (object = object.getMobileVariant()) == null) {
            object = UCUIFirstLayerSettings.Companion.getDefaultLayout$usercentrics_release();
        }
        return new UCUIFirstLayerSettings((FirstLayerMobileVariant)((Object)object), this.header(), this.footer(), CollectionsKt.emptyList());
    }

    @NotNull
    public final PredefinedTVFirstLayerSettings mapTV() {
        String shortDescription = this.settings.getBannerMobileDescriptionIsActive() ? ArrayExtensionsKt.emptyToNull(this.settings.getFirstLayerMobileDescriptionHtml()) : null;
        String string = this.settings.getLabels().getFirstLayerTitle();
        String string2 = shortDescription;
        if (string2 == null && (string2 = this.settings.getFirstLayerDescriptionHtml()) == null) {
            string2 = "";
        }
        UsercentricsCustomization usercentricsCustomization = this.settings.getCustomization();
        return new PredefinedTVFirstLayerSettings(string, string2, usercentricsCustomization != null ? usercentricsCustomization.getLogoUrl() : null, this.tvButtons(), this.tvLinks());
    }

    private final PredefinedUIHeaderSettings header() {
        String shortDescription = this.settings.getBannerMobileDescriptionIsActive() ? this.settings.getFirstLayerMobileDescriptionHtml() : null;
        FirstLayer firstLayer = this.settings.getFirstLayer();
        String closeLink = (firstLayer != null ? firstLayer.getCloseOption() : null) == FirstLayerCloseOption.LINK ? this.labels.getGeneral().getContinueWithoutAccepting() : null;
        String string = this.settings.getFirstLayerDescriptionHtml();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        String string3 = this.settings.getLabels().getFirstLayerTitle();
        Object object = this.settings.getFirstLayer();
        if (object == null || (object = object.getLogoPosition()) == null) {
            object = defaultLogoPosition;
        }
        Object object2 = object;
        UsercentricsCustomization usercentricsCustomization = this.settings.getCustomization();
        String string4 = usercentricsCustomization != null ? usercentricsCustomization.getLogoUrl() : null;
        List<PredefinedUILink> list = this.headerLinks();
        String string5 = ArrayExtensionsKt.emptyToNull(closeLink);
        Object object3 = this.settings.getFirstLayer();
        Boolean bl = object3 != null && (object3 = ((FirstLayer)object3).getCloseOption()) != null ? Boolean.valueOf(((Enum)object3).equals((Object)FirstLayerCloseOption.ICON)) : null;
        String string6 = this.settings.getLabels().getBtnBannerReadMore();
        return new PredefinedUIFirstLayerHeaderSettings(string3, shortDescription, string2, list, (FirstLayerLogoPosition)((Object)object2), string4, null, string5, bl, string6);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PredefinedUILink> headerLinks() {
        void $this$filterTo$iv$iv;
        PredefinedUILink privacyLink = PredefinedUILink.Companion.legalLinkUrl(this.settings.getLabels().getPrivacyPolicyLinkText(), this.settings.getPrivacyPolicyUrl(), UsercentricsAnalyticsEventType.PRIVACY_POLICY_LINK);
        PredefinedUILink imprintLink = PredefinedUILink.Companion.legalLinkUrl(this.settings.getLabels().getImprintLinkText(), this.settings.getImprintUrl(), UsercentricsAnalyticsEventType.IMPRINT_LINK);
        FirstLayer firstLayer = this.settings.getFirstLayer();
        PredefinedUILink moreLink = (firstLayer != null ? firstLayer.getSecondLayerTrigger() : null) == SecondLayerTrigger.LINK ? PredefinedUILink.Companion.moreLink(this.settings.getLabels().getBtnMore()) : null;
        Object[] objectArray = new PredefinedUILink[]{privacyLink, imprintLink, moreLink};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PredefinedUILink it = (PredefinedUILink)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty$usercentrics_release())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PredefinedUIFooterSettings footer() {
        FooterButtonLayoutMapper buttonLayoutMapper = this.footerButtonsMapper();
        return new PredefinedUIFooterSettings(this.poweredBy(), null, false, buttonLayoutMapper.mapButtons(), buttonLayoutMapper.mapButtonsLandscape(), 6, null);
    }

    private final PredefinedUIFooterEntry poweredBy() {
        return PoweredByMapper.INSTANCE.mapPoweredBy(new LegacyPoweredBy(this.settings.getEnablePoweredBy(), null, null, 6, null));
    }

    private final FooterButtonLayoutMapper footerButtonsMapper() {
        PredefinedUIFooterButton predefinedUIFooterButton;
        PredefinedUIFooterButton manageSettingsButton;
        PredefinedUIFooterButton predefinedUIFooterButton2;
        Object object;
        String string = this.settings.getLabels().getBtnAcceptAll();
        Object object2 = this.customization.getColor().getAcceptAllButton();
        Object object3 = PredefinedUIButtonType.ACCEPT_ALL;
        PredefinedUIFooterButton acceptAllButton = new PredefinedUIFooterButton(string, (PredefinedUIButtonType)((Object)object3), (PredefinedUICustomizationColorButton)object2);
        FirstLayer firstLayer = this.settings.getFirstLayer();
        if ((firstLayer != null ? firstLayer.getSecondLayerTrigger() : null) == SecondLayerTrigger.BUTTON) {
            object2 = this.settings.getLabels().getBtnMore();
            object3 = this.customization.getColor().getManageButton();
            object = PredefinedUIButtonType.MANAGE_SETTINGS;
            predefinedUIFooterButton2 = new PredefinedUIFooterButton((String)object2, (PredefinedUIButtonType)((Object)object), (PredefinedUICustomizationColorButton)object3);
        } else {
            predefinedUIFooterButton2 = manageSettingsButton = null;
        }
        if (this.showDenyAllButton()) {
            object3 = this.settings.getLabels().getBtnDeny();
            object = this.customization.getColor().getDenyAllButton();
            PredefinedUIButtonType predefinedUIButtonType = PredefinedUIButtonType.DENY_ALL;
            predefinedUIFooterButton = new PredefinedUIFooterButton((String)object3, predefinedUIButtonType, (PredefinedUICustomizationColorButton)object);
        } else {
            predefinedUIFooterButton = null;
        }
        PredefinedUIFooterButton denyAllButton = predefinedUIFooterButton;
        return new FooterButtonLayoutMapper(acceptAllButton, denyAllButton, null, null, manageSettingsButton, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PredefinedTVActionButton> tvButtons() {
        void $this$filterTo$iv$iv;
        PredefinedTVActionButton denyAllButton = this.showDenyAllButton() ? new PredefinedTVActionButton(this.settings.getLabels().getBtnDeny(), PredefinedTVActionButtonType.DenyAll.INSTANCE) : null;
        Object[] objectArray = new PredefinedTVActionButton[]{new PredefinedTVActionButton(this.settings.getLabels().getBtnAcceptAll(), PredefinedTVActionButtonType.AcceptAll.INSTANCE), denyAllButton, new PredefinedTVActionButton(this.settings.getLabels().getBtnMore(), new PredefinedTVActionButtonType.More(null, 1, null))};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PredefinedTVActionButton it = (PredefinedTVActionButton)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.getLabel()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PredefinedTVActionButton> tvLinks() {
        void $this$filterTo$iv$iv;
        PredefinedTVActionButton predefinedTVActionButton;
        PredefinedTVActionButton predefinedTVActionButton2;
        PredefinedTVActionButton predefinedTVActionButton3;
        String it;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = new PredefinedTVActionButton[2];
        int n2 = 0;
        String string = this.settings.getPrivacyPolicyUrl();
        if (string != null) {
            String string2 = string;
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            predefinedTVActionButton3 = new PredefinedTVActionButton(this.settings.getLabels().getPrivacyPolicyLinkText(), new PredefinedTVActionButtonType.Url(it));
            objectArray3 = objectArray;
            n2 = n;
            predefinedTVActionButton2 = predefinedTVActionButton3;
        } else {
            predefinedTVActionButton2 = null;
        }
        objectArray3[n2] = predefinedTVActionButton2;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        String string3 = this.settings.getImprintUrl();
        if (string3 != null) {
            it = string3;
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            predefinedTVActionButton3 = new PredefinedTVActionButton(this.settings.getLabels().getImprintLinkText(), new PredefinedTVActionButtonType.Url(it));
            objectArray4 = objectArray;
            n3 = n;
            predefinedTVActionButton = predefinedTVActionButton3;
        } else {
            predefinedTVActionButton = null;
        }
        objectArray4[n3] = predefinedTVActionButton;
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull((Object[])objectArray2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PredefinedTVActionButton it2 = (PredefinedTVActionButton)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it2.getLabel()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean showDenyAllButton() {
        FirstLayer firstLayer = this.settings.getFirstLayer();
        return firstLayer != null ? Intrinsics.areEqual((Object)firstLayer.getHideButtonDeny(), (Object)false) : false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRFirstLayerMapper$Companion;", "", "()V", "defaultLogoPosition", "Lcom/usercentrics/sdk/v2/settings/data/FirstLayerLogoPosition;", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

