/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.etag.repository;

import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage;
import com.usercentrics.sdk.v2.etag.repository.EtagHolder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH$J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\bJ\u001c\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository;", "", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "etagCacheStorage", "Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;)V", "etagKey", "", "getApiBody", "response", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "cacheMaxAge", "", "getApiHeaders", "", "getCacheControlValueFromEtagFile", "", "getEtagFile", "getEtagFromResponse", "headers", "getEtagRawFileNameFromCache", "getEtagRawFileNameFromCache2", "getEtagValueForHeader", "isEtagValid", "", "responseStatusCode", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nEtagRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EtagRepository.kt\ncom/usercentrics/sdk/v2/etag/repository/EtagRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public abstract class EtagRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final IEtagCacheStorage etagCacheStorage;
    @NotNull
    private static final String etagQueryHeaderEntryKey = "If-None-Match";
    @NotNull
    private static final String etagResponseHeaderEntryKey = "etag";
    private static final int etagValidStatusCode = 304;
    @NotNull
    private static final String dummyEtagKey = "xxx";

    public EtagRepository(@NotNull UsercentricsLogger logger2, @NotNull IEtagCacheStorage etagCacheStorage2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)etagCacheStorage2, (String)"etagCacheStorage");
        this.logger = logger2;
        this.etagCacheStorage = etagCacheStorage2;
    }

    @NotNull
    protected abstract String etagKey();

    @NotNull
    public final Map<String, String> getApiHeaders() {
        String etagValue = this.getEtagValueForHeader();
        return StringsKt.isBlank((CharSequence)etagValue) ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)etagQueryHeaderEntryKey, (Object)etagValue));
    }

    @NotNull
    public final String getApiBody(@NotNull HttpResponse response2, int cacheMaxAge) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        String etagValue = this.getEtagFromResponse(response2.getHeaders());
        if (this.isEtagValid(response2.getStatusCode())) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Valid ETAG cache: key=" + this.etagKey(), null, 2, null);
            if (this.getCacheControlValueFromEtagFile() == 0L) {
                this.etagCacheStorage.storeFileAndEtag(new EtagHolder(this.etagKey(), cacheMaxAge, etagValue, response2.getBody()));
            }
            return this.getEtagFile();
        }
        String actualEtagValue = !StringsKt.isBlank((CharSequence)etagValue) && cacheMaxAge != 0 ? etagValue : dummyEtagKey;
        this.etagCacheStorage.storeFileAndEtag(new EtagHolder(this.etagKey(), cacheMaxAge, actualEtagValue, response2.getBody()));
        return response2.getBody();
    }

    @NotNull
    public final String getEtagFile() {
        return this.etagCacheStorage.getStoredFile(this.etagKey(), this.getEtagRawFileNameFromCache());
    }

    private final String getEtagRawFileNameFromCache() {
        String string = this.etagCacheStorage.getRawEtagFileName(this.etagKey());
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getEtagRawFileNameFromCache2() {
        String string = this.etagCacheStorage.getRawEtagFileName(this.etagKey());
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long getCacheControlValueFromEtagFile() {
        long l;
        try {
            String[] stringArray = new String[]{"@#$"};
            String cachedTimestamp = (String)StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)this.getEtagRawFileNameFromCache(), (CharSequence)"\""), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            Long l2 = StringsKt.toLongOrNull((String)cachedTimestamp);
            l = l2 != null ? l2 : 0L;
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    private final String getEtagFromResponse(Map<String, String> headers) {
        Object object;
        Object v0;
        block2: {
            Iterable iterable = headers.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)etagResponseHeaderEntryKey)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Map.Entry)v0) == null || (object = (String)object.getValue()) == null) {
            object = "";
        }
        return object;
    }

    private final boolean isEtagValid(int responseStatusCode) {
        return responseStatusCode == 304;
    }

    private final String getEtagValueForHeader() {
        String[] stringArray = new String[]{"@#$"};
        return (String)StringsKt.split$default((CharSequence)this.getEtagRawFileNameFromCache(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository$Companion;", "", "()V", "dummyEtagKey", "", "etagQueryHeaderEntryKey", "etagResponseHeaderEntryKey", "etagValidStatusCode", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

