/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder;

import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.TCFKeys;
import com.usercentrics.tcf.core.TCModel;
import com.usercentrics.tcf.core.TCModelPropType;
import com.usercentrics.tcf.core.encoder.BitLength;
import com.usercentrics.tcf.core.encoder.SegmentEncoder;
import com.usercentrics.tcf.core.encoder.SemanticPreEncoder;
import com.usercentrics.tcf.core.encoder.field.BooleanEncoder;
import com.usercentrics.tcf.core.encoder.field.DateEncoder;
import com.usercentrics.tcf.core.encoder.field.FixedVectorEncoder;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.encoder.field.PublisherRestrictionsEncoder;
import com.usercentrics.tcf.core.encoder.sequence.SegmentSequence;
import com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType;
import com.usercentrics.tcf.core.errors.EncodingError;
import com.usercentrics.tcf.core.model.Segment;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010.2\u0006\u0010+\u001a\u00020,H\u0002R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006/"}, d2={"Lcom/usercentrics/tcf/core/encoder/TCFKeysEncoder;", "", "tcModel", "Lcom/usercentrics/tcf/core/TCModel;", "tcString", "", "gdprApplies", "", "(Lcom/usercentrics/tcf/core/TCModel;Ljava/lang/String;I)V", "cmpIdEncoded", "Ljava/lang/Integer;", "cmpVersionEncoded", "consentLanguageEncoded", "consentScreenEncoded", "createdEncoded", "enableAdvertiserConsentMode", "isServiceSpecificEncoded", "lastUpdatedEncoded", "numCustomPurposesEncoded", "policyVersionEncoded", "publisherConsentsEncoded", "publisherCountryCodeEncoded", "publisherCustomConsentsEncoded", "publisherCustomLegitimateInterestsEncoded", "publisherLegitimateInterestsEncoded", "publisherRestrictionsEncoded", "", "purposeConsentsEncoded", "purposeLegitimateInterestsEncoded", "purposeOneTreatmentEncoded", "segmentTypeEncoded", "specialFeatureOptinsEncoded", "useNonStandardStacksEncoded", "vendorConsentsEncoded", "vendorLegitimateInterestsEncoded", "vendorListVersionEncoded", "vendorsAllowedEncoded", "vendorsDisclosedEncoded", "versionEncoded", "encode", "Lcom/usercentrics/tcf/core/TCFKeys;", "encodeSegment", "", "segment", "Lcom/usercentrics/tcf/core/model/Segment;", "getSequenceForSegment", "", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCFKeysEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCFKeysEncoder.kt\ncom/usercentrics/tcf/core/encoder/TCFKeysEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1855#2,2:266\n1855#2,2:268\n*S KotlinDebug\n*F\n+ 1 TCFKeysEncoder.kt\ncom/usercentrics/tcf/core/encoder/TCFKeysEncoder\n*L\n57#1:266,2\n85#1:268,2\n*E\n"})
public final class TCFKeysEncoder {
    @NotNull
    private final TCModel tcModel;
    @NotNull
    private final String tcString;
    private final int gdprApplies;
    @Nullable
    private Integer cmpIdEncoded;
    @Nullable
    private Integer cmpVersionEncoded;
    @Nullable
    private Integer policyVersionEncoded;
    @NotNull
    private String publisherCountryCodeEncoded;
    @Nullable
    private Integer purposeOneTreatmentEncoded;
    @Nullable
    private Integer useNonStandardStacksEncoded;
    @NotNull
    private String vendorConsentsEncoded;
    @NotNull
    private String vendorLegitimateInterestsEncoded;
    @NotNull
    private String purposeConsentsEncoded;
    @NotNull
    private String purposeLegitimateInterestsEncoded;
    @NotNull
    private String specialFeatureOptinsEncoded;
    @NotNull
    private Map<Integer, String> publisherRestrictionsEncoded;
    @NotNull
    private String publisherConsentsEncoded;
    @NotNull
    private String publisherLegitimateInterestsEncoded;
    @NotNull
    private String publisherCustomConsentsEncoded;
    @NotNull
    private String publisherCustomLegitimateInterestsEncoded;
    private final int enableAdvertiserConsentMode;
    @Nullable
    private Integer versionEncoded;
    @NotNull
    private String numCustomPurposesEncoded;
    @NotNull
    private String consentScreenEncoded;
    @NotNull
    private String vendorListVersionEncoded;
    @NotNull
    private String segmentTypeEncoded;
    @NotNull
    private String createdEncoded;
    @NotNull
    private String lastUpdatedEncoded;
    @NotNull
    private String consentLanguageEncoded;
    @NotNull
    private String isServiceSpecificEncoded;
    @NotNull
    private String vendorsDisclosedEncoded;
    @NotNull
    private String vendorsAllowedEncoded;

    public TCFKeysEncoder(@NotNull TCModel tcModel, @NotNull String tcString, int gdprApplies) {
        Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
        Intrinsics.checkNotNullParameter((Object)tcString, (String)"tcString");
        this.tcModel = tcModel;
        this.tcString = tcString;
        this.gdprApplies = gdprApplies;
        this.publisherCountryCodeEncoded = "AA";
        this.vendorConsentsEncoded = "";
        this.vendorLegitimateInterestsEncoded = "";
        this.purposeConsentsEncoded = "";
        this.purposeLegitimateInterestsEncoded = "";
        this.specialFeatureOptinsEncoded = "";
        this.publisherRestrictionsEncoded = MapsKt.emptyMap();
        this.publisherConsentsEncoded = "";
        this.publisherLegitimateInterestsEncoded = "";
        this.publisherCustomConsentsEncoded = "";
        this.publisherCustomLegitimateInterestsEncoded = "";
        this.enableAdvertiserConsentMode = 1;
        this.numCustomPurposesEncoded = "";
        this.consentScreenEncoded = "";
        this.vendorListVersionEncoded = "";
        this.segmentTypeEncoded = "";
        this.createdEncoded = "";
        this.lastUpdatedEncoded = "";
        this.consentLanguageEncoded = "";
        this.isServiceSpecificEncoded = "";
        this.vendorsDisclosedEncoded = "";
        this.vendorsAllowedEncoded = "";
    }

    @NotNull
    public final TCFKeys encode() {
        TCModel internalTCModel = SemanticPreEncoder.Companion.process(this.tcModel);
        int version = internalTCModel.getVersion();
        if (version != 2) {
            throw new EncodingError("Error encoding TCF String. Invalid version: " + version);
        }
        SequenceVersionMapType sequenceVersionMapType = new SegmentSequence(internalTCModel).getTwo();
        Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.List");
        List<Segment> sequence = ((SequenceVersionMapType.List)sequenceVersionMapType).getValue();
        Iterable $this$forEach$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment segment = (Segment)((Object)element$iv);
            boolean bl = false;
            this.encodeSegment(segment);
        }
        String string = this.tcString;
        int n = this.gdprApplies;
        Integer n2 = this.cmpIdEncoded;
        Integer n3 = this.cmpVersionEncoded;
        Integer n4 = this.policyVersionEncoded;
        String string2 = this.publisherCountryCodeEncoded;
        Integer n5 = this.purposeOneTreatmentEncoded;
        Integer n6 = this.useNonStandardStacksEncoded;
        String string3 = this.vendorConsentsEncoded;
        String string4 = this.vendorLegitimateInterestsEncoded;
        String string5 = this.purposeConsentsEncoded;
        String string6 = this.purposeLegitimateInterestsEncoded;
        String string7 = this.specialFeatureOptinsEncoded;
        Map<Integer, String> map2 = this.publisherRestrictionsEncoded;
        String string8 = this.publisherConsentsEncoded;
        String string9 = this.publisherLegitimateInterestsEncoded;
        String string10 = this.publisherCustomConsentsEncoded;
        String string11 = this.publisherCustomLegitimateInterestsEncoded;
        int n7 = this.enableAdvertiserConsentMode;
        return new TCFKeys(n2, n3, n4, n, string2, n5, n6, string, string3, string4, string5, string6, string7, map2, string8, string9, string10, string11, n7);
    }

    private final void encodeSegment(Segment segment) {
        block93: {
            List<String> list = this.getSequenceForSegment(segment);
            if (list == null) break block93;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            block51: for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                TCModelPropType value = this.tcModel.getFieldByName(key);
                BitLength bitLength = BitLength.Companion.getByName(key);
                int numBits = 0;
                if (bitLength == null) {
                    if (SegmentEncoder.Companion.isPublisherCustom(key)) {
                        Object numCustomPurposes = this.tcModel.getNumCustomPurposes();
                        if (numCustomPurposes instanceof StringOrNumber.Int) {
                            numBits = ((StringOrNumber.Int)numCustomPurposes).getValue();
                        }
                        if (numCustomPurposes instanceof StringOrNumber.String) {
                            numBits = Integer.parseInt(((StringOrNumber.String)numCustomPurposes).getValue());
                        }
                    }
                } else {
                    numBits = bitLength.getInteger();
                }
                try {
                    switch (key) {
                        case "numCustomPurposes": 
                        case "version": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Int");
                            TCModelPropType.Int cfr_ignored_0 = (TCModelPropType.Int)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"version")) {
                                this.versionEncoded = ((TCModelPropType.Int)value).getValue();
                                continue block51;
                            }
                            this.numCustomPurposesEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((TCModelPropType.Int)value).getValue()), numBits);
                            continue block51;
                        }
                        case "policyVersion": 
                        case "cmpVersion": 
                        case "vendorListVersion": 
                        case "cmpId": 
                        case "consentScreen": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                            TCModelPropType.StringOrNumber cfr_ignored_1 = (TCModelPropType.StringOrNumber)value;
                            StringOrNumber internalValue = ((TCModelPropType.StringOrNumber)value).getValue();
                            Intrinsics.checkNotNull((Object)internalValue, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.StringOrNumber.Int");
                            StringOrNumber.Int cfr_ignored_2 = (StringOrNumber.Int)internalValue;
                            if (Intrinsics.areEqual((Object)key, (Object)"cmpId")) {
                                this.cmpIdEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"cmpVersion")) {
                                this.cmpVersionEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"consentScreen")) {
                                this.consentScreenEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((StringOrNumber.Int)internalValue).getValue()), numBits);
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"vendorListVersion")) {
                                this.vendorListVersionEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((StringOrNumber.Int)internalValue).getValue()), numBits);
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"policyVersion")) continue block51;
                            this.policyVersionEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            continue block51;
                        }
                        case "segmentType": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                            TCModelPropType.StringOrNumber cfr_ignored_3 = (TCModelPropType.StringOrNumber)value;
                            this.segmentTypeEncoded = IntEncoder.Companion.encode(((TCModelPropType.StringOrNumber)value).getValue(), numBits);
                            continue block51;
                        }
                        case "lastUpdated": 
                        case "created": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Date");
                            TCModelPropType.Date cfr_ignored_4 = (TCModelPropType.Date)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"created")) {
                                Long l = ((TCModelPropType.Date)value).getValue();
                                Intrinsics.checkNotNull((Object)l);
                                this.createdEncoded = DateEncoder.Companion.encode(l, numBits);
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"lastUpdated")) continue block51;
                            Long l = ((TCModelPropType.Date)value).getValue();
                            Intrinsics.checkNotNull((Object)l);
                            this.lastUpdatedEncoded = DateEncoder.Companion.encode(l, numBits);
                            continue block51;
                        }
                        case "consentLanguage": 
                        case "publisherCountryCode": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.String");
                            TCModelPropType.String cfr_ignored_5 = (TCModelPropType.String)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"consentLanguage")) {
                                this.consentLanguageEncoded = ((TCModelPropType.String)value).getValue();
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"publisherCountryCode")) continue block51;
                            this.publisherCountryCodeEncoded = ((TCModelPropType.String)value).getValue();
                            continue block51;
                        }
                        case "isServiceSpecific": 
                        case "useNonStandardStacks": 
                        case "purposeOneTreatment": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Boolean");
                            TCModelPropType.Boolean cfr_ignored_6 = (TCModelPropType.Boolean)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"isServiceSpecific")) {
                                this.isServiceSpecificEncoded = BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue());
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"useNonStandardStacks")) {
                                this.useNonStandardStacksEncoded = Integer.parseInt(BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue()));
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"purposeOneTreatment")) continue block51;
                            this.purposeOneTreatmentEncoded = Integer.parseInt(BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue()));
                            continue block51;
                        }
                        case "specialFeatureOptins": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_7 = (TCModelPropType.Vector)value;
                            this.specialFeatureOptinsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "purposeConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_8 = (TCModelPropType.Vector)value;
                            this.purposeConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "purposeLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_9 = (TCModelPropType.Vector)value;
                            this.purposeLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_10 = (TCModelPropType.Vector)value;
                            this.publisherConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_11 = (TCModelPropType.Vector)value;
                            this.publisherLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherCustomConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_12 = (TCModelPropType.Vector)value;
                            this.publisherCustomConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherCustomLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_13 = (TCModelPropType.Vector)value;
                            this.publisherCustomLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_14 = (TCModelPropType.Vector)value;
                            this.vendorConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_15 = (TCModelPropType.Vector)value;
                            this.vendorLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorsDisclosed": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_16 = (TCModelPropType.Vector)value;
                            this.vendorsDisclosedEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorsAllowed": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_17 = (TCModelPropType.Vector)value;
                            this.vendorsAllowedEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherRestrictions": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.PurposeRestrictionVector");
                            TCModelPropType.PurposeRestrictionVector cfr_ignored_18 = (TCModelPropType.PurposeRestrictionVector)value;
                            this.publisherRestrictionsEncoded = PublisherRestrictionsEncoder.Companion.encode(((TCModelPropType.PurposeRestrictionVector)value).getValue());
                            continue block51;
                        }
                        default: {
                            throw new EncodingError("Error encoding " + segment + "->" + key + ", value: " + value);
                        }
                    }
                }
                catch (Throwable error) {
                    throw new EncodingError("Error encoding " + segment + "->" + key + ": " + error.getMessage());
                }
            }
        }
    }

    private final List<String> getSequenceForSegment(Segment segment) {
        SequenceVersionMapType sequenceVersionMapType = SegmentEncoder.Companion.getFieldSequence().getTwo();
        Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.SVMItemMap");
        return ((SequenceVersionMapType.SVMItemMap)sequenceVersionMapType).getMap().get((Object)segment);
    }
}

