/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.facade;

import com.usercentrics.sdk.UsercentricsServiceConsent;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.mediation.data.ConsentApplied;
import com.usercentrics.sdk.mediation.data.MediationResultPayload;
import com.usercentrics.sdk.mediation.facade.IMediationFacade;
import com.usercentrics.sdk.mediation.service.IMediationService;
import com.usercentrics.sdk.v2.settings.data.UsercentricsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J%\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/usercentrics/sdk/mediation/facade/MediationFacade;", "Lcom/usercentrics/sdk/mediation/facade/IMediationFacade;", "mediationService", "Lcom/usercentrics/sdk/mediation/service/IMediationService;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Lcom/usercentrics/sdk/mediation/service/IMediationService;Lcom/usercentrics/sdk/log/UsercentricsLogger;)V", "logInitialState", "", "services", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsService;", "mediateConsents", "Lcom/usercentrics/sdk/mediation/data/MediationResultPayload;", "consents", "Lcom/usercentrics/sdk/UsercentricsServiceConsent;", "ccpaOptedOut", "", "(Ljava/util/List;Ljava/lang/Boolean;)Lcom/usercentrics/sdk/mediation/data/MediationResultPayload;", "mediationLogMessage", "", "it", "Lcom/usercentrics/sdk/mediation/data/ConsentApplied;", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMediationFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediationFacade.kt\ncom/usercentrics/sdk/mediation/facade/MediationFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1855#2,2:55\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 MediationFacade.kt\ncom/usercentrics/sdk/mediation/facade/MediationFacade\n*L\n23#1:55,2\n35#1:57,2\n*E\n"})
public final class MediationFacade
implements IMediationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMediationService mediationService;
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private static final String MEDIATION_TAG = "[Mediation]";

    public MediationFacade(@NotNull IMediationService mediationService, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)mediationService, (String)"mediationService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.mediationService = mediationService;
        this.logger = logger2;
    }

    @Override
    public void logInitialState(@NotNull List<UsercentricsService> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Consent Mediation is Enabled", null, 2, null);
        List servicesNamesSupported = new ArrayList();
        Iterable $this$forEach$iv = services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String templateId;
            UsercentricsService service = (UsercentricsService)element$iv;
            boolean bl = false;
            if (service.getTemplateId() == null || !this.mediationService.isSDKSupported(templateId)) continue;
            String string = service.getDataProcessor();
            if (string == null) {
                string = "";
            }
            servicesNamesSupported.add(string);
        }
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "[Mediation] " + servicesNamesSupported.size() + '/' + services.size() + " Services are supported: " + CollectionsKt.joinToString$default((Iterable)servicesNamesSupported, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
    }

    @Override
    @NotNull
    public MediationResultPayload mediateConsents(@NotNull List<UsercentricsServiceConsent> consents, @Nullable Boolean ccpaOptedOut) {
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        MediationResultPayload result = this.mediationService.applyConsents(consents, ccpaOptedOut);
        Iterable $this$forEach$iv = result.getApplied();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsentApplied it = (ConsentApplied)element$iv;
            boolean bl = false;
            String message = this.mediationLogMessage(it);
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, message, null, 2, null);
        }
        return result;
    }

    private final String mediationLogMessage(ConsentApplied it) {
        String appliedPrefix = it.getMediated() ? "Applied " : "";
        StringBuilder stringBuilder = new StringBuilder().append("Consent is ");
        String string = String.valueOf(it.getConsent()).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String successMediationMessage = stringBuilder.append(string).toString();
        String mediatedMessage = !it.getMediated() ? "Unable to pass consent. Please, report this issue to Usercentrics. https://usercentrics.atlassian.net/servicedesk/customer/portal/2" : successMediationMessage;
        return "[Mediation] " + appliedPrefix + it.getName() + " - " + mediatedMessage;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/mediation/facade/MediationFacade$Companion;", "", "()V", "MEDIATION_TAG", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

