/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.sdk;

import com.usercentrics.sdk.UsercentricsServiceConsent;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.mediation.data.UsercentricsMediation;
import com.usercentrics.sdk.mediation.sdk.AdjustMediation;
import com.usercentrics.sdk.mediation.sdk.AdjustSDKInterface;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/usercentrics/sdk/mediation/sdk/AdjustMediationImpl;", "Lcom/usercentrics/sdk/mediation/sdk/AdjustMediation;", "name", "", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "adjustSDK", "Lcom/usercentrics/sdk/mediation/sdk/AdjustSDKInterface;", "(Ljava/lang/String;Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/mediation/sdk/AdjustSDKInterface;)V", "templateId", "getTemplateId", "()Ljava/lang/String;", "addPartnerSharingSetting", "", "partnerName", "consent", "apply", "Lcom/usercentrics/sdk/mediation/sdk/AdjustMediationImpl$AdjustSettings;", "isAvailable", "consents", "", "Lcom/usercentrics/sdk/UsercentricsServiceConsent;", "isMediated", "AdjustSettings", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nAdjustMediationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdjustMediationImpl.kt\ncom/usercentrics/sdk/mediation/sdk/AdjustMediationImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n288#2,2:83\n*S KotlinDebug\n*F\n+ 1 AdjustMediationImpl.kt\ncom/usercentrics/sdk/mediation/sdk/AdjustMediationImpl\n*L\n70#1:83,2\n*E\n"})
public final class AdjustMediationImpl
extends AdjustMediation {
    @NotNull
    private final AdjustSDKInterface adjustSDK;
    @NotNull
    private final String templateId;

    public AdjustMediationImpl(@NotNull String name, @NotNull UsercentricsLogger logger2, @NotNull AdjustSDKInterface adjustSDK) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)adjustSDK, (String)"adjustSDK");
        super(name, logger2);
        this.adjustSDK = adjustSDK;
        this.templateId = UsercentricsMediation.Adjust.INSTANCE.getAdjustTemplateId();
    }

    @Override
    @NotNull
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    @NotNull
    public AdjustSettings apply(@NotNull String templateId, boolean consent) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        String string = templateId;
        if (Intrinsics.areEqual((Object)string, (Object)this.getTemplateId())) {
            return new AdjustSettings("Adjust", this.adjustSDK.addAdjustGeneralConsent(consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getAppleAdsTemplateId())) {
            return new AdjustSettings("AppleAds", this.addPartnerSharingSetting("apple_ads", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getFacebookTemplateId())) {
            return new AdjustSettings("Facebook", this.addPartnerSharingSetting("facebook", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getGoogleAdsTemplateId())) {
            return new AdjustSettings("GoogleAds", this.addPartnerSharingSetting("adwords", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getGoogleMarketingPlatformTemplateId())) {
            return new AdjustSettings("GoogleMarketingPlatform", this.addPartnerSharingSetting("google_marketing_platform", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getSnapchatTemplateId())) {
            return new AdjustSettings("Snapchat", this.addPartnerSharingSetting("snapchat", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getTencentTemplateId())) {
            return new AdjustSettings("Tencent", this.addPartnerSharingSetting("tencent", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getTikTokSanTemplateId())) {
            return new AdjustSettings("TikTokSan", this.addPartnerSharingSetting("tiktok_san", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getTwitterTemplateId())) {
            return new AdjustSettings("Twitter", this.addPartnerSharingSetting("twitter", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getYahooGeminiTemplateId())) {
            return new AdjustSettings("YahooGemini", this.addPartnerSharingSetting("yahoo_gemini", consent));
        }
        if (Intrinsics.areEqual((Object)string, (Object)UsercentricsMediation.Adjust.INSTANCE.getYahooJapanSearchTemplateId())) {
            return new AdjustSettings("YahooJapanSearch", this.addPartnerSharingSetting("yahoo_japan_search", consent));
        }
        return new AdjustSettings("UNKNOWN", false);
    }

    @Override
    public boolean isMediated(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        return UsercentricsMediation.Adjust.INSTANCE.getTemplateIds$usercentrics_release().contains(templateId);
    }

    @Override
    public boolean isAvailable(@NotNull List<UsercentricsServiceConsent> consents) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(consents, (String)"consents");
            Iterable $this$firstOrNull$iv = consents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UsercentricsServiceConsent it = (UsercentricsServiceConsent)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTemplateId(), (Object)this.getTemplateId())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean addPartnerSharingSetting(String partnerName, boolean consent) {
        return this.adjustSDK.addPartnerSharingSetting(partnerName, consent);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/usercentrics/sdk/mediation/sdk/AdjustMediationImpl$AdjustSettings;", "", "name", "", "isMediated", "", "(Ljava/lang/String;Z)V", "()Z", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "usercentrics_release"})
    public static final class AdjustSettings {
        @NotNull
        private final String name;
        private final boolean isMediated;

        public AdjustSettings(@NotNull String name, boolean isMediated) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.isMediated = isMediated;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isMediated() {
            return this.isMediated;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isMediated;
        }

        @NotNull
        public final AdjustSettings copy(@NotNull String name, boolean isMediated) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new AdjustSettings(name, isMediated);
        }

        public static /* synthetic */ AdjustSettings copy$default(AdjustSettings adjustSettings, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = adjustSettings.name;
            }
            if ((n & 2) != 0) {
                bl = adjustSettings.isMediated;
            }
            return adjustSettings.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "AdjustSettings(name=" + this.name + ", isMediated=" + this.isMediated + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            int n = this.isMediated ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdjustSettings)) {
                return false;
            }
            AdjustSettings adjustSettings = (AdjustSettings)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)adjustSettings.name)) {
                return false;
            }
            return this.isMediated == adjustSettings.isMediated;
        }
    }
}

