/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.service;

import com.usercentrics.sdk.UsercentricsServiceConsent;
import com.usercentrics.sdk.mediation.MediationSDK;
import com.usercentrics.sdk.mediation.data.ConsentApplied;
import com.usercentrics.sdk.mediation.data.MediationResultPayload;
import com.usercentrics.sdk.mediation.sdk.AdjustMediation;
import com.usercentrics.sdk.mediation.sdk.AdjustMediationImpl;
import com.usercentrics.sdk.mediation.service.IMediationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001f\u0010\u001b\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/usercentrics/sdk/mediation/service/MediationService;", "Lcom/usercentrics/sdk/mediation/service/IMediationService;", "sdks", "", "", "Lcom/usercentrics/sdk/mediation/MediationSDK;", "adjust", "Lcom/usercentrics/sdk/mediation/sdk/AdjustMediation;", "(Ljava/util/Map;Lcom/usercentrics/sdk/mediation/sdk/AdjustMediation;)V", "applyConsents", "Lcom/usercentrics/sdk/mediation/data/MediationResultPayload;", "consents", "", "Lcom/usercentrics/sdk/UsercentricsServiceConsent;", "ccpaOptedOut", "", "(Ljava/util/List;Ljava/lang/Boolean;)Lcom/usercentrics/sdk/mediation/data/MediationResultPayload;", "applyMediation", "", "adjustPresentInTheDPSList", "templateId", "consent", "applied", "", "Lcom/usercentrics/sdk/mediation/data/ConsentApplied;", "(ZLjava/lang/String;ZLjava/util/List;Ljava/lang/Boolean;)V", "isSDKSupported", "serviceConsent", "(Ljava/lang/Boolean;Lcom/usercentrics/sdk/UsercentricsServiceConsent;)Z", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMediationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediationService.kt\ncom/usercentrics/sdk/mediation/service/MediationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 MediationService.kt\ncom/usercentrics/sdk/mediation/service/MediationService\n*L\n21#1:54,2\n*E\n"})
public final class MediationService
implements IMediationService {
    @NotNull
    private final Map<String, MediationSDK> sdks;
    @NotNull
    private final AdjustMediation adjust;

    public MediationService(@NotNull Map<String, ? extends MediationSDK> sdks, @NotNull AdjustMediation adjust) {
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter((Object)adjust, (String)"adjust");
        this.sdks = sdks;
        this.adjust = adjust;
    }

    @Override
    public boolean isSDKSupported(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        return this.sdks.containsKey(templateId) || Intrinsics.areEqual((Object)this.adjust.getTemplateId(), (Object)templateId);
    }

    @Override
    @NotNull
    public MediationResultPayload applyConsents(@NotNull List<UsercentricsServiceConsent> consents, @Nullable Boolean ccpaOptedOut) {
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        List applied = new ArrayList();
        boolean adjustPresentInTheDPSList = this.adjust.isAvailable(consents);
        Iterable $this$forEach$iv = consents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UsercentricsServiceConsent serviceConsent = (UsercentricsServiceConsent)element$iv;
            boolean bl = false;
            String templateId = serviceConsent.getTemplateId();
            boolean consent = this.serviceConsent(ccpaOptedOut, serviceConsent);
            this.applyMediation(adjustPresentInTheDPSList, templateId, consent, applied, ccpaOptedOut);
        }
        return new MediationResultPayload(applied);
    }

    private final void applyMediation(boolean adjustPresentInTheDPSList, String templateId, boolean consent, List<ConsentApplied> applied, Boolean ccpaOptedOut) {
        if (adjustPresentInTheDPSList && this.adjust.isMediated(templateId)) {
            AdjustMediationImpl.AdjustSettings mediationResults = this.adjust.apply(templateId, consent);
            applied.add(new ConsentApplied(mediationResults.getName(), templateId, consent, mediationResults.isMediated()));
        } else {
            MediationSDK mediationSDK = this.sdks.get(templateId);
            if (mediationSDK == null) {
                return;
            }
            MediationSDK mediationSDK2 = mediationSDK;
            boolean mediated = mediationSDK2.apply(consent, ccpaOptedOut != null);
            applied.add(new ConsentApplied(mediationSDK2.getName(), templateId, consent, mediated));
        }
    }

    private final boolean serviceConsent(Boolean ccpaOptedOut, UsercentricsServiceConsent serviceConsent) {
        if (serviceConsent.isEssential()) {
            return true;
        }
        Boolean bl = ccpaOptedOut;
        return bl != null ? !bl.booleanValue() : serviceConsent.getStatus();
    }
}

