/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.models.settings;

import com.usercentrics.sdk.PurposeProps;
import com.usercentrics.sdk.SpecialFeatureProps;
import com.usercentrics.sdk.StackProps;
import com.usercentrics.sdk.VendorProps;
import com.usercentrics.sdk.models.settings.PredefinedUIDependantSwitchSettings;
import com.usercentrics.sdk.models.settings.PredefinedUISwitchSettingsUI;
import com.usercentrics.sdk.models.settings.ServicesIdStrategy;
import com.usercentrics.sdk.services.tcf.interfaces.TCFPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFStack;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB%\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0013\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0016R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0016R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001a\u00a8\u00062"}, d2={"Lcom/usercentrics/sdk/models/settings/TCFHolder;", "", "purposeProps", "Lcom/usercentrics/sdk/PurposeProps;", "hasMainToggle", "", "hideLegitimateInterestToggles", "(Lcom/usercentrics/sdk/PurposeProps;ZZ)V", "specialFeatureProps", "Lcom/usercentrics/sdk/SpecialFeatureProps;", "(Lcom/usercentrics/sdk/SpecialFeatureProps;Z)V", "stackProps", "Lcom/usercentrics/sdk/StackProps;", "dependantSwitchSettings", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDependantSwitchSettings;", "(Lcom/usercentrics/sdk/StackProps;ZLjava/util/List;)V", "vendorProps", "Lcom/usercentrics/sdk/VendorProps;", "(Lcom/usercentrics/sdk/VendorProps;Z)V", "consentValue", "getConsentValue", "()Z", "contentDescription", "", "getContentDescription", "()Ljava/lang/String;", "getDependantSwitchSettings", "()Ljava/util/List;", "id", "getId", "illustrations", "getIllustrations", "isPartOfASelectedStack", "legitimateInterestValue", "getLegitimateInterestValue", "mainSwitchSettings", "Lcom/usercentrics/sdk/models/settings/PredefinedUISwitchSettingsUI;", "getMainSwitchSettings", "()Lcom/usercentrics/sdk/models/settings/PredefinedUISwitchSettingsUI;", "showConsentToggle", "getShowConsentToggle", "showLegitimateInterestToggle", "getShowLegitimateInterestToggle", "tcfId", "", "getTcfId", "()I", "title", "getTitle", "usercentrics_release"})
public final class TCFHolder {
    @NotNull
    private final String id;
    private final int tcfId;
    @NotNull
    private final String title;
    private final boolean isPartOfASelectedStack;
    private final boolean consentValue;
    private final boolean legitimateInterestValue;
    @Nullable
    private final PredefinedUISwitchSettingsUI mainSwitchSettings;
    @NotNull
    private final String contentDescription;
    @NotNull
    private final List<String> illustrations;
    private final boolean showConsentToggle;
    private final boolean showLegitimateInterestToggle;
    @Nullable
    private final List<PredefinedUIDependantSwitchSettings> dependantSwitchSettings;

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getTcfId() {
        return this.tcfId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final boolean isPartOfASelectedStack() {
        return this.isPartOfASelectedStack;
    }

    public final boolean getConsentValue() {
        return this.consentValue;
    }

    public final boolean getLegitimateInterestValue() {
        return this.legitimateInterestValue;
    }

    @Nullable
    public final PredefinedUISwitchSettingsUI getMainSwitchSettings() {
        return this.mainSwitchSettings;
    }

    @NotNull
    public final String getContentDescription() {
        return this.contentDescription;
    }

    @NotNull
    public final List<String> getIllustrations() {
        return this.illustrations;
    }

    public final boolean getShowConsentToggle() {
        return this.showConsentToggle;
    }

    public final boolean getShowLegitimateInterestToggle() {
        return this.showLegitimateInterestToggle;
    }

    @Nullable
    public final List<PredefinedUIDependantSwitchSettings> getDependantSwitchSettings() {
        return this.dependantSwitchSettings;
    }

    public TCFHolder(@NotNull PurposeProps purposeProps, boolean hasMainToggle, boolean hideLegitimateInterestToggles) {
        Intrinsics.checkNotNullParameter((Object)purposeProps, (String)"purposeProps");
        TCFPurpose purpose = purposeProps.getPurpose();
        this.id = ServicesIdStrategy.Companion.id(purpose);
        this.tcfId = purpose.getId();
        this.title = purpose.getName();
        this.isPartOfASelectedStack = purpose.isPartOfASelectedStack();
        this.consentValue = purposeProps.getChecked();
        this.legitimateInterestValue = purposeProps.getLegitimateInterestChecked();
        this.showConsentToggle = purpose.getShowConsentToggle();
        this.showLegitimateInterestToggle = purpose.getShowLegitimateInterestToggle() && !hideLegitimateInterestToggles;
        this.mainSwitchSettings = hasMainToggle && this.showConsentToggle ? new PredefinedUISwitchSettingsUI("consent", null, false, this.consentValue, 2, null) : null;
        this.contentDescription = purpose.getPurposeDescription();
        this.illustrations = purpose.getIllustrations();
        this.dependantSwitchSettings = null;
    }

    public TCFHolder(@NotNull SpecialFeatureProps specialFeatureProps, boolean hasMainToggle) {
        Intrinsics.checkNotNullParameter((Object)specialFeatureProps, (String)"specialFeatureProps");
        TCFSpecialFeature specialFeature = specialFeatureProps.getSpecialFeature();
        this.id = ServicesIdStrategy.Companion.id(specialFeature);
        this.tcfId = specialFeature.getId();
        this.title = specialFeature.getName();
        this.isPartOfASelectedStack = specialFeature.isPartOfASelectedStack();
        this.consentValue = specialFeatureProps.getChecked();
        this.legitimateInterestValue = false;
        this.mainSwitchSettings = hasMainToggle ? new PredefinedUISwitchSettingsUI("consent", null, false, this.consentValue, 2, null) : null;
        this.contentDescription = specialFeature.getPurposeDescription();
        this.illustrations = specialFeature.getIllustrations();
        this.showConsentToggle = false;
        this.showLegitimateInterestToggle = false;
        this.dependantSwitchSettings = null;
    }

    public TCFHolder(@NotNull StackProps stackProps, boolean hasMainToggle, @NotNull List<PredefinedUIDependantSwitchSettings> dependantSwitchSettings) {
        Intrinsics.checkNotNullParameter((Object)stackProps, (String)"stackProps");
        Intrinsics.checkNotNullParameter(dependantSwitchSettings, (String)"dependantSwitchSettings");
        TCFStack stack = stackProps.getStack();
        this.id = ServicesIdStrategy.Companion.id(stack);
        this.tcfId = stack.getId();
        this.title = stack.getName();
        this.isPartOfASelectedStack = false;
        this.consentValue = stackProps.getChecked();
        this.legitimateInterestValue = false;
        this.mainSwitchSettings = hasMainToggle ? new PredefinedUISwitchSettingsUI("consent", null, false, this.consentValue, 2, null) : null;
        this.dependantSwitchSettings = dependantSwitchSettings;
        this.contentDescription = stack.getDescription();
        this.illustrations = CollectionsKt.emptyList();
        this.showConsentToggle = false;
        this.showLegitimateInterestToggle = false;
    }

    public TCFHolder(@NotNull VendorProps vendorProps, boolean hideLegitimateInterestToggles) {
        Intrinsics.checkNotNullParameter((Object)vendorProps, (String)"vendorProps");
        TCFVendor vendor = vendorProps.getVendor();
        this.id = ServicesIdStrategy.Companion.id(vendor);
        this.tcfId = vendor.getId();
        this.title = vendor.getName();
        this.isPartOfASelectedStack = false;
        this.consentValue = vendorProps.getChecked();
        this.legitimateInterestValue = vendorProps.getLegitimateInterestChecked();
        this.mainSwitchSettings = null;
        this.contentDescription = "";
        this.illustrations = CollectionsKt.emptyList();
        this.showConsentToggle = vendor.getShowConsentToggle();
        this.showLegitimateInterestToggle = vendor.getShowLegitimateInterestToggle() && !hideLegitimateInterestToggles;
        this.dependantSwitchSettings = null;
    }
}

