/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.api;

import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.services.api.BillingApi;
import com.usercentrics.sdk.services.api.BillingApiImpl;
import com.usercentrics.sdk.services.api.NetworkResolver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/usercentrics/sdk/services/api/BillingApiImpl;", "Lcom/usercentrics/sdk/services/api/BillingApi;", "restClient", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "appID", "", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Ljava/lang/String;)V", "createBillingUrl", "settingsId", "report", "", "usercentrics_release"})
public final class BillingApiImpl
implements BillingApi {
    @NotNull
    private final HttpRequests restClient;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final String appID;

    public BillingApiImpl(@NotNull HttpRequests restClient, @NotNull NetworkResolver networkResolver2, @NotNull String appID) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)appID, (String)"appID");
        this.restClient = restClient;
        this.networkResolver = networkResolver2;
        this.appID = appID;
    }

    @Override
    public void report(@NotNull String settingsId) {
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        String url = this.createBillingUrl(settingsId);
        this.restClient.get(url, null, (Function1<? super HttpResponse, Unit>)((Function1)report.1.INSTANCE), (Function1<? super Throwable, Unit>)((Function1)report.2.INSTANCE));
    }

    private final String createBillingUrl(String settingsId) {
        String baseUrl = this.networkResolver.billingBaseUrl();
        return baseUrl + "?appId=" + this.appID + "&settingsId=" + settingsId;
    }
}

