/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.api.http;

import com.usercentrics.sdk.domain.api.http.HttpClient;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.services.api.http.security.UCTls12SocketFactory;
import com.usercentrics.sdk.services.api.http.security.UCTlsSocketFactoryProvider;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rH\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rH\u0016J2\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r2\u001c\u0010\f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00120\rH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0017\u001a\u00020\bH\u0016J$\u0010\u0018\u001a\u00020\u00192\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001a\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u000f*\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/usercentrics/sdk/services/api/http/AndroidHttpClient;", "Lcom/usercentrics/sdk/domain/api/http/HttpClient;", "timeoutMillis", "", "(J)V", "defaultCharset", "Ljava/nio/charset/Charset;", "jsonUtf8", "", "createConnection", "Ljava/net/HttpURLConnection;", "rawUrl", "headers", "", "get", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "url", "mapResponseHeaders", "", "parseResponseBody", "responseBody", "", "post", "bodyData", "setHeaders", "", "connection", "writeStream", "outputStream", "Ljava/io/OutputStream;", "use", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nAndroidHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidHttpClient.kt\ncom/usercentrics/sdk/services/api/http/AndroidHttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n125#2:90\n152#2,3:91\n1#3:94\n*S KotlinDebug\n*F\n+ 1 AndroidHttpClient.kt\ncom/usercentrics/sdk/services/api/http/AndroidHttpClient\n*L\n28#1:90\n28#1:91,3\n*E\n"})
public final class AndroidHttpClient
implements HttpClient {
    private final long timeoutMillis;
    @NotNull
    private final Charset defaultCharset;
    @NotNull
    private final String jsonUtf8;

    public AndroidHttpClient(long timeoutMillis2) {
        this.timeoutMillis = timeoutMillis2;
        this.defaultCharset = Charsets.UTF_8;
        this.jsonUtf8 = "application/json; charset=" + this.defaultCharset.name();
    }

    public /* synthetic */ AndroidHttpClient(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 10000L;
        }
        this(l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HttpResponse get(@NotNull String url, @NotNull Map<String, String> headers) {
        void $this$get_u24lambda_u240;
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        HttpURLConnection httpURLConnection2 = httpURLConnection = this.createConnection(url, headers);
        AndroidHttpClient androidHttpClient = this;
        boolean bl = false;
        $this$get_u24lambda_u240.setRequestMethod("GET");
        return androidHttpClient.use(httpURLConnection);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> mapResponseHeaders(Map<String, ? extends List<String>> headers) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends List<String>> $this$map$iv = headers;
        boolean $i$f$map = false;
        Map<String, ? extends List<String>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            String string2;
            void it;
            Collection collection;
            block6: {
                block5: {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string2 = (String)it.getKey();
                    if (string2 == null) break block5;
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    string2 = string3;
                    if (string3 != null) break block6;
                }
                string2 = "";
            }
            if ((string = (String)CollectionsKt.firstOrNull((List)((List)it.getValue()))) == null) {
                string = "";
            }
            collection.add(TuplesKt.to((Object)string2, (Object)string));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String post(@NotNull String url, @NotNull Map<String, String> headers, @NotNull String bodyData) {
        void $this$post_u24lambda_u242;
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)bodyData, (String)"bodyData");
        HttpURLConnection httpURLConnection2 = httpURLConnection = this.createConnection(url, headers);
        AndroidHttpClient androidHttpClient = this;
        boolean bl = false;
        $this$post_u24lambda_u242.setDoOutput(true);
        $this$post_u24lambda_u242.setRequestMethod("POST");
        $this$post_u24lambda_u242.setRequestProperty("Content-Type", this.jsonUtf8);
        this.writeStream(bodyData, $this$post_u24lambda_u242.getOutputStream());
        return androidHttpClient.use(httpURLConnection).getBody();
    }

    private final HttpURLConnection createConnection(String rawUrl, Map<String, String> headers) {
        HttpURLConnection httpURLConnection;
        URL url = new URL(rawUrl);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$createConnection_u24lambda_u243 = httpURLConnection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$createConnection_u24lambda_u243.setReadTimeout((int)this.timeoutMillis);
        this.setHeaders(headers, $this$createConnection_u24lambda_u243);
        $this$createConnection_u24lambda_u243.setRequestProperty("Accept", this.jsonUtf8);
        UCTlsSocketFactoryProvider.INSTANCE.installIfNeeded(UCTls12SocketFactory.INSTANCE, $this$createConnection_u24lambda_u243);
        return httpURLConnection;
    }

    private final void setHeaders(Map<String, String> headers, HttpURLConnection connection) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponse use(HttpURLConnection $this$use) {
        try {
            $this$use.connect();
            Map<String, List<String>> map2 = $this$use.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"headerFields");
            Object object = this.mapResponseHeaders(map2);
            int n = $this$use.getResponseCode();
            InputStream inputStream = $this$use.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            String string = this.parseResponseBody(ByteStreamsKt.readBytes((InputStream)inputStream));
            object = new HttpResponse((Map<String, String>)object, string, n);
            return object;
        }
        catch (FileNotFoundException notFoundEx) {
            HttpResponse httpResponse = new HttpResponse(null, null, 403, 3, null);
            return httpResponse;
        }
        finally {
            Object $this$use_u24lambda_u245;
            Object $this$use_u24lambda_u244;
            HttpURLConnection $this$use_u24lambda_u2452 = $this$use;
            try {
                $this$use_u24lambda_u244 = $this$use_u24lambda_u2452;
                boolean bl = false;
                ((URLConnection)$this$use_u24lambda_u244).getInputStream().close();
                $this$use_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$use_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            $this$use_u24lambda_u2452 = $this$use;
            try {
                $this$use_u24lambda_u245 = $this$use_u24lambda_u2452;
                boolean bl = false;
                ((HttpURLConnection)$this$use_u24lambda_u245).disconnect();
                $this$use_u24lambda_u245 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                $this$use_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final String parseResponseBody(byte[] responseBody) {
        return new String(responseBody, Charsets.UTF_8);
    }

    private final void writeStream(String bodyData, OutputStream outputStream) {
        block0: {
            BufferedOutputStream stream = new BufferedOutputStream(outputStream);
            byte[] byArray = bodyData.getBytes(this.defaultCharset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            stream.write(byArray);
            stream.flush();
            stream.close();
            OutputStream outputStream2 = outputStream;
            if (outputStream2 == null) break block0;
            outputStream2.close();
        }
    }

    public AndroidHttpClient() {
        this(0L, 1, null);
    }
}

