/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.billing;

import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.services.api.BillingApi;
import com.usercentrics.sdk.services.billing.BillingService;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSessionEntry;
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher;
import com.usercentrics.sdk.v2.async.dispatcher.DispatcherScope;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/usercentrics/sdk/services/billing/BillingServiceImpl;", "Lcom/usercentrics/sdk/services/billing/BillingService;", "dispatcher", "Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;", "storageInstance", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "billingApi", "Lcom/usercentrics/sdk/services/api/BillingApi;", "(Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/services/api/BillingApi;)V", "dispatchSessionBuffer", "", "reportSession", "settingsId", "", "timestamp", "", "shouldReportNewSession", "", "Companion", "usercentrics_release"})
public final class BillingServiceImpl
implements BillingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final DeviceStorage storageInstance;
    @NotNull
    private final BillingApi billingApi;
    private static final int BILLING_PERIOD_IN_DAYS = 1;

    public BillingServiceImpl(@NotNull Dispatcher dispatcher2, @NotNull DeviceStorage storageInstance2, @NotNull BillingApi billingApi2) {
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)storageInstance2, (String)"storageInstance");
        Intrinsics.checkNotNullParameter((Object)billingApi2, (String)"billingApi");
        this.dispatcher = dispatcher2;
        this.storageInstance = storageInstance2;
        this.billingApi = billingApi2;
    }

    @Override
    public void reportSession(@NotNull String settingsId) {
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        if (this.shouldReportNewSession()) {
            this.reportSession(settingsId, new DateTime().timestamp());
        }
    }

    @Override
    public void dispatchSessionBuffer() {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BillingServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = BillingServiceImpl.access$getStorageInstance$p(this.this$0).getAndEraseSessionBuffer();
                        BillingServiceImpl billingServiceImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            StorageSessionEntry it = (StorageSessionEntry)element$iv;
                            boolean bl = false;
                            BillingServiceImpl.access$reportSession(billingServiceImpl, it.getSettingsId(), it.getTimestamp());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final boolean shouldReportNewSession() {
        Long l = this.storageInstance.getSessionTimestamp();
        if (l == null) {
            return true;
        }
        long lastSessionTimestamp = l;
        DateTime lastSessionDateTimeAtMidnight = new DateTime(lastSessionTimestamp).atMidnight();
        DateTime currentDateTimeAtMidnight = new DateTime().atMidnight();
        int billingReportDeltaInDays = currentDateTimeAtMidnight.diffInDays(lastSessionDateTimeAtMidnight);
        return billingReportDeltaInDays >= 1;
    }

    private final void reportSession(String settingsId, long timestamp) {
        try {
            this.billingApi.report(settingsId);
            this.storageInstance.setSessionTimestamp(timestamp);
        }
        catch (Throwable error) {
            this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, timestamp, settingsId, null){
                int label;
                final /* synthetic */ BillingServiceImpl this$0;
                final /* synthetic */ long $timestamp;
                final /* synthetic */ String $settingsId;
                {
                    this.this$0 = $receiver;
                    this.$timestamp = $timestamp;
                    this.$settingsId = $settingsId;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            BillingServiceImpl.access$getStorageInstance$p(this.this$0).addSessionToBuffer(this.$timestamp, this.$settingsId);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
    }

    public static final /* synthetic */ DeviceStorage access$getStorageInstance$p(BillingServiceImpl $this) {
        return $this.storageInstance;
    }

    public static final /* synthetic */ void access$reportSession(BillingServiceImpl $this, String settingsId, long timestamp) {
        $this.reportSession(settingsId, timestamp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/services/billing/BillingServiceImpl$Companion;", "", "()V", "BILLING_PERIOD_IN_DAYS", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

