/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage;

import android.content.SharedPreferences;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J!\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0015H\u0017\u00a2\u0006\u0002\b\u0016J!\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0015H\u0017\u00a2\u0006\u0002\b\u0017J\u001c\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/SharedPreferencesKeyValueStorage;", "Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "deleteKey", "", "key", "", "getLong", "", "defaultValue", "getNumber", "", "getString", "hasKey", "", "purgeStorage", "put", "value", "values", "", "putIntegerMap", "putStringMap", "putStringOrIntMap", "", "usercentrics_release"})
public final class SharedPreferencesKeyValueStorage
implements KeyValueStorage {
    @NotNull
    private final SharedPreferences sharedPreferences;

    public SharedPreferencesKeyValueStorage(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public void deleteKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().remove(key).apply();
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getString(key, defaultValue);
    }

    @Override
    public int getNumber(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getLong(key, defaultValue);
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sharedPreferences.edit().putString(key, value).apply();
    }

    @Override
    public void put(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().putInt(key, value).apply();
    }

    @Override
    public void put(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().putLong(key, value).apply();
    }

    @Override
    public boolean hasKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.contains(key);
    }

    @Override
    public void purgeStorage() {
    }

    @Override
    @JvmName(name="putStringMap")
    public void putStringMap(@NotNull Map<String, String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putStringOrIntMap(values);
    }

    @Override
    @JvmName(name="putIntegerMap")
    public void putIntegerMap(@NotNull Map<String, Integer> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putStringOrIntMap(values);
    }

    @Override
    public void putStringOrIntMap(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                editor.putString(entry.getKey(), (String)value);
                continue;
            }
            if (!(value instanceof Integer)) continue;
            editor.putInt(entry.getKey(), ((Number)value).intValue());
        }
        editor.apply();
    }
}

