/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage;

import com.usercentrics.ccpa.CCPAStorage;
import com.usercentrics.sdk.AssertionsKt;
import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.UserSessionDataConsent;
import com.usercentrics.sdk.models.gdpr.DefaultUISettings;
import com.usercentrics.sdk.models.settings.LegacyConsentHistoryEntry;
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedUILanguage;
import com.usercentrics.sdk.models.settings.PredefinedUILanguageSettings;
import com.usercentrics.sdk.models.settings.SettingsVersion;
import com.usercentrics.sdk.models.tcf.TCFUISettings;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorageExtensionsKt;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.StorageKeys;
import com.usercentrics.sdk.services.deviceStorage.migrations.Migration;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationException;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationNotFoundException;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationToVersion1;
import com.usercentrics.sdk.services.deviceStorage.models.ConsentsBuffer;
import com.usercentrics.sdk.services.deviceStorage.models.StorageConsentHistory;
import com.usercentrics.sdk.services.deviceStorage.models.StorageService;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSessionEntry;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings;
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF;
import com.usercentrics.tcf.core.TCFKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001YB5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000f\u0010 \u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!J\n\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\tH\u0016J\u000f\u0010%\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016J\u000f\u0010)\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010*\u001a\u00020\u0018H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\b\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u0002010\tH\u0016J\b\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u00020\u0014H\u0016J\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050\t2\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\tH\u0002J\u001e\u00108\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u0002092\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\tH\u0002J\u0018\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020$0\tH\u0002J\b\u0010>\u001a\u00020\u0014H\u0002J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u0018H\u0016J\u001e\u0010A\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u0002092\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\tH\u0016J\b\u0010B\u001a\u00020\u0014H\u0002J\u0010\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u001fH\u0016J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0016H\u0016J\u0010\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020'H\u0016J\u0010\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0016H\u0016J\u0010\u0010K\u001a\u00020/2\u0006\u0010L\u001a\u00020\u0007H\u0002J\u0010\u0010M\u001a\u00020/2\u0006\u0010N\u001a\u000209H\u0002J\u001c\u0010O\u001a\u00020\u00142\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020R0QH\u0016J\u000f\u0010S\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010T\u001a\u00020UH\u0016J\u0016\u0010V\u001a\u00020\u00142\f\u0010W\u001a\b\u0012\u0004\u0012\u00020$0XH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage;", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "currentVersion", "", "migrations", "", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/log/UsercentricsLogger;ILjava/util/List;Lcom/usercentrics/sdk/core/json/JsonParser;)V", "defaultStorage", "Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;", "settings", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSettings;", "usercentricsStorage", "addSessionToBuffer", "", "currentTime", "", "settingsId", "", "clear", "clearSessionBuffer", "clearUserActionRequired", "fetchCcpaString", "fetchSettings", "fetchTCFData", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageTCF;", "gdprServiceLastInteractionTimestamp", "()Ljava/lang/Long;", "getABTestingVariant", "getAndEraseSessionBuffer", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSessionEntry;", "getCcpaTimestampInMillis", "getConsentBuffer", "Lcom/usercentrics/sdk/services/deviceStorage/models/ConsentsBuffer;", "getControllerId", "getSessionTimestamp", "getSettingsId", "getSettingsLanguage", "getSettingsVersion", "getStorageVersion", "getUserActionRequired", "", "getUserSessionDataConsents", "Lcom/usercentrics/sdk/models/common/UserSessionDataConsent;", "hasDataFromVersion0", "init", "mapStorageServices", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageService;", "services", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "mapStorageSettings", "Lcom/usercentrics/sdk/models/settings/LegacyExtendedSettings;", "migrateDataAfterVersionChange", "oldVersion", "targetVersion", "readSessionBuffer", "runMigrations", "saveABTestingVariant", "variant", "saveSettings", "saveStorageCurrentVersion", "saveTCFData", "tcfData", "setCcpaTimestampInMillis", "timestampInMillis", "setConsentBuffer", "buffer", "setSessionTimestamp", "sessionTimestamp", "shouldMigrate", "storageVersion", "shouldReshowBannerAfterVersionChange", "currentSettings", "storeStringOrIntValuesDefaultStorage", "values", "", "", "tcfServiceLastInteractionTimestamp", "toCcpaStorage", "Lcom/usercentrics/ccpa/CCPAStorage;", "writeSessionBuffer", "sessionBufferSet", "", "Builder", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nUsercentricsDeviceStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsercentricsDeviceStorage.kt\ncom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 6 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 7 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,369:1\n13579#2,2:370\n13579#2,2:372\n12744#2,2:403\n32#3:374\n40#3:379\n31#3,2:388\n40#3:390\n40#3:391\n32#3:392\n24#3:393\n36#3:397\n1855#4:375\n1855#4,2:376\n1856#4:378\n1549#4:380\n1620#4,2:381\n1549#4:383\n1620#4,3:384\n1622#4:387\n1855#4,2:401\n288#4,2:405\n1855#4,2:407\n123#5:394\n113#5:398\n32#6:395\n32#6:399\n80#7:396\n80#7:400\n*S KotlinDebug\n*F\n+ 1 UsercentricsDeviceStorage.kt\ncom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage\n*L\n40#1:370,2\n44#1:372,2\n312#1:403,2\n94#1:374\n159#1:379\n193#1:388,2\n200#1:390\n207#1:391\n215#1:392\n277#1:393\n285#1:397\n134#1:375\n135#1:376,2\n134#1:378\n180#1:380\n180#1:381,2\n182#1:383\n182#1:384,3\n180#1:387\n291#1:401,2\n326#1:405,2\n331#1:407,2\n277#1:394\n285#1:398\n277#1:395\n285#1:399\n277#1:396\n285#1:400\n*E\n"})
public final class UsercentricsDeviceStorage
implements DeviceStorage {
    @NotNull
    private final StorageHolder storageHolder;
    @NotNull
    private final UsercentricsLogger logger;
    private final int currentVersion;
    @NotNull
    private final List<Migration> migrations;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final KeyValueStorage defaultStorage;
    @NotNull
    private final KeyValueStorage usercentricsStorage;
    @Nullable
    private StorageSettings settings;

    private UsercentricsDeviceStorage(StorageHolder storageHolder, UsercentricsLogger logger2, int currentVersion, List<? extends Migration> migrations, JsonParser jsonParser) {
        this.storageHolder = storageHolder;
        this.logger = logger2;
        this.currentVersion = currentVersion;
        this.migrations = migrations;
        this.jsonParser = jsonParser;
        this.defaultStorage = this.storageHolder.getDefaultKeyValueStorage();
        this.usercentricsStorage = this.storageHolder.getUsercentricsKeyValueStorage();
    }

    @Override
    public void init() {
        this.runMigrations();
    }

    @Override
    public void clear() {
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Clearing local storage", null, 2, null);
        Enum[] $this$forEach$iv = StorageKeys.values();
        boolean $i$f$forEach = false;
        for (Enum element$iv : $this$forEach$iv) {
            StorageKeys key = element$iv;
            boolean bl = false;
            this.usercentricsStorage.deleteKey(key.getText());
        }
        $this$forEach$iv = TCFKeys.IABTCFKeys.values();
        $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Enum element$iv;
            Enum entry = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.defaultStorage.deleteKey(((TCFKeys.IABTCFKeys)entry).getKey());
        }
        this.defaultStorage.deleteKey("IABUSPrivacy_String");
        this.settings = null;
    }

    @Override
    public void storeStringOrIntValuesDefaultStorage(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.defaultStorage.putStringOrIntMap(values);
    }

    @Override
    @NotNull
    public CCPAStorage toCcpaStorage() {
        return KeyValueStorageExtensionsKt.toCcpaStorage(this.defaultStorage);
    }

    @Override
    public void setCcpaTimestampInMillis(long timestampInMillis) {
        this.usercentricsStorage.put(StorageKeys.CCPA_TIMESTAMP.getText(), String.valueOf(timestampInMillis));
    }

    @Override
    @Nullable
    public Long getCcpaTimestampInMillis() {
        Long l;
        try {
            String string = this.usercentricsStorage.getString(StorageKeys.CCPA_TIMESTAMP.getText(), null);
            l = string != null ? Long.valueOf(Long.parseLong(string)) : null;
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    @Override
    public void setSessionTimestamp(long sessionTimestamp) {
        this.usercentricsStorage.put(StorageKeys.SESSION_TIMESTAMP.getText(), String.valueOf(sessionTimestamp));
    }

    @Override
    @Nullable
    public Long getSessionTimestamp() {
        Long l;
        String timestamp = this.usercentricsStorage.getString(StorageKeys.SESSION_TIMESTAMP.getText(), null);
        try {
            String string = timestamp;
            l = string != null ? Long.valueOf(Long.parseLong(string)) : null;
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StorageSettings fetchSettings() {
        StorageSettings storageSettings = this.settings;
        if (storageSettings == null) {
            StorageSettings newValue;
            StorageSettings storageSettings2;
            UsercentricsDeviceStorage $this$fetchSettings_u24lambda_u242 = this;
            boolean bl = false;
            StorageSettings parsedSettings = null;
            String storageSettings3 = $this$fetchSettings_u24lambda_u242.usercentricsStorage.getString(StorageKeys.SETTINGS.getText(), null);
            Object object = storageSettings3;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                void logger$iv;
                void deserializer$iv;
                object = $this$fetchSettings_u24lambda_u242.jsonParser;
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)StorageSettings.Companion.serializer();
                UsercentricsLogger usercentricsLogger = $this$fetchSettings_u24lambda_u242.logger;
                boolean $i$f$tryToDecodeFromString = false;
                parsedSettings = (StorageSettings)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, storageSettings3, (UsercentricsLogger)logger$iv);
            }
            if ((storageSettings2 = parsedSettings) == null) {
                storageSettings2 = new StorageSettings(null, null, null, null, null, 31, null);
            }
            $this$fetchSettings_u24lambda_u242.settings = newValue = storageSettings2;
            storageSettings = newValue;
        }
        return storageSettings;
    }

    @Override
    @Nullable
    public Long gdprServiceLastInteractionTimestamp() {
        return this.fetchSettings().getGdprServiceLastInteractionTimestamp();
    }

    @Override
    @Nullable
    public Long tcfServiceLastInteractionTimestamp() {
        return this.fetchSettings().getTcfServiceLastInteractionTimestamp();
    }

    @Override
    @NotNull
    public String getSettingsVersion() {
        return this.fetchSettings().getVersion();
    }

    @Override
    @NotNull
    public String getSettingsId() {
        return this.fetchSettings().getId();
    }

    @Override
    @NotNull
    public String getControllerId() {
        return this.fetchSettings().getControllerId();
    }

    @Override
    @NotNull
    public String getSettingsLanguage() {
        return this.fetchSettings().getLanguage();
    }

    @Override
    @NotNull
    public List<UserSessionDataConsent> getUserSessionDataConsents() {
        List consentList = new ArrayList();
        StorageSettings settings = this.fetchSettings();
        Iterable $this$forEach$iv = settings.getServices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StorageService service = (StorageService)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = service.getHistory();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StorageConsentHistory history = (StorageConsentHistory)element$iv2;
                boolean bl2 = false;
                consentList.add(new UserSessionDataConsent(history.getStatus(), service.getId(), history.getTimestampInMillis()));
            }
        }
        return consentList;
    }

    @Override
    public void saveSettings(@NotNull LegacyExtendedSettings settings, @NotNull List<LegacyService> services) {
        StorageSettings storageSettings;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        boolean versionChangeRequiresReshow = this.shouldReshowBannerAfterVersionChange(settings);
        if (versionChangeRequiresReshow) {
            this.usercentricsStorage.put(StorageKeys.USER_ACTION_REQUIRED.getText(), "true");
        }
        this.settings = storageSettings = this.mapStorageSettings(settings, services);
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageSettings.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.SETTINGS.getText(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)storageSettings));
    }

    private final StorageSettings mapStorageSettings(LegacyExtendedSettings settings, List<LegacyService> services) {
        PredefinedUILanguage predefinedUILanguage;
        if (settings.isTcfEnabled()) {
            Object object = settings.getTcfui();
            PredefinedUILanguage predefinedUILanguage2 = object != null && (object = ((TCFUISettings)object).getLanguage()) != null ? ((PredefinedUILanguageSettings)object).getSelected() : null;
            predefinedUILanguage = predefinedUILanguage2;
            Intrinsics.checkNotNull((Object)predefinedUILanguage2);
        } else {
            Object object = settings.getUi();
            PredefinedUILanguage predefinedUILanguage3 = object != null && (object = ((DefaultUISettings)object).getLanguage()) != null ? ((PredefinedUILanguageSettings)object).getSelected() : null;
            predefinedUILanguage = predefinedUILanguage3;
            Intrinsics.checkNotNull((Object)predefinedUILanguage3);
        }
        PredefinedUILanguage selectedLanguage = predefinedUILanguage;
        return new StorageSettings(settings.getControllerId(), settings.getId(), selectedLanguage.getIsoCode(), this.mapStorageServices(services), settings.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final List<StorageService> mapStorageServices(List<LegacyService> services) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = services;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void service;
            LegacyService legacyService = (LegacyService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = service.getConsent().getHistory();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                LegacyConsentHistoryEntry legacyConsentHistoryEntry = (LegacyConsentHistoryEntry)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(StorageConsentHistory.Companion.fromConsentHistory((LegacyConsentHistoryEntry)it));
            }
            boolean bl3 = service.getConsent().getStatus();
            String string = service.getProcessorId();
            String string2 = service.getId();
            List list = (List)destination$iv$iv2;
            collection.add(new StorageService(list, string2, string, bl3));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ConsentsBuffer getConsentBuffer() {
        AssertionsKt.assertNotUIThread();
        String string = this.usercentricsStorage.getString(StorageKeys.CONSENTS_BUFFER.getText(), null);
        if (string == null) {
            string = "";
        }
        String bufferString = string;
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializer$iv = (DeserializationStrategy)ConsentsBuffer.Companion.serializer();
        UsercentricsLogger logger$iv = null;
        boolean $i$f$tryToDecodeFromString = false;
        ConsentsBuffer consentsBuffer = (ConsentsBuffer)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, bufferString, logger$iv);
        if (consentsBuffer == null) {
            consentsBuffer = new ConsentsBuffer(CollectionsKt.emptyList());
        }
        return consentsBuffer;
    }

    @Override
    public void setConsentBuffer(@NotNull ConsentsBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AssertionsKt.assertNotUIThread();
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)ConsentsBuffer.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.CONSENTS_BUFFER.getText(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)buffer));
    }

    @Override
    public void saveTCFData(@NotNull StorageTCF tcfData) {
        Intrinsics.checkNotNullParameter((Object)tcfData, (String)"tcfData");
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageTCF.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.TCF.getText(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)tcfData));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StorageTCF fetchTCFData() {
        StorageTCF storageTCF;
        String tcfData;
        StorageTCF parsedTCF = null;
        String string = this.usercentricsStorage.getString(StorageKeys.TCF.getText(), null);
        if (string == null) {
            string = "";
        }
        if (!StringsKt.isBlank((CharSequence)(tcfData = string))) {
            void deserializer$iv;
            JsonParser jsonParser = this.jsonParser;
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)StorageTCF.Companion.serializer();
            UsercentricsLogger logger$iv = this.logger;
            boolean $i$f$tryToDecodeFromString = false;
            parsedTCF = (StorageTCF)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, tcfData, logger$iv);
        }
        if ((storageTCF = parsedTCF) == null) {
            storageTCF = new StorageTCF(null, null, null, 7, null);
        }
        return storageTCF;
    }

    @Override
    @NotNull
    public String fetchCcpaString() {
        String string = this.defaultStorage.getString("IABUSPrivacy_String", null);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void addSessionToBuffer(long currentTime, @NotNull String settingsId) {
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        Set sessionBufferSet = CollectionsKt.toMutableSet((Iterable)this.readSessionBuffer());
        sessionBufferSet.add(new StorageSessionEntry(settingsId, currentTime));
        this.writeSessionBuffer(sessionBufferSet);
    }

    @Override
    @NotNull
    public List<StorageSessionEntry> getAndEraseSessionBuffer() {
        List<StorageSessionEntry> sessionBuffer = this.readSessionBuffer();
        this.clearSessionBuffer();
        return sessionBuffer;
    }

    @Override
    public void saveABTestingVariant(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.usercentricsStorage.put(StorageKeys.AB_TESTING_VARIANT.getText(), variant);
    }

    @Override
    @Nullable
    public String getABTestingVariant() {
        return this.usercentricsStorage.getString(StorageKeys.AB_TESTING_VARIANT.getText(), null);
    }

    @Override
    public boolean getUserActionRequired() {
        String userActionRequired;
        String string = userActionRequired = this.usercentricsStorage.getString(StorageKeys.USER_ACTION_REQUIRED.getText(), null);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @Override
    public void clearUserActionRequired() {
        this.usercentricsStorage.deleteKey(StorageKeys.USER_ACTION_REQUIRED.getText());
    }

    private final boolean shouldReshowBannerAfterVersionChange(LegacyExtendedSettings currentSettings) {
        StorageSettings storageSettings = this.settings;
        String storageVersion = storageSettings != null ? storageSettings.getVersion() : null;
        CharSequence charSequence = storageVersion;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        if (currentSettings.getShowFirstLayerOnVersionChange().isEmpty()) {
            return false;
        }
        char[] cArray = new char[]{'.'};
        List currentVersionArray = StringsKt.split$default((CharSequence)currentSettings.getVersion(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'.'};
        List storageVersionArray = StringsKt.split$default((CharSequence)storageVersion, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        return currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.MAJOR.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(0), storageVersionArray.get(0)) || currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.MINOR.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(1), storageVersionArray.get(1)) || currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.PATCH.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(2), storageVersionArray.get(2));
    }

    private final List<StorageSessionEntry> readSessionBuffer() {
        AssertionsKt.assertNotUIThread();
        String jsonArray = this.usercentricsStorage.getString(StorageKeys.SESSION_BUFFER.getText(), null);
        CharSequence charSequence = jsonArray;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CollectionsKt.emptyList();
        }
        JsonParser this_$iv = this.jsonParser;
        boolean $i$f$decodeFromString = false;
        StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$decodeFromString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(StorageSessionEntry.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return (List)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, jsonArray);
    }

    private final void clearSessionBuffer() {
        this.writeSessionBuffer(SetsKt.emptySet());
    }

    private final void writeSessionBuffer(Set<StorageSessionEntry> sessionBufferSet) {
        String string = StorageKeys.SESSION_BUFFER.getText();
        JsonParser this_$iv = this.jsonParser;
        boolean $i$f$encodeToString = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$encodeToString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(StorageSessionEntry.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        this.usercentricsStorage.put(string, $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, sessionBufferSet));
    }

    private final void runMigrations() {
        int storageVersion = this.getStorageVersion();
        if (this.shouldMigrate(storageVersion)) {
            Iterable $this$forEach$iv = (Iterable)new IntRange(storageVersion + 1, this.currentVersion);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int targetVersion = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int oldVersion = targetVersion - 1;
                try {
                    this.migrateDataAfterVersionChange(oldVersion, targetVersion);
                }
                catch (Throwable cause) {
                    throw new MigrationException("Cannot migrate stored data from " + oldVersion + " to " + targetVersion, cause);
                }
            }
        }
        this.saveStorageCurrentVersion();
    }

    private final boolean shouldMigrate(int storageVersion) {
        return storageVersion == 0 ? this.hasDataFromVersion0() : storageVersion < this.currentVersion;
    }

    private final boolean hasDataFromVersion0() {
        boolean bl;
        block1: {
            MigrationToVersion1.V0StorageKeys[] $this$any$iv = MigrationToVersion1.V0StorageKeys.values();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                MigrationToVersion1.V0StorageKeys element$iv;
                MigrationToVersion1.V0StorageKeys key = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!this.storageHolder.getDefaultKeyValueStorage().hasKey(key.getText())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final int getStorageVersion() {
        return this.usercentricsStorage.getNumber(StorageKeys.STORAGE_VERSION.getText(), 0);
    }

    private final void migrateDataAfterVersionChange(int oldVersion, int targetVersion) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.migrations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Migration it = (Migration)element$iv;
                boolean bl = false;
                if (!(it.getFromVersion() == oldVersion && it.getToVersion() == targetVersion)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Migration hasExactMigration = v0;
        if (hasExactMigration == null) {
            throw new MigrationNotFoundException(oldVersion, targetVersion);
        }
        Iterable $this$forEach$iv = this.migrations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Migration migration = (Migration)element$iv;
            boolean bl = false;
            if (migration.getFromVersion() != oldVersion || migration.getToVersion() != targetVersion) continue;
            migration.migrate();
        }
    }

    private final void saveStorageCurrentVersion() {
        this.usercentricsStorage.put(StorageKeys.STORAGE_VERSION.getText(), this.currentVersion);
    }

    public /* synthetic */ UsercentricsDeviceStorage(StorageHolder storageHolder, UsercentricsLogger logger2, int currentVersion, List migrations, JsonParser jsonParser, DefaultConstructorMarker $constructor_marker) {
        this(storageHolder, logger2, currentVersion, migrations, jsonParser);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage$Builder;", "", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "currentVersion", "", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/core/json/JsonParser;I)V", "migrations", "", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "addMigration", "migration", "", "([Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;)Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage$Builder;", "build", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "usercentrics_release"})
    public static final class Builder {
        @NotNull
        private final StorageHolder storageHolder;
        @NotNull
        private final UsercentricsLogger logger;
        @NotNull
        private final JsonParser jsonParser;
        private final int currentVersion;
        @NotNull
        private final List<Migration> migrations;

        public Builder(@NotNull StorageHolder storageHolder, @NotNull UsercentricsLogger logger2, @NotNull JsonParser jsonParser, int currentVersion) {
            Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
            this.storageHolder = storageHolder;
            this.logger = logger2;
            this.jsonParser = jsonParser;
            this.currentVersion = currentVersion;
            this.migrations = new ArrayList();
        }

        public /* synthetic */ Builder(StorageHolder storageHolder, UsercentricsLogger usercentricsLogger, JsonParser jsonParser, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                n = 4;
            }
            this(storageHolder, usercentricsLogger, jsonParser, n);
        }

        @NotNull
        public final Builder addMigration(Migration ... migration) {
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            CollectionsKt.addAll((Collection)this.migrations, (Object[])migration);
            return this;
        }

        @NotNull
        public final DeviceStorage build() {
            UsercentricsDeviceStorage deviceStorage = new UsercentricsDeviceStorage(this.storageHolder, this.logger, this.currentVersion, this.migrations, this.jsonParser, null);
            deviceStorage.init();
            return deviceStorage;
        }
    }
}

