/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage.migrations;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.extensions.TimeExtensionsKt;
import com.usercentrics.sdk.models.settings.UsercentricsConsentAction;
import com.usercentrics.sdk.models.settings.UsercentricsConsentType;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.StorageKeys;
import com.usercentrics.sdk.services.deviceStorage.migrations.Migration;
import com.usercentrics.sdk.services.deviceStorage.models.StorageConsentAction;
import com.usercentrics.sdk.services.deviceStorage.models.StorageConsentHistory;
import com.usercentrics.sdk.services.deviceStorage.models.StorageConsentType;
import com.usercentrics.sdk.services.deviceStorage.models.StorageService;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion1;", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/core/json/JsonParser;)V", "clear", "", "getLegacyValue", "", "oldKey", "migrate", "migrateFromDefaultStorageToCustom", "newKey", "migrateSettings", "settingsHistoryFromServiceJson", "", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageConsentHistory;", "serviceJsonObject", "Lkotlinx/serialization/json/JsonObject;", "storageSettingsFromLegacyJson", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSettings;", "legacyValue", "storeNewValue", "value", "V0StorageKeys", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMigrationToVersion1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationToVersion1.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion1\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 5 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n36#2:113\n28#2:117\n113#3:114\n32#4:115\n80#5:116\n1549#6:118\n1620#6,3:119\n1549#6:122\n1620#6,3:123\n13579#7,2:126\n*S KotlinDebug\n*F\n+ 1 MigrationToVersion1.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion1\n*L\n48#1:113\n52#1:117\n48#1:114\n48#1:115\n48#1:116\n55#1:118\n55#1:119,3\n75#1:122\n75#1:123,3\n95#1:126,2\n*E\n"})
public final class MigrationToVersion1
extends Migration {
    @NotNull
    private final JsonParser jsonParser;

    public MigrationToVersion1(@NotNull StorageHolder storageHolder, @NotNull JsonParser jsonParser) {
        Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        super(storageHolder, 1);
        this.jsonParser = jsonParser;
    }

    @Override
    public void migrate() {
        this.migrateFromDefaultStorageToCustom(V0StorageKeys.CCPA_TIMESTAMP.getText(), StorageKeys.CCPA_TIMESTAMP.getText());
        this.migrateFromDefaultStorageToCustom(V0StorageKeys.SESSION_TIMESTAMP.getText(), StorageKeys.SESSION_TIMESTAMP.getText());
        this.migrateFromDefaultStorageToCustom(V0StorageKeys.CONSENTS_BUFFER.getText(), StorageKeys.CONSENTS_BUFFER.getText());
        this.migrateFromDefaultStorageToCustom(V0StorageKeys.TCF.getText(), StorageKeys.TCF.getText());
        this.migrateSettings();
        this.clear();
    }

    private final void migrateFromDefaultStorageToCustom(String oldKey, String newKey) {
        String value;
        String string = value = this.getLegacyValue(oldKey);
        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            this.storeNewValue(newKey, value);
        }
    }

    private final String getLegacyValue(String oldKey) {
        return this.getStorageHolder().getDefaultKeyValueStorage().getString(oldKey, null);
    }

    private final void storeNewValue(String newKey, String value) {
        this.getStorageHolder().getUsercentricsKeyValueStorage().put(newKey, value);
    }

    private final void migrateSettings() {
        String legacyValue = this.getLegacyValue(V0StorageKeys.SETTINGS.getText());
        CharSequence charSequence = legacyValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        StorageSettings newSettings = this.storageSettingsFromLegacyJson(legacyValue);
        String string = StorageKeys.SETTINGS.getText();
        JsonParser this_$iv = this.jsonParser;
        boolean $i$f$encodeToString = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$encodeToString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(StorageSettings.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        this.storeNewValue(string, $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)newSettings));
    }

    /*
     * WARNING - void declaration
     */
    private final StorageSettings storageSettingsFromLegacyJson(String legacyValue) {
        void $this$mapTo$iv$iv;
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializer$iv = (DeserializationStrategy)JsonObject.Companion.serializer();
        boolean $i$f$decodeFromString = false;
        JsonObject settingsJsonObject = (JsonObject)JsonParserKt.access$getJson$p().decodeFromString(deserializer$iv, legacyValue);
        Object object = settingsJsonObject.get((Object)"services");
        Intrinsics.checkNotNull((Object)object);
        JsonArray servicesArray = JsonElementKt.getJsonArray((JsonElement)((JsonElement)object));
        Iterable $this$map$iv = (Iterable)servicesArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonObject serviceJsonObject = JsonElementKt.getJsonObject((JsonElement)it);
            List<StorageConsentHistory> list = this.settingsHistoryFromServiceJson(serviceJsonObject);
            Object object2 = serviceJsonObject.get((Object)"id");
            Intrinsics.checkNotNull((Object)object2);
            String string = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object2)).getContent();
            Object object3 = serviceJsonObject.get((Object)"processorId");
            Intrinsics.checkNotNull((Object)object3);
            String string2 = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object3)).getContent();
            Object object4 = serviceJsonObject.get((Object)"status");
            Intrinsics.checkNotNull((Object)object4);
            collection.add(new StorageService(list, string, string2, JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object4)))));
        }
        List services = (List)destination$iv$iv;
        Object object5 = settingsJsonObject.get((Object)"controllerId");
        Intrinsics.checkNotNull((Object)object5);
        String string = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object5)).getContent();
        Object object6 = settingsJsonObject.get((Object)"id");
        Intrinsics.checkNotNull((Object)object6);
        String string3 = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object6)).getContent();
        Object object7 = settingsJsonObject.get((Object)"language");
        Intrinsics.checkNotNull((Object)object7);
        String string4 = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object7)).getContent();
        Object object8 = settingsJsonObject.get((Object)"version");
        Intrinsics.checkNotNull((Object)object8);
        return new StorageSettings(string, string3, string4, services, JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object8)).getContent());
    }

    /*
     * WARNING - void declaration
     */
    private final List<StorageConsentHistory> settingsHistoryFromServiceJson(JsonObject serviceJsonObject) {
        void $this$mapTo$iv$iv;
        Object object = serviceJsonObject.get((Object)"history");
        Intrinsics.checkNotNull((Object)object);
        Iterable $this$map$iv = (Iterable)JsonElementKt.getJsonArray((JsonElement)((JsonElement)object));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void historyJson;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonObject historyJsonObject = JsonElementKt.getJsonObject((JsonElement)historyJson);
            Object object2 = historyJsonObject.get((Object)"timestamp");
            Intrinsics.checkNotNull((Object)object2);
            double timestampInSeconds = JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object2)));
            long timestampInMillis = TimeExtensionsKt.secondsToMillis((long)timestampInSeconds);
            Object object3 = historyJsonObject.get((Object)"action");
            Intrinsics.checkNotNull((Object)object3);
            UsercentricsConsentAction consentAction = UsercentricsConsentAction.valueOf(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object3)).getContent());
            Object object4 = historyJsonObject.get((Object)"type");
            Intrinsics.checkNotNull((Object)object4);
            UsercentricsConsentType consentType = UsercentricsConsentType.valueOf(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object4)).getContent());
            StorageConsentAction storageConsentAction = StorageConsentAction.Companion.fromConsentAction(consentAction);
            Object object5 = historyJsonObject.get((Object)"status");
            Intrinsics.checkNotNull((Object)object5);
            boolean bl2 = JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object5)));
            StorageConsentType storageConsentType = StorageConsentType.Companion.fromConsentType(consentType);
            Object object6 = historyJsonObject.get((Object)"language");
            Intrinsics.checkNotNull((Object)object6);
            collection.add(new StorageConsentHistory(storageConsentAction, bl2, storageConsentType, JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object6)).getContent(), timestampInMillis));
        }
        return (List)destination$iv$iv;
    }

    private final void clear() {
        V0StorageKeys[] $this$forEach$iv = V0StorageKeys.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            V0StorageKeys element$iv;
            V0StorageKeys key = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.getStorageHolder().getDefaultKeyValueStorage().deleteKey(key.getText());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion1$V0StorageKeys;", "", "text", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "CACHE_KEY", "CCPA_TIMESTAMP", "CMP_ID", "CONSENTS_BUFFER", "SESSION_TIMESTAMP", "SETTINGS", "TCF", "SESSION_BUFFER", "USER_INTERACTION", "usercentrics_release"})
    public static final class V0StorageKeys
    extends Enum<V0StorageKeys> {
        @NotNull
        private final String text;
        public static final /* enum */ V0StorageKeys CACHE_KEY = new V0StorageKeys("uc_cache");
        public static final /* enum */ V0StorageKeys CCPA_TIMESTAMP = new V0StorageKeys("uc_ccpa");
        public static final /* enum */ V0StorageKeys CMP_ID = new V0StorageKeys("CMP-ID");
        public static final /* enum */ V0StorageKeys CONSENTS_BUFFER = new V0StorageKeys("uc_consents_buffer");
        public static final /* enum */ V0StorageKeys SESSION_TIMESTAMP = new V0StorageKeys("uc_session_timestamp");
        public static final /* enum */ V0StorageKeys SETTINGS = new V0StorageKeys("uc_settings");
        public static final /* enum */ V0StorageKeys TCF = new V0StorageKeys("uc_tcf");
        public static final /* enum */ V0StorageKeys SESSION_BUFFER = new V0StorageKeys("uc_session_buffer");
        public static final /* enum */ V0StorageKeys USER_INTERACTION = new V0StorageKeys("uc_user_interaction");
        private static final /* synthetic */ V0StorageKeys[] $VALUES;

        private V0StorageKeys(String text) {
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static V0StorageKeys[] values() {
            return (V0StorageKeys[])$VALUES.clone();
        }

        public static V0StorageKeys valueOf(String value) {
            return Enum.valueOf(V0StorageKeys.class, value);
        }

        static {
            $VALUES = v0StorageKeysArray = new V0StorageKeys[]{V0StorageKeys.CACHE_KEY, V0StorageKeys.CCPA_TIMESTAMP, V0StorageKeys.CMP_ID, V0StorageKeys.CONSENTS_BUFFER, V0StorageKeys.SESSION_TIMESTAMP, V0StorageKeys.SETTINGS, V0StorageKeys.TCF, V0StorageKeys.SESSION_BUFFER, V0StorageKeys.USER_INTERACTION};
        }
    }
}

