/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage.migrations;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.services.dataFacade.DataFacade;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.StorageKeys;
import com.usercentrics.sdk.services.deviceStorage.migrations.AbstractMigrationSettingsV2;
import com.usercentrics.sdk.services.deviceStorage.models.StorageService;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3;", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/AbstractMigrationSettingsV2;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "json", "Lcom/usercentrics/sdk/core/json/JsonParser;", "isTVOS", "", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/core/json/JsonParser;Z)V", "migrate", "", "processSettings", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSettings;", "settings", "V2StorageKeys", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMigrationToVersion3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationToVersion3.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n40#2:73\n1549#3:74\n1620#3,3:75\n*S KotlinDebug\n*F\n+ 1 MigrationToVersion3.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3\n*L\n39#1:73\n51#1:74\n51#1:75,3\n*E\n"})
public final class MigrationToVersion3
extends AbstractMigrationSettingsV2 {
    @NotNull
    private final JsonParser json;
    private final boolean isTVOS;

    public MigrationToVersion3(@NotNull StorageHolder storageHolder, @NotNull JsonParser json2, boolean isTVOS) {
        Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        super(3, storageHolder, json2);
        this.json = json2;
        this.isTVOS = isTVOS;
    }

    @Override
    public void migrate() {
        if (!this.isTVOS) {
            return;
        }
        String settingsValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString(V2StorageKeys.SETTINGS.getText(), null);
        CharSequence charSequence = settingsValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        int storageVersionValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getNumber(V2StorageKeys.STORAGE_VERSION.getText(), -1);
        String ccpaTimestampValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString(V2StorageKeys.CCPA_TIMESTAMP.getText(), null);
        String consentsBufferValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString(V2StorageKeys.CONSENTS_BUFFER.getText(), null);
        String sessionTimestampValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString(V2StorageKeys.SESSION_TIMESTAMP.getText(), null);
        String tcfValue = this.getStorageHolder().getUsercentricsKeyValueStorage().getString(V2StorageKeys.TCF.getText(), null);
        this.getStorageHolder().getUsercentricsKeyValueStorage().purgeStorage();
        StorageSettings newSettings = this.processSettings(this.storageSettingsFromCache(settingsValue));
        JsonParser jsonParser = this.json;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageSettings.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.SETTINGS.getText(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)newSettings));
        if (storageVersionValue != -1) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.STORAGE_VERSION.getText(), storageVersionValue);
        }
        if (ccpaTimestampValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.CCPA_TIMESTAMP.getText(), ccpaTimestampValue);
        }
        if (consentsBufferValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.CONSENTS_BUFFER.getText(), consentsBufferValue);
        }
        if (sessionTimestampValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.SESSION_TIMESTAMP.getText(), sessionTimestampValue);
        }
        if (tcfValue != null) {
            this.getStorageHolder().getUsercentricsKeyValueStorage().put(StorageKeys.TCF.getText(), tcfValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final StorageSettings processSettings(StorageSettings settings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = settings.getServices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageService storageService = (StorageService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHistory().size() > DataFacade.Companion.getMaxStorageHistorySize() ? StorageService.copy$default((StorageService)it, CollectionsKt.takeLast(it.getHistory(), (int)DataFacade.Companion.getMaxStorageHistorySize()), null, null, false, 14, null) : it);
        }
        List servicesWithHistorySize = (List)destination$iv$iv;
        return StorageSettings.copy$default(settings, null, null, null, servicesWithHistorySize, null, 23, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion3$V2StorageKeys;", "", "text", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "STORAGE_VERSION", "CACHE_KEY", "CCPA_TIMESTAMP", "CONSENTS_BUFFER", "SESSION_TIMESTAMP", "SETTINGS", "TCF", "SESSION_BUFFER", "usercentrics_release"})
    public static final class V2StorageKeys
    extends Enum<V2StorageKeys> {
        @NotNull
        private final String text;
        public static final /* enum */ V2StorageKeys STORAGE_VERSION = new V2StorageKeys("storage_version");
        public static final /* enum */ V2StorageKeys CACHE_KEY = new V2StorageKeys("cache");
        public static final /* enum */ V2StorageKeys CCPA_TIMESTAMP = new V2StorageKeys("ccpa_timestamp_millis");
        public static final /* enum */ V2StorageKeys CONSENTS_BUFFER = new V2StorageKeys("consents_buffer");
        public static final /* enum */ V2StorageKeys SESSION_TIMESTAMP = new V2StorageKeys("session_timestamp");
        public static final /* enum */ V2StorageKeys SETTINGS = new V2StorageKeys("settings");
        public static final /* enum */ V2StorageKeys TCF = new V2StorageKeys("tcf");
        public static final /* enum */ V2StorageKeys SESSION_BUFFER = new V2StorageKeys("session_buffer");
        private static final /* synthetic */ V2StorageKeys[] $VALUES;

        private V2StorageKeys(String text) {
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static V2StorageKeys[] values() {
            return (V2StorageKeys[])$VALUES.clone();
        }

        public static V2StorageKeys valueOf(String value) {
            return Enum.valueOf(V2StorageKeys.class, value);
        }

        static {
            $VALUES = v2StorageKeysArray = new V2StorageKeys[]{V2StorageKeys.STORAGE_VERSION, V2StorageKeys.CACHE_KEY, V2StorageKeys.CCPA_TIMESTAMP, V2StorageKeys.CONSENTS_BUFFER, V2StorageKeys.SESSION_TIMESTAMP, V2StorageKeys.SETTINGS, V2StorageKeys.TCF, V2StorageKeys.SESSION_BUFFER};
        }
    }
}

