/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.tcf;

import com.usercentrics.sdk.AssertionsKt;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.extensions.ArrayExtensionsKt;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.settings.UsercentricsConsentAction;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF;
import com.usercentrics.sdk.services.deviceStorage.models.StorageVendor;
import com.usercentrics.sdk.services.tcf.TCF;
import com.usercentrics.sdk.services.tcf.TCFDecisionUILayer;
import com.usercentrics.sdk.services.tcf.TCFKt;
import com.usercentrics.sdk.services.tcf.TCFUseCase;
import com.usercentrics.sdk.services.tcf.TCF_VENDOR_PURPOSE_TYPE;
import com.usercentrics.sdk.services.tcf.TCF_WARN_MESSAGES;
import com.usercentrics.sdk.services.tcf.UsercentricsTCFSettings;
import com.usercentrics.sdk.services.tcf.interfaces.IdAndConsent;
import com.usercentrics.sdk.services.tcf.interfaces.IdAndName;
import com.usercentrics.sdk.services.tcf.interfaces.TCFConsentDecision;
import com.usercentrics.sdk.services.tcf.interfaces.TCFConsentWithLegitimateInterestDecision;
import com.usercentrics.sdk.services.tcf.interfaces.TCFData;
import com.usercentrics.sdk.services.tcf.interfaces.TCFFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFStack;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnSpecialFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisionOnVendor;
import com.usercentrics.sdk.services.tcf.interfaces.TCFUserDecisions;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendorRestriction;
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher;
import com.usercentrics.sdk.v2.async.dispatcher.DispatcherScope;
import com.usercentrics.sdk.v2.async.dispatcher.Semaphore;
import com.usercentrics.sdk.v2.consent.service.ConsentsService;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.service.ILocationService;
import com.usercentrics.sdk.v2.settings.data.NewSettingsData;
import com.usercentrics.sdk.v2.settings.data.TCF2ChangedPurposes;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.settings.service.ISettingsService;
import com.usercentrics.sdk.v2.tcf.facade.TCFFacade;
import com.usercentrics.tcf.core.GVL;
import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.TCFKeys;
import com.usercentrics.tcf.core.TCFStoragePayload;
import com.usercentrics.tcf.core.TCModel;
import com.usercentrics.tcf.core.TCString;
import com.usercentrics.tcf.core.encoder.TCFKeysEncoder;
import com.usercentrics.tcf.core.errors.GVLError;
import com.usercentrics.tcf.core.model.ConsentLanguages;
import com.usercentrics.tcf.core.model.PurposeRestriction;
import com.usercentrics.tcf.core.model.PurposeRestrictionVector;
import com.usercentrics.tcf.core.model.RestrictionType;
import com.usercentrics.tcf.core.model.Vector;
import com.usercentrics.tcf.core.model.gvl.DataCategory;
import com.usercentrics.tcf.core.model.gvl.DataRetention;
import com.usercentrics.tcf.core.model.gvl.Feature;
import com.usercentrics.tcf.core.model.gvl.GvlDataRetention;
import com.usercentrics.tcf.core.model.gvl.Purpose;
import com.usercentrics.tcf.core.model.gvl.RetentionPeriod;
import com.usercentrics.tcf.core.model.gvl.Stack;
import com.usercentrics.tcf.core.model.gvl.Vendor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 y2\u00020\u0001:\u0001yBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J2\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020!0,H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u001503H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020503H\u0002J\b\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001503H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u001903H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001503H\u0002J\b\u0010;\u001a\u000207H\u0016J\b\u0010<\u001a\u000207H\u0016J\b\u0010=\u001a\u000207H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001f03H\u0002J\n\u0010?\u001a\u0004\u0018\u00010@H\u0002J\b\u0010A\u001a\u00020\u0015H\u0016J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001503H\u0002J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020D03H\u0002J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001503H\u0002J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020G03H\u0002J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020I03H\u0002J\b\u0010J\u001a\u00020\u0015H\u0016J\n\u0010K\u001a\u0004\u0018\u00010LH\u0002J\b\u0010M\u001a\u00020\u001dH\u0016J\u0006\u0010N\u001a\u00020&J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020P032\u0006\u0010Q\u001a\u00020\u0015H\u0002J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001f03H\u0002J\u001e\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020L2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001f03H\u0002J<\u0010V\u001a\u00020!2\u0006\u0010T\u001a\u00020L2\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020!0,H\u0002J\u001e\u0010W\u001a\u00020!2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u0015032\u0006\u0010X\u001a\u00020YH\u0002J*\u0010Z\u001a\u00020!2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020!0*2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020!0,H\u0016J*\u0010]\u001a\b\u0012\u0004\u0012\u00020^032\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`032\f\u00100\u001a\b\u0012\u0004\u0012\u00020a03H\u0002J\u0010\u0010b\u001a\u00020!2\u0006\u0010T\u001a\u00020LH\u0002J2\u0010c\u001a\u00020!2\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020!0,H\u0002J\b\u0010d\u001a\u00020!H\u0002J$\u0010e\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160gH\u0016J\u0016\u0010h\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020i03H\u0002J\u0016\u0010j\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020k03H\u0002J\u0016\u0010l\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020m03H\u0002J\u0010\u0010n\u001a\u00020!2\u0006\u0010o\u001a\u00020\u0015H\u0016J$\u0010p\u001a\u00020!2\u0006\u0010T\u001a\u00020L2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160gH\u0002J\b\u0010r\u001a\u00020!H\u0002J\b\u0010s\u001a\u00020!H\u0002J\b\u0010t\u001a\u00020!H\u0002J\u0018\u0010u\u001a\u00020!2\u0006\u00100\u001a\u00020/2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010v\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010w\u001a\u00020!H\u0002J\u0010\u0010x\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/usercentrics/sdk/services/tcf/TCF;", "Lcom/usercentrics/sdk/services/tcf/TCFUseCase;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "settingsService", "Lcom/usercentrics/sdk/v2/settings/service/ISettingsService;", "storageInstance", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "consentsService", "Lcom/usercentrics/sdk/v2/consent/service/ConsentsService;", "locationService", "Lcom/usercentrics/sdk/v2/location/service/ILocationService;", "tcfFacade", "Lcom/usercentrics/sdk/v2/tcf/facade/TCFFacade;", "dispatcher", "Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;", "semaphore", "Lcom/usercentrics/sdk/v2/async/dispatcher/Semaphore;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/settings/service/ISettingsService;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/v2/consent/service/ConsentsService;Lcom/usercentrics/sdk/v2/location/service/ILocationService;Lcom/usercentrics/sdk/v2/tcf/facade/TCFFacade;Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;Lcom/usercentrics/sdk/v2/async/dispatcher/Semaphore;)V", "disclosedVendorsMap", "", "", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageVendor;", "purposes", "", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFPurpose;", "tcModel", "Lcom/usercentrics/tcf/core/TCModel;", "tcfData", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFData;", "vendors", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendor;", "acceptAllDisclosed", "", "fromLayer", "Lcom/usercentrics/sdk/services/tcf/TCFDecisionUILayer;", "applyTCString", "tcString", "", "changeLanguage", "language", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lcom/usercentrics/sdk/errors/UsercentricsException;", "createTCFUserDecisionsMergingWithCurrentData", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFUserDecisions;", "decisions", "denyAllDisclosed", "getFeatureIdsFromVendors", "", "getFeaturesFromVendors", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFFeature;", "getGdprAppliesOnTCF", "", "getPurposeIdsFromVendorsAndStacks", "getPurposesFromVendors", "getRawSelectedVendorIds", "getResurfacePeriodEnded", "getResurfacePurposeChanged", "getResurfaceVendorAdded", "getSelectedTCFVendors", "getSettings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "getSettingsTCFPolicyVersion", "getSpecialFeatureIdsFromVendorsAndStacks", "getSpecialFeaturesFromVendorsAndStacks", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFSpecialFeature;", "getSpecialPurposeIdsFromVendors", "getSpecialPurposesFromVendors", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFSpecialPurpose;", "getStacks", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFStack;", "getStoredTcStringPolicyVersion", "getTCF2Settings", "Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "getTCFData", "getTCStringFromModel", "getVendorRestrictions", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendorRestriction;", "vendorId", "getVendors", "initDisclosedVendors", "tcf2Settings", "allVendors", "initTCModel", "initTCModelApplyVendorPurposeRestrictions", "targetPurposeType", "Lcom/usercentrics/sdk/services/tcf/TCF_VENDOR_PURPOSE_TYPE;", "initialize", "callback", "onFailure", "mergeConsentsWithUserDecisions", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFConsentDecision;", "data", "Lcom/usercentrics/sdk/services/tcf/interfaces/IdAndConsent;", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFConsentWithLegitimateInterestDecision;", "overrideTCModel", "resetGVLWithLanguage", "resetTCFData", "restore", "vendorsDisclosed", "", "savePurposes", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFUserDecisionOnPurpose;", "saveSpecialFeatures", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFUserDecisionOnSpecialFeature;", "saveVendors", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFUserDecisionOnVendor;", "setCmpId", "id", "setDisclosedVendors", "disclosedVendors", "setPurposes", "setTCFData", "setVendors", "updateChoices", "updateIABTCFKeys", "updatePolicyVersion", "updateTCString", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCF.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCF.kt\ncom/usercentrics/sdk/services/tcf/TCF\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1045:1\n1855#2:1046\n1549#2:1047\n1620#2,3:1048\n1549#2:1051\n1620#2,3:1052\n1856#2:1055\n1271#2,2:1056\n1285#2,2:1058\n288#2,2:1060\n1288#2:1062\n1855#2,2:1070\n1855#2,2:1072\n1549#2:1075\n1620#2,3:1076\n1549#2:1079\n1620#2,3:1080\n766#2:1083\n857#2,2:1084\n1549#2:1086\n1620#2,3:1087\n1549#2:1090\n1620#2,3:1091\n1855#2:1094\n766#2:1095\n857#2,2:1096\n766#2:1098\n857#2,2:1099\n766#2:1101\n857#2,2:1102\n766#2:1104\n857#2,2:1105\n1856#2:1107\n1549#2:1108\n1620#2,3:1109\n1549#2:1112\n1620#2,3:1113\n766#2:1116\n857#2,2:1117\n1549#2:1119\n1620#2,3:1120\n1549#2:1123\n1620#2,3:1124\n1549#2:1127\n1620#2,3:1128\n1855#2:1132\n766#2:1133\n857#2,2:1134\n1856#2:1136\n766#2:1137\n857#2,2:1138\n1726#2,3:1140\n1549#2:1143\n1620#2,3:1144\n1726#2,3:1147\n1855#2:1150\n1549#2:1151\n1620#2,3:1152\n1549#2:1155\n1620#2,3:1156\n1856#2:1159\n1855#2,2:1160\n766#2:1162\n857#2,2:1163\n1855#2:1165\n766#2:1166\n857#2,2:1167\n1549#2:1169\n1620#2,3:1170\n1856#2:1173\n1855#2:1174\n766#2:1175\n857#2,2:1176\n1856#2:1178\n1549#2:1179\n1620#2,3:1180\n1549#2:1183\n1620#2,3:1184\n1549#2:1187\n1620#2,3:1188\n1549#2:1191\n1620#2,3:1192\n1855#2:1195\n288#2,2:1196\n1856#2:1198\n1855#2,2:1199\n1855#2:1201\n1549#2:1202\n1620#2,3:1203\n1856#2:1206\n1549#2:1207\n1620#2,3:1208\n1855#2,2:1211\n1549#2:1213\n1620#2,2:1214\n1549#2:1216\n1620#2,3:1217\n1855#2,2:1220\n1855#2,2:1222\n1855#2:1224\n1856#2:1226\n1855#2,2:1227\n1855#2:1229\n1549#2:1230\n1620#2,3:1231\n1856#2:1234\n1855#2,2:1235\n1855#2,2:1237\n1855#2,2:1239\n515#3:1063\n500#3,6:1064\n215#4:1074\n216#4:1131\n1#5:1225\n*S KotlinDebug\n*F\n+ 1 TCF.kt\ncom/usercentrics/sdk/services/tcf/TCF\n*L\n140#1:1046\n147#1:1047\n147#1:1048,3\n153#1:1051\n153#1:1052,3\n140#1:1055\n310#1:1056,2\n310#1:1058,2\n311#1:1060,2\n310#1:1062\n351#1:1070,2\n363#1:1072,2\n392#1:1075\n392#1:1076,3\n393#1:1079\n393#1:1080,3\n396#1:1083\n396#1:1084,2\n404#1:1086\n404#1:1087,3\n405#1:1090\n405#1:1091,3\n407#1:1094\n410#1:1095\n410#1:1096,2\n422#1:1098\n422#1:1099,2\n434#1:1101\n434#1:1102,2\n438#1:1104\n438#1:1105,2\n407#1:1107\n445#1:1108\n445#1:1109,3\n446#1:1112\n446#1:1113,3\n447#1:1116\n447#1:1117,2\n451#1:1119\n451#1:1120,3\n452#1:1123\n452#1:1124,3\n454#1:1127\n454#1:1128,3\n505#1:1132\n516#1:1133\n516#1:1134,2\n505#1:1136\n532#1:1137\n532#1:1138,2\n556#1:1140,3\n571#1:1143\n571#1:1144,3\n571#1:1147,3\n580#1:1150\n581#1:1151\n581#1:1152,3\n582#1:1155\n582#1:1156,3\n580#1:1159\n586#1:1160,2\n597#1:1162\n597#1:1163,2\n608#1:1165\n611#1:1166\n611#1:1167,2\n616#1:1169\n616#1:1170,3\n608#1:1173\n620#1:1174\n622#1:1175\n622#1:1176,2\n620#1:1178\n752#1:1179\n752#1:1180,3\n753#1:1183\n753#1:1184,3\n759#1:1187\n759#1:1188,3\n760#1:1191\n760#1:1192,3\n768#1:1195\n769#1:1196,2\n768#1:1198\n788#1:1199,2\n808#1:1201\n809#1:1202\n809#1:1203,3\n808#1:1206\n833#1:1207\n833#1:1208,3\n834#1:1211,2\n838#1:1213\n838#1:1214,2\n838#1:1216\n838#1:1217,3\n839#1:1220,2\n842#1:1222,2\n883#1:1224\n883#1:1226\n913#1:1227,2\n936#1:1229\n937#1:1230\n937#1:1231,3\n936#1:1234\n946#1:1235,2\n962#1:1237,2\n980#1:1239,2\n313#1:1063\n313#1:1064,6\n387#1:1074\n387#1:1131\n*E\n"})
public final class TCF
implements TCFUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final ISettingsService settingsService;
    @NotNull
    private final DeviceStorage storageInstance;
    @NotNull
    private final ConsentsService consentsService;
    @NotNull
    private final ILocationService locationService;
    @NotNull
    private final TCFFacade tcfFacade;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final Semaphore semaphore;
    @Nullable
    private TCModel tcModel;
    @Nullable
    private TCFData tcfData;
    @NotNull
    private final List<TCFVendor> vendors;
    @NotNull
    private final List<TCFPurpose> purposes;
    @NotNull
    private Map<Integer, StorageVendor> disclosedVendorsMap;

    public TCF(@NotNull UsercentricsLogger logger2, @NotNull ISettingsService settingsService2, @NotNull DeviceStorage storageInstance2, @NotNull ConsentsService consentsService2, @NotNull ILocationService locationService2, @NotNull TCFFacade tcfFacade, @NotNull Dispatcher dispatcher2, @NotNull Semaphore semaphore) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)settingsService2, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)storageInstance2, (String)"storageInstance");
        Intrinsics.checkNotNullParameter((Object)consentsService2, (String)"consentsService");
        Intrinsics.checkNotNullParameter((Object)locationService2, (String)"locationService");
        Intrinsics.checkNotNullParameter((Object)tcfFacade, (String)"tcfFacade");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)semaphore, (String)"semaphore");
        this.logger = logger2;
        this.settingsService = settingsService2;
        this.storageInstance = storageInstance2;
        this.consentsService = consentsService2;
        this.locationService = locationService2;
        this.tcfFacade = tcfFacade;
        this.dispatcher = dispatcher2;
        this.semaphore = semaphore;
        this.vendors = new ArrayList();
        this.purposes = new ArrayList();
        this.disclosedVendorsMap = new LinkedHashMap();
    }

    private final void resetTCFData() {
        this.vendors.clear();
        this.purposes.clear();
        this.tcfData = null;
    }

    private final UsercentricsSettings getSettings() {
        NewSettingsData newSettingsData = this.settingsService.getSettings();
        return newSettingsData != null ? newSettingsData.getData() : null;
    }

    private final TCF2Settings getTCF2Settings() {
        UsercentricsSettings usercentricsSettings = this.getSettings();
        return usercentricsSettings != null ? usercentricsSettings.getTcf2() : null;
    }

    @Override
    public void initialize(@NotNull Function0<Unit> callback, @NotNull Function1<? super UsercentricsException, Unit> onFailure) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        TCF2Settings tcf2Settings = this.getTCF2Settings();
        if (tcf2Settings == null) {
            onFailure.invoke((Object)new UsercentricsException("TCF Options are empty", new IllegalStateException()));
        } else {
            String globalTCString = this.storageInstance.fetchTCFData().getTcString();
            this.initTCModel(tcf2Settings, globalTCString, callback, onFailure);
        }
    }

    @Override
    public void restore(@NotNull String tcString, @NotNull Map<Integer, StorageVendor> vendorsDisclosed) {
        Intrinsics.checkNotNullParameter((Object)tcString, (String)"tcString");
        Intrinsics.checkNotNullParameter(vendorsDisclosed, (String)"vendorsDisclosed");
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        TCF2Settings tcf2Settings = tCF2Settings;
        this.setDisclosedVendors(tcf2Settings, vendorsDisclosed);
        this.storageInstance.saveTCFData(new StorageTCF(tcString, vendorsDisclosed, null, 4, null));
        this.applyTCString(tcString);
        this.overrideTCModel(tcf2Settings);
        this.resetTCFData();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void acceptAllDisclosed(@NotNull TCFDecisionUILayer fromLayer) {
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
            Object object2 = this;
            try {
                TCF $this$acceptAllDisclosed_u24lambda_u243 = object2;
                boolean bl = false;
                TCModel tCModel = $this$acceptAllDisclosed_u24lambda_u243.tcModel;
                Intrinsics.checkNotNull((Object)tCModel);
                TCModel internalTCModel = tCModel;
                Set purposeConsents = new LinkedHashSet();
                List tempSetVendorConsents = new ArrayList();
                List tempUnsetVendorConsents = new ArrayList();
                List allVendorsIds = new ArrayList();
                Set purposeLegitimateInterests = new LinkedHashSet();
                List<TCFVendor> allVendors = $this$acceptAllDisclosed_u24lambda_u243.getVendors();
                List<Integer> excludedVendors = UsercentricsTCFSettings.INSTANCE.getExcludedVendors$usercentrics_release();
                Iterable $this$forEach$iv = allVendors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdAndName purpose;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    boolean $i$f$mapTo;
                    Collection destination$iv$iv;
                    Iterable $this$map$iv;
                    boolean $i$f$map;
                    Set set;
                    TCFVendor vendor = (TCFVendor)element$iv;
                    boolean bl2 = false;
                    if (excludedVendors.contains(vendor.getId())) continue;
                    if (!((Collection)vendor.getPurposes()).isEmpty()) {
                        tempSetVendorConsents.add(vendor.getId());
                        Iterable iterable = vendor.getPurposes();
                        set = purposeConsents;
                        $i$f$map = false;
                        void var22_25 = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            IdAndName idAndName = (IdAndName)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(purpose.getId());
                        }
                        set.addAll((List)destination$iv$iv);
                    } else {
                        tempUnsetVendorConsents.add(vendor.getId());
                    }
                    allVendorsIds.add(vendor.getId());
                    $this$map$iv = vendor.getLegitimateInterestPurposes();
                    set = purposeLegitimateInterests;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void purpuse;
                        purpose = (IdAndName)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(purpuse.getId());
                    }
                    set.addAll((List)destination$iv$iv);
                }
                TCF2Settings tCF2Settings = $this$acceptAllDisclosed_u24lambda_u243.getTCF2Settings();
                Intrinsics.checkNotNull((Object)tCF2Settings);
                $this$acceptAllDisclosed_u24lambda_u243.setDisclosedVendors(tCF2Settings, TCFKt.access$toStorageVendorMap(allVendors));
                internalTCModel.getVendorConsents().set(tempSetVendorConsents);
                internalTCModel.getVendorConsents().unset(tempUnsetVendorConsents);
                internalTCModel.getVendorLegitimateInterests().set(allVendorsIds);
                List tempUnsetLegitimateInterest = new ArrayList();
                internalTCModel.getVendorLegitimateInterests().unset(tempUnsetLegitimateInterest);
                internalTCModel.getPurposeConsents().set(CollectionsKt.toList((Iterable)purposeConsents));
                internalTCModel.getPurposeLegitimateInterests().set(CollectionsKt.toList((Iterable)purposeLegitimateInterests));
                TCF2Settings tCF2Settings2 = $this$acceptAllDisclosed_u24lambda_u243.getTCF2Settings();
                Intrinsics.checkNotNull((Object)tCF2Settings2);
                if (tCF2Settings2.getHideLegitimateInterestToggles()) {
                    internalTCModel.unsetAllVendorLegitimateInterests();
                    internalTCModel.unsetAllPurposeLegitimateInterests();
                }
                internalTCModel.getSpecialFeatureOptins().set($this$acceptAllDisclosed_u24lambda_u243.getSpecialFeatureIdsFromVendorsAndStacks());
                $this$acceptAllDisclosed_u24lambda_u243.updateTCString(fromLayer);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block8;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Something went wrong with TCF acceptAllDisclosed method: " + it, (Throwable)it);
        }
    }

    @Override
    public void changeLanguage(@NotNull String language, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super UsercentricsException, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        String supportedLanguage = Companion.resolveLanguage(language);
        this.resetGVLWithLanguage(supportedLanguage, (Function0<Unit>)((Function0)new Function0<Unit>(this, onSuccess){
            final /* synthetic */ TCF this$0;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                super(0);
            }

            public final void invoke() {
                Object object = TCF.access$getTcModel$p(this.this$0);
                if (object != null && (object = ((TCModel)object).getGvl()) != null) {
                    ((GVL)object).narrowVendorsTo(TCF.access$getRawSelectedVendorIds(this.this$0));
                }
                TCF.access$resetTCFData(this.this$0);
                this.$onSuccess.invoke();
            }
        }), onError2);
    }

    @Override
    public void denyAllDisclosed(@NotNull TCFDecisionUILayer fromLayer) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
            Object object2 = this;
            try {
                TCF $this$denyAllDisclosed_u24lambda_u245 = object2;
                boolean bl = false;
                TCModel tCModel = $this$denyAllDisclosed_u24lambda_u245.tcModel;
                Intrinsics.checkNotNull((Object)tCModel);
                TCModel internalTCModel = tCModel;
                internalTCModel.unsetAllVendorConsents();
                internalTCModel.unsetAllVendorLegitimateInterests();
                internalTCModel.getPurposeConsents().unset($this$denyAllDisclosed_u24lambda_u245.getPurposeIdsFromVendorsAndStacks());
                internalTCModel.getPurposeLegitimateInterests().unset($this$denyAllDisclosed_u24lambda_u245.getPurposeIdsFromVendorsAndStacks());
                internalTCModel.getSpecialFeatureOptins().unset($this$denyAllDisclosed_u24lambda_u245.getSpecialFeatureIdsFromVendorsAndStacks());
                TCF2Settings tCF2Settings = $this$denyAllDisclosed_u24lambda_u245.getTCF2Settings();
                Intrinsics.checkNotNull((Object)tCF2Settings);
                $this$denyAllDisclosed_u24lambda_u245.setDisclosedVendors(tCF2Settings, TCFKt.access$toStorageVendorMap($this$denyAllDisclosed_u24lambda_u245.getVendors()));
                $this$denyAllDisclosed_u24lambda_u245.updateTCString(fromLayer);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Something went wrong with TCF denyAllDisclosed method: " + it, (Throwable)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TCFData getTCFData() {
        AssertionsKt.assertNotUIThread();
        this.semaphore.acquire();
        try {
            if (this.tcfData == null) {
                this.setTCFData();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.semaphore.release();
        }
        TCFData tCFData = this.tcfData;
        Intrinsics.checkNotNull((Object)tCFData);
        return tCFData;
    }

    private final void setTCFData() {
        Object object;
        AssertionsKt.assertNotUIThread();
        this.tcfData = new TCFData(ArrayExtensionsKt.sortedAlphaBy$default(this.getFeaturesFromVendors(), false, setTCFData.1.INSTANCE, 1, null), CollectionsKt.toMutableList((Collection)this.getPurposesFromVendors()), ArrayExtensionsKt.sortedAlphaBy$default(this.getSpecialFeaturesFromVendorsAndStacks(), false, setTCFData.2.INSTANCE, 1, null), ArrayExtensionsKt.sortedAlphaBy$default(this.getSpecialPurposesFromVendors(), false, setTCFData.3.INSTANCE, 1, null), ArrayExtensionsKt.sortedAlphaBy$default(this.getStacks(), false, setTCFData.4.INSTANCE, 1, null), ArrayExtensionsKt.sortedAlphaBy$default(this.getVendors(), false, setTCFData.5.INSTANCE, 1, null), this.storageInstance.fetchTCFData().getTcString(), this.vendors.size() + ((object = this.settingsService.getSettings()) != null && (object = ((NewSettingsData)object).getServices()) != null ? object.size() : 0));
    }

    private final void initTCModel(TCF2Settings tcf2Settings, String tcString, Function0<Unit> onSuccess, Function1<? super UsercentricsException, Unit> onError2) {
        Function1 onInitSuccess2 = (Function1)new Function1<GVL, Unit>(this, onError2, tcf2Settings, onSuccess){
            final /* synthetic */ TCF this$0;
            final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
            final /* synthetic */ TCF2Settings $tcf2Settings;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$onError = $onError;
                this.$tcf2Settings = $tcf2Settings;
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull GVL gvl) {
                Intrinsics.checkNotNullParameter((Object)gvl, (String)"gvl");
                UsercentricsSettings usercentricsSettings = TCF.access$getSettings(this.this$0);
                Intrinsics.checkNotNull((Object)usercentricsSettings);
                String supportedLanguage = TCF.Companion.resolveLanguage(usercentricsSettings.getLanguage());
                TCF.access$resetGVLWithLanguage(this.this$0, supportedLanguage, (Function0)new Function0<Unit>(this.this$0, gvl, this.$tcf2Settings, this.$onSuccess){
                    final /* synthetic */ TCF this$0;
                    final /* synthetic */ GVL $gvl;
                    final /* synthetic */ TCF2Settings $tcf2Settings;
                    final /* synthetic */ Function0<Unit> $onSuccess;
                    {
                        this.this$0 = $receiver;
                        this.$gvl = $gvl;
                        this.$tcf2Settings = $tcf2Settings;
                        this.$onSuccess = $onSuccess;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        Object object;
                        List selectedVendorIds = TCF.access$getRawSelectedVendorIds(this.this$0);
                        Object object2 = TCF.access$getTcModel$p(this.this$0);
                        if (object2 != null && (object2 = ((TCModel)object2).getGvl()) != null) {
                            ((GVL)object2).narrowVendorsTo(selectedVendorIds);
                        }
                        if ((object = TCF.access$getTcModel$p(this.this$0)) != null && (object = ((TCModel)object).getPublisherRestrictions()) != null) {
                            ((PurposeRestrictionVector)object).setGvl$usercentrics_release(this.$gvl);
                        }
                        if (this.$tcf2Settings.isServiceSpecific()) {
                            void $this$forEach$iv;
                            TCF2ChangedPurposes tCF2ChangedPurposes = this.$tcf2Settings.getChangedPurposes();
                            if (tCF2ChangedPurposes == null) {
                                tCF2ChangedPurposes = new TCF2ChangedPurposes(null, null, 3, null);
                            }
                            TCF2ChangedPurposes changedPurposes = tCF2ChangedPurposes;
                            Iterable iterable = selectedVendorIds;
                            GVL gVL = this.$gvl;
                            TCF tCF = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                int selectedVendorId = ((Number)element$iv).intValue();
                                boolean bl = false;
                                Map<String, Vendor> map2 = gVL.getVendors();
                                Vendor vendor = map2 != null ? map2.get(String.valueOf(selectedVendorId)) : null;
                                if (vendor == null) continue;
                                TCF.access$initTCModelApplyVendorPurposeRestrictions(tCF, changedPurposes.getPurposes(), TCF_VENDOR_PURPOSE_TYPE.PURPOSES);
                                TCF.access$initTCModelApplyVendorPurposeRestrictions(tCF, changedPurposes.getLegIntPurposes(), TCF_VENDOR_PURPOSE_TYPE.LEGITIMATE_INTEREST);
                            }
                        }
                        TCF.access$initDisclosedVendors(this.this$0, this.$tcf2Settings, TCF.access$getVendors(this.this$0));
                        this.$onSuccess.invoke();
                    }
                }, this.$onError);
            }
        };
        GVL gvl = new GVL(this.tcfFacade, null, null, null, null, null, null, null, null, null, null, null, 4094, null);
        this.tcModel = new TCModel(gvl);
        gvl.initialize((Function1<? super GVL, Unit>)onInitSuccess2, onError2);
        CharSequence charSequence = tcString;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.applyTCString(tcString);
        }
        this.overrideTCModel(tcf2Settings);
    }

    /*
     * WARNING - void declaration
     */
    private final void initDisclosedVendors(TCF2Settings tcf2Settings, List<TCFVendor> allVendors) {
        StorageTCF storedTCFData = this.storageInstance.fetchTCFData();
        if (!storedTCFData.getVendorsDisclosedMap().isEmpty()) {
            this.setDisclosedVendors(tcf2Settings, storedTCFData.getVendorsDisclosedMap());
        } else if (!((Collection)storedTCFData.getVendorsDisclosedLegacy()).isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object $this$associateWith$iv = storedTCFData.getVendorsDisclosedLegacy();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                TCFVendor vendor;
                Object object;
                Object v0;
                Map map2;
                Object t;
                block8: {
                    int n = ((Number)element$iv$iv).intValue();
                    t = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = allVendors;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        void legacyDisclosedId;
                        TCFVendor it = (TCFVendor)element$iv;
                        boolean bl2 = false;
                        if (!(it.getId() == legacyDisclosedId)) continue;
                        v0 = element$iv;
                        break block8;
                    }
                    v0 = null;
                }
                if ((object = (vendor = (TCFVendor)v0)) == null || (object = TCFKt.access$toStorageVendor((TCFVendor)object)) == null) {
                    object = StorageVendor.Companion.getEmpty();
                }
                Object object2 = object;
                map2.put(t, object2);
            }
            $this$associateWith$iv = result$iv;
            boolean $i$f$filter = false;
            result$iv = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = (Map.Entry)iterator2.next();
                boolean bl = false;
                if (!(!((StorageVendor)it.getValue()).isEmpty())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map migratedDisclosed = destination$iv$iv;
            this.storageInstance.saveTCFData(new StorageTCF(this.storageInstance.fetchTCFData().getTcString(), migratedDisclosed, null, 4, null));
            this.setDisclosedVendors(tcf2Settings, migratedDisclosed);
        } else {
            this.setDisclosedVendors(tcf2Settings, MapsKt.emptyMap());
        }
    }

    private final void applyTCString(String tcString) {
        try {
            TCModel tCModel = this.tcModel;
            Intrinsics.checkNotNull((Object)tCModel);
            this.tcModel = TCString.Companion.decode$usercentrics_release(tcString, tCModel);
        }
        catch (Throwable e) {
            this.logger.error(TCF_WARN_MESSAGES.INIT_TCF_ERROR.getMessage(), e);
        }
    }

    private final void overrideTCModel(TCF2Settings tcf2Settings) {
        block0: {
            TCModel tCModel;
            TCModel tCModel2 = this.tcModel;
            if (tCModel2 == null) break block0;
            TCModel $this$overrideTCModel_u24lambda_u2410 = tCModel = tCModel2;
            boolean bl = false;
            $this$overrideTCModel_u24lambda_u2410.setCmpId(new StringOrNumber.Int(tcf2Settings.getCmpId()));
            $this$overrideTCModel_u24lambda_u2410.setCmpVersion(new StringOrNumber.Int(tcf2Settings.getCmpVersion()));
            $this$overrideTCModel_u24lambda_u2410.setIsServiceSpecific(tcf2Settings.isServiceSpecific());
            $this$overrideTCModel_u24lambda_u2410.setPublisherCountryCode(tcf2Settings.getPublisherCountryCode());
            $this$overrideTCModel_u24lambda_u2410.setPurposeOneTreatment(tcf2Settings.getPurposeOneTreatment());
        }
    }

    private final void initTCModelApplyVendorPurposeRestrictions(List<Integer> purposes2, TCF_VENDOR_PURPOSE_TYPE targetPurposeType) {
        RestrictionType purposeRestrictionType = targetPurposeType == TCF_VENDOR_PURPOSE_TYPE.PURPOSES ? RestrictionType.REQUIRE_CONSENT : RestrictionType.REQUIRE_LI;
        Iterable $this$forEach$iv = purposes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int purposeId = ((Number)element$iv).intValue();
            boolean bl = false;
            PurposeRestriction purposeRestriction = new PurposeRestriction(purposeId, purposeRestrictionType);
            Object object = this.tcModel;
            if (object == null || (object = ((TCModel)object).getPublisherRestrictions()) == null) continue;
            ((PurposeRestrictionVector)object).initTCModelRestrictPurposeToLegalBasis(purposeRestriction);
        }
    }

    private final List<TCFVendorRestriction> getVendorRestrictions(int vendorId) {
        List result;
        block1: {
            result = new ArrayList();
            Object object = this.tcModel;
            if (object == null || (object = ((TCModel)object).getPublisherRestrictions()) == null || (object = ((PurposeRestrictionVector)object).getRestrictions(vendorId)) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PurposeRestriction restriction = (PurposeRestriction)element$iv;
                boolean bl = false;
                Integer purpuseId = restriction.getPurposeId();
                if (purpuseId == null) continue;
                result.add(new TCFVendorRestriction(purpuseId, restriction.getRestrictionType()));
            }
        }
        return result;
    }

    private final List<TCFVendor> getVendors() {
        if (this.vendors.isEmpty()) {
            this.setVendors();
        }
        return CollectionsKt.toList((Iterable)this.vendors);
    }

    /*
     * WARNING - void declaration
     */
    private final void setVendors() {
        List<TCFVendor> list;
        TCModel globalTCModel = this.tcModel;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        TCF2Settings tcf2Settings = tCF2Settings;
        List vendorList = new ArrayList();
        if (globalTCModel != null) {
            Unit unit;
            GVL gvl = globalTCModel.getGvl();
            Object object = gvl;
            if (object != null && (object = ((GVL)object).getVendors()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    List list2;
                    List list3;
                    List list4;
                    void $this$mapTo$iv$iv;
                    void $this$mapTo$iv$iv2;
                    int n;
                    void $this$filterTo$iv$iv;
                    void $this$mapTo$iv$iv3;
                    void $this$mapTo$iv$iv4;
                    Object object2;
                    Object object3;
                    Object $this$filter$iv;
                    int $i$f$filter;
                    Object element$iv;
                    Object item$iv$iv;
                    Iterator $this$mapTo$iv$iv5;
                    void $this$map$iv;
                    Collection collection;
                    void $this$mapTo$iv$iv6;
                    void $this$map$iv2;
                    List list5;
                    Iterable $this$filterTo$iv$iv2;
                    void $this$mapTo$iv$iv7;
                    int n2;
                    Collection collection2;
                    Object item$iv$iv22;
                    void $this$mapTo$iv$iv8;
                    Map.Entry element$iv2;
                    Map.Entry vendorEntry = element$iv2 = iterator2.next();
                    boolean bl = false;
                    String vendorId = (String)vendorEntry.getKey();
                    Vendor vendor = (Vendor)vendorEntry.getValue();
                    Iterable $this$map$iv3 = vendor.getLegIntPurposes();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv3;
                    Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv22 : $this$mapTo$iv$iv8) {
                        void id;
                        int n3 = ((Number)item$iv$iv22).intValue();
                        collection2 = destination$iv$iv;
                        n2 = 0;
                        Map<String, Purpose> map2 = gvl.getPurposes();
                        if (map2 == null || (map2 = (Purpose)map2.get(String.valueOf((int)id))) == null || (map2 = ((Purpose)((Object)map2)).getName()) == null) {
                            map2 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map2)));
                    }
                    List vendorLegitimateInterestPurposes = (List)destination$iv$iv;
                    Iterable $this$map$iv4 = vendor.getPurposes();
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv4;
                    Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                    boolean $i$f$mapTo2 = false;
                    item$iv$iv22 = $this$mapTo$iv$iv7.iterator();
                    while (item$iv$iv22.hasNext()) {
                        void id;
                        Object item$iv$iv3 = item$iv$iv22.next();
                        n2 = ((Number)item$iv$iv3).intValue();
                        collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        Map<String, Purpose> map3 = gvl.getPurposes();
                        if (map3 == null || (map3 = (Purpose)map3.get(String.valueOf((int)id))) == null || (map3 = ((Purpose)((Object)map3)).getName()) == null) {
                            map3 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map3)));
                    }
                    List allVendorPurposes = (List)destination$iv$iv2;
                    if (tcf2Settings.getPurposeOneTreatment()) {
                        Iterable $this$filter$iv2 = allVendorPurposes;
                        boolean $i$f$filter2 = false;
                        destination$iv$iv2 = $this$filter$iv2;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            IdAndName purpose = (IdAndName)element$iv$iv;
                            boolean bl3 = false;
                            if (!(purpose.getId() != 1)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        list5 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv3));
                    } else {
                        list5 = allVendorPurposes;
                    }
                    List vendorPurposes = list5;
                    List<TCFVendorRestriction> restrictions = this.getVendorRestrictions(Integer.parseInt(vendorId));
                    Ref.ObjectRef restrictedLegitimateInterestPurposes = new Ref.ObjectRef();
                    $this$filterTo$iv$iv2 = vendorLegitimateInterestPurposes;
                    collection2 = restrictedLegitimateInterestPurposes;
                    boolean $i$f$map222 = false;
                    void $i$f$filterTo = $this$map$iv2;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv4 : $this$mapTo$iv$iv6) {
                        void purpose;
                        IdAndName idAndName = (IdAndName)item$iv$iv4;
                        collection = destination$iv$iv4;
                        boolean bl4 = false;
                        collection.add(new IdAndName(purpose.getId(), purpose.getName()));
                    }
                    ((Ref.ObjectRef)collection2).element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv4));
                    Ref.ObjectRef restrictedPurposes = new Ref.ObjectRef();
                    Iterable $i$f$map222 = vendorPurposes;
                    collection2 = restrictedPurposes;
                    boolean $i$f$map3 = false;
                    destination$iv$iv4 = $this$map$iv;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo4 = false;
                    Iterator item$iv$iv4 = $this$mapTo$iv$iv5.iterator();
                    while (item$iv$iv4.hasNext()) {
                        void purpose2;
                        item$iv$iv = item$iv$iv4.next();
                        IdAndName bl4 = (IdAndName)item$iv$iv;
                        collection = destination$iv$iv5;
                        boolean bl5 = false;
                        collection.add(purpose2);
                    }
                    ((Ref.ObjectRef)collection2).element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv5));
                    Iterable $this$forEach$iv2 = restrictions;
                    boolean $i$f$forEach2 = false;
                    $this$mapTo$iv$iv5 = $this$forEach$iv2.iterator();
                    while ($this$mapTo$iv$iv5.hasNext()) {
                        element$iv = $this$mapTo$iv$iv5.next();
                        TCFVendorRestriction restriction = (TCFVendorRestriction)element$iv;
                        boolean bl6 = false;
                        switch (WhenMappings.$EnumSwitchMapping$0[restriction.getRestrictionType().ordinal()]) {
                            case 1: {
                                IdAndName purpose;
                                Object element$iv$iv;
                                Object $this$filterTo$iv$iv3;
                                item$iv$iv = (Iterable)restrictedPurposes.element;
                                Ref.ObjectRef purpose2 = restrictedPurposes;
                                $i$f$filter = 0;
                                object3 = $this$filter$iv;
                                Collection destination$iv$iv6 = new ArrayList();
                                boolean $i$f$filterTo2 = false;
                                object2 = $this$filterTo$iv$iv3.iterator();
                                while (object2.hasNext()) {
                                    boolean bl7;
                                    element$iv$iv = object2.next();
                                    purpose = (IdAndName)element$iv$iv;
                                    boolean bl8 = false;
                                    if (purpose.getId() == restriction.getPurposeId()) {
                                        if (vendor.getFlexiblePurposes().contains(purpose.getId())) {
                                            ((List)restrictedLegitimateInterestPurposes.element).add(new IdAndName(purpose.getId(), purpose.getName()));
                                        }
                                        bl7 = false;
                                    } else {
                                        bl7 = true;
                                    }
                                    if (!bl7) continue;
                                    destination$iv$iv6.add(element$iv$iv);
                                }
                                purpose2.element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv6));
                                break;
                            }
                            case 2: {
                                IdAndName purpose;
                                Object element$iv$iv;
                                $this$filter$iv = (Iterable)restrictedLegitimateInterestPurposes.element;
                                Ref.ObjectRef purpose2 = restrictedLegitimateInterestPurposes;
                                $i$f$filter = 0;
                                Object $this$filterTo$iv$iv3 = $this$filter$iv;
                                Collection destination$iv$iv6 = new ArrayList();
                                boolean $i$f$filterTo2 = false;
                                object2 = $this$filterTo$iv$iv3.iterator();
                                while (object2.hasNext()) {
                                    boolean bl9;
                                    element$iv$iv = object2.next();
                                    purpose = (IdAndName)element$iv$iv;
                                    boolean bl10 = false;
                                    if (purpose.getId() == restriction.getPurposeId()) {
                                        if (vendor.getFlexiblePurposes().contains(purpose.getId())) {
                                            ((List)restrictedPurposes.element).add(purpose);
                                        }
                                        bl9 = false;
                                    } else {
                                        bl9 = true;
                                    }
                                    if (!bl9) continue;
                                    destination$iv$iv6.add(element$iv$iv);
                                }
                                purpose2.element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv6));
                                break;
                            }
                            case 3: {
                                IdAndName purpose;
                                Object element$iv$iv;
                                $this$filter$iv = vendorPurposes;
                                Ref.ObjectRef purpose2 = restrictedPurposes;
                                $i$f$filter = 0;
                                Object $this$filterTo$iv$iv3 = $this$filter$iv;
                                Collection destination$iv$iv6 = new ArrayList();
                                boolean $i$f$filterTo2 = false;
                                object2 = $this$filterTo$iv$iv3.iterator();
                                while (object2.hasNext()) {
                                    element$iv$iv = object2.next();
                                    purpose = (IdAndName)element$iv$iv;
                                    boolean bl11 = false;
                                    if (!(purpose.getId() != restriction.getPurposeId())) continue;
                                    destination$iv$iv6.add(element$iv$iv);
                                }
                                purpose2.element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv6));
                                $this$filter$iv = vendorLegitimateInterestPurposes;
                                purpose2 = restrictedLegitimateInterestPurposes;
                                $i$f$filter = 0;
                                $this$filterTo$iv$iv3 = $this$filter$iv;
                                destination$iv$iv6 = new ArrayList();
                                $i$f$filterTo2 = false;
                                object2 = $this$filterTo$iv$iv3.iterator();
                                while (object2.hasNext()) {
                                    element$iv$iv = object2.next();
                                    purpose = (IdAndName)element$iv$iv;
                                    boolean bl12 = false;
                                    if (!(purpose.getId() != restriction.getPurposeId())) continue;
                                    destination$iv$iv6.add(element$iv$iv);
                                }
                                purpose2.element = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv6));
                            }
                        }
                    }
                    Iterable $this$map$iv5 = vendor.getFeatures();
                    boolean $i$f$map4 = false;
                    element$iv = $this$map$iv5;
                    Iterable destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
                    boolean $i$f$mapTo5 = false;
                    $this$filter$iv = $this$mapTo$iv$iv4.iterator();
                    while ($this$filter$iv.hasNext()) {
                        void id;
                        Object item$iv$iv5 = $this$filter$iv.next();
                        $i$f$filter = ((Number)item$iv$iv5).intValue();
                        collection2 = destination$iv$iv7;
                        boolean bl13 = false;
                        Map<String, Feature> map4 = gvl.getFeatures();
                        if (map4 == null || (map4 = (Feature)map4.get(String.valueOf((int)id))) == null || (map4 = ((Feature)((Object)map4)).getName()) == null) {
                            map4 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map4)));
                    }
                    List features = (List)destination$iv$iv7;
                    Iterable $this$map$iv6 = vendor.getFlexiblePurposes();
                    boolean $i$f$map5 = false;
                    destination$iv$iv7 = $this$map$iv6;
                    Iterable destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    boolean $i$f$mapTo6 = false;
                    for (Object item$iv$iv6 : $this$mapTo$iv$iv3) {
                        void id;
                        int bl13 = ((Number)item$iv$iv6).intValue();
                        collection2 = destination$iv$iv8;
                        boolean bl14 = false;
                        Map<String, Purpose> map5 = gvl.getPurposes();
                        if (map5 == null || (map5 = (Purpose)map5.get(String.valueOf((int)id))) == null || (map5 = ((Purpose)((Object)map5)).getName()) == null) {
                            map5 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map5)));
                    }
                    List flexiblePurposes = (List)destination$iv$iv8;
                    Iterable $this$filter$iv3 = vendor.getSpecialFeatures();
                    boolean $i$f$filter3 = false;
                    destination$iv$iv8 = $this$filter$iv3;
                    Iterable destination$iv$iv9 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        int specialFeatureId = ((Number)element$iv$iv).intValue();
                        n = 0;
                        if (!(!tcf2Settings.getDisabledSpecialFeatures().contains(specialFeatureId))) continue;
                        destination$iv$iv9.add(element$iv$iv);
                    }
                    List filteredSpecialFeatures = (List)destination$iv$iv9;
                    Iterable $this$map$iv7 = filteredSpecialFeatures;
                    boolean $i$f$map6 = false;
                    destination$iv$iv9 = $this$map$iv7;
                    Iterable destination$iv$iv10 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                    boolean $i$f$mapTo7 = false;
                    for (Object item$iv$iv7 : $this$mapTo$iv$iv2) {
                        void id;
                        n = ((Number)item$iv$iv7).intValue();
                        collection2 = destination$iv$iv10;
                        boolean bl15 = false;
                        Map<String, Feature> map6 = gvl.getSpecialFeatures();
                        if (map6 == null || (map6 = (Feature)map6.get(String.valueOf((int)id))) == null || (map6 = ((Feature)((Object)map6)).getName()) == null) {
                            map6 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map6)));
                    }
                    List specialFeatures = (List)destination$iv$iv10;
                    Iterable $this$map$iv8 = vendor.getSpecialPurposes();
                    boolean $i$f$map7 = false;
                    destination$iv$iv10 = $this$map$iv8;
                    Collection destination$iv$iv11 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv8, (int)10));
                    boolean $i$f$mapTo82 = false;
                    for (Object item$iv$iv8 : $this$mapTo$iv$iv) {
                        void id;
                        int bl15 = ((Number)item$iv$iv8).intValue();
                        collection2 = destination$iv$iv11;
                        boolean bl16 = false;
                        Map<String, Purpose> map7 = gvl.getSpecialPurposes();
                        if (map7 == null || (map7 = (Purpose)map7.get(String.valueOf((int)id))) == null || (map7 = ((Purpose)((Object)map7)).getName()) == null) {
                            map7 = "";
                        }
                        collection2.add(new IdAndName((int)id, (String)((Object)map7)));
                    }
                    List specialPurposes = (List)destination$iv$iv11;
                    List<Integer> list6 = vendor.getDataDeclaration();
                    if (list6 != null) {
                        void $this$mapTo$iv$iv9;
                        Iterable $this$map$iv9 = list6;
                        boolean $i$f$map8 = false;
                        Iterable $i$f$mapTo82 = $this$map$iv9;
                        Collection destination$iv$iv12 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv9, (int)10));
                        boolean $i$f$mapTo9 = false;
                        for (Object item$iv$iv9 : $this$mapTo$iv$iv9) {
                            void id;
                            int purpose = ((Number)item$iv$iv9).intValue();
                            collection2 = destination$iv$iv12;
                            boolean bl17 = false;
                            Map<String, DataCategory> map8 = gvl.getDataCategories();
                            if (map8 == null || (map8 = (DataCategory)map8.get(String.valueOf((int)id))) == null || (map8 = ((DataCategory)((Object)map8)).getName()) == null) {
                                map8 = "";
                            }
                            collection2.add(new IdAndName((int)id, (String)((Object)map8)));
                        }
                        list4 = (List)destination$iv$iv12;
                    } else {
                        list4 = null;
                    }
                    List matchedDataCategories = list4;
                    GvlDataRetention gvlDataRetention = vendor.getDataRetention();
                    boolean bl18 = globalTCModel.getVendorConsents().has(vendor.getId());
                    Double d = vendor.getCookieMaxAgeSeconds();
                    object3 = vendor.getDeviceStorageDisclosureUrl();
                    int n4 = vendor.getId();
                    Boolean bl19 = this.disclosedVendorsMap.get(vendor.getId()) != null ? Boolean.valueOf(globalTCModel.getVendorLegitimateInterests().has(vendor.getId())) : null;
                    object2 = (List)restrictedLegitimateInterestPurposes.element;
                    String string = vendor.getName();
                    String string2 = vendor.getPolicyUrl();
                    List list7 = (List)restrictedPurposes.element;
                    boolean bl20 = !((Collection)restrictedPurposes.element).isEmpty() && tcf2Settings.getUseGranularChoice();
                    boolean bl21 = !((Collection)restrictedLegitimateInterestPurposes.element).isEmpty() && tcf2Settings.getUseGranularChoice() && !tcf2Settings.getHideLegitimateInterestToggles();
                    boolean bl22 = vendor.getUsesNonCookieAccess();
                    boolean bl23 = vendor.getUsesCookies();
                    Boolean bl24 = vendor.getCookieRefresh();
                    boolean bl25 = tcf2Settings.getVendorIdsOutsideEUList().contains(vendor.getId());
                    GvlDataRetention gvlDataRetention2 = gvlDataRetention;
                    GvlDataRetention gvlDataRetention3 = gvlDataRetention;
                    GvlDataRetention gvlDataRetention4 = gvlDataRetention;
                    DataRetention dataRetention = new DataRetention(gvlDataRetention2 != null ? gvlDataRetention2.getStdRetention() : null, RetentionPeriod.Companion.parseFromGvlMap(gvlDataRetention3 != null ? gvlDataRetention3.getPurposes() : null), RetentionPeriod.Companion.parseFromGvlMap(gvlDataRetention4 != null ? gvlDataRetention4.getSpecialPurposes() : null));
                    List list8 = matchedDataCategories;
                    if (list8 == null) {
                        list8 = list3 = CollectionsKt.emptyList();
                    }
                    if ((list2 = vendor.getUrls()) == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List list9 = list2;
                    vendorList.add(new TCFVendor(bl18, features, flexiblePurposes, n4, bl19, (List)object2, string, string2, list7, restrictions, specialFeatures, specialPurposes, bl20, bl21, d, bl22, (String)object3, null, bl23, bl24, (Boolean)bl25, dataRetention, list3, list9, 131072, null));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        List<TCFVendor> $this$setVendors_u24lambda_u2430 = list = this.vendors;
        boolean bl = false;
        $this$setVendors_u24lambda_u2430.clear();
        $this$setVendors_u24lambda_u2430.addAll(ArrayExtensionsKt.sortedAlphaBy$default(vendorList, false, setVendors.2.1.INSTANCE, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TCFStack> getStacks() {
        TCModel tCModel = this.tcModel;
        GVL gvl = tCModel != null ? tCModel.getGvl() : null;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        List<Integer> disabledSpecialFeatures = tCF2Settings.getDisabledSpecialFeatures();
        List stacks2 = new ArrayList();
        if (gvl != null) {
            TCF2Settings tCF2Settings2 = this.getTCF2Settings();
            Intrinsics.checkNotNull((Object)tCF2Settings2);
            Iterable $this$forEach$iv = tCF2Settings2.getSelectedStacks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                int stackId = ((Number)element$iv).intValue();
                boolean bl = false;
                Map<String, Stack> map2 = gvl.getStacks();
                Stack stack = map2 != null ? map2.get(String.valueOf(stackId)) : null;
                if (stack == null) continue;
                Iterable iterable = stack.getSpecialFeatures();
                List<Integer> list2 = stack.getPurposes();
                String string = stack.getName();
                int n = stack.getId();
                String string2 = stack.getDescription();
                List list3 = stacks2;
                boolean $i$f$filter = false;
                void var18_18 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int specialFeatureId = ((Number)element$iv$iv).intValue();
                    boolean bl2 = false;
                    if (!(!disabledSpecialFeatures.contains(specialFeatureId))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list4 = list = (List)destination$iv$iv;
                List<Integer> list5 = list2;
                String string3 = string;
                int n2 = n;
                String string4 = string2;
                list3.add(new TCFStack(string4, n2, string3, list5, list4));
            }
        }
        return stacks2;
    }

    private final List<Integer> getRawSelectedVendorIds() {
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        return tCF2Settings.getSelectedVendorIds();
    }

    /*
     * WARNING - void declaration
     */
    private final List<TCFVendor> getSelectedTCFVendors() {
        void $this$filterTo$iv$iv;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        Set selectedVendorIds = CollectionsKt.toSet((Iterable)tCF2Settings.getSelectedVendorIds());
        Iterable $this$filter$iv = this.getVendors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TCFVendor it = (TCFVendor)element$iv$iv;
            boolean bl = false;
            if (!selectedVendorIds.contains(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void setDisclosedVendors(TCF2Settings tcf2Settings, Map<Integer, StorageVendor> disclosedVendors) {
        Map<Integer, StorageVendor> map2;
        Map<Integer, StorageVendor> $this$setDisclosedVendors_u24lambda_u2434 = map2 = this.disclosedVendorsMap;
        boolean bl = false;
        $this$setDisclosedVendors_u24lambda_u2434.clear();
        $this$setDisclosedVendors_u24lambda_u2434.putAll(disclosedVendors);
        if (!tcf2Settings.isServiceSpecific()) {
            TCModel tCModel = this.tcModel;
            Intrinsics.checkNotNull((Object)tCModel);
            tCModel.getVendorsDisclosed().set(CollectionsKt.toList((Iterable)disclosedVendors.keySet()));
        }
    }

    @Override
    public int getSettingsTCFPolicyVersion() {
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        return Intrinsics.areEqual((Object)tCF2Settings.getVersion(), (Object)"2.2") ? 4 : 2;
    }

    @Override
    public int getStoredTcStringPolicyVersion() {
        TCModel tCModel = this.tcModel;
        Intrinsics.checkNotNull((Object)tCModel);
        return tCModel.getPolicyVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getResurfacePurposeChanged() {
        boolean bl;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        boolean resurfacePurposeChanged = tCF2Settings.getResurfacePurposeChanged();
        if (!resurfacePurposeChanged) return false;
        Iterable $this$all$iv = this.getSelectedTCFVendors();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            StorageVendor disclosedData;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TCFVendor it = (TCFVendor)element$iv;
            boolean bl2 = false;
            if (this.disclosedVendorsMap.get(it.getId()) == null) {
                return true;
            }
            bl = disclosedData.contains(TCFKt.access$toStorageVendor(it));
        } while (bl);
        return true;
    }

    @Override
    public boolean getResurfacePeriodEnded() {
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        if (tCF2Settings.getResurfacePeriodEnded()) {
            this.storageInstance.tcfServiceLastInteractionTimestamp();
        }
        TCF2Settings tCF2Settings2 = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings2);
        return tCF2Settings2.getResurfacePeriodEnded();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getResurfaceVendorAdded() {
        int it;
        void $this$mapTo$iv$iv;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        boolean resurfaceVendorAdded = tCF2Settings.getResurfaceVendorAdded();
        if (!resurfaceVendorAdded) return false;
        Iterable $this$map$iv = this.getSelectedTCFVendors();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            TCFVendor tCFVendor = (TCFVendor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        Iterable $this$all$iv = (List)destination$iv$iv;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return false;
        }
        object = $this$all$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            it = ((Number)element$iv).intValue();
            boolean bl = false;
        } while (this.disclosedVendorsMap.keySet().contains(it));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getPurposeIdsFromVendorsAndStacks() {
        Object stack;
        List purposeIdsFromVendors = new ArrayList();
        List purposeIdsFromStacks = new ArrayList();
        Iterable $this$forEach$iv = this.getVendors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdAndName purpose;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            TCFVendor vendor = (TCFVendor)element$iv;
            boolean bl = false;
            Iterable iterable = vendor.getPurposes();
            Object object = purposeIdsFromVendors;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IdAndName idAndName = (IdAndName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(purpose.getId());
            }
            object.addAll((List)destination$iv$iv);
            $this$map$iv = vendor.getLegitimateInterestPurposes();
            object = purposeIdsFromVendors;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                purpose = (IdAndName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(purpose.getId());
            }
            object.addAll((List)destination$iv$iv);
        }
        $this$forEach$iv = this.getStacks();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            stack = (TCFStack)element$iv;
            boolean bl = false;
            purposeIdsFromStacks.addAll((Collection)((TCFStack)stack).getPurposeIds());
        }
        List purposeIdsFromVendorsAndStack = new ArrayList();
        purposeIdsFromVendorsAndStack.addAll(purposeIdsFromVendors);
        purposeIdsFromVendorsAndStack.addAll(purposeIdsFromStacks);
        List purposes2 = CollectionsKt.distinct((Iterable)purposeIdsFromVendorsAndStack);
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        if (tCF2Settings.getPurposeOneTreatment()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = purposes2;
            boolean $i$f$filter = false;
            stack = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int id = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(id != 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return purposes2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSpecialFeatureIdsFromVendorsAndStacks() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        List list;
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        TCF2Settings tcf2Settings = tCF2Settings;
        List specialFeatureIdsFromVendors = new ArrayList();
        List specialFeatureIdsFromStacks = new ArrayList();
        Iterable $this$forEach$iv = this.getVendors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdAndName specialFeature;
            TCFVendor vendor = (TCFVendor)element$iv;
            boolean bl = false;
            Iterable iterable = vendor.getSpecialFeatures();
            list = specialFeatureIdsFromVendors;
            $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                specialFeature = (IdAndName)element$iv$iv;
                boolean bl2 = false;
                if (!(!tcf2Settings.getDisabledSpecialFeatures().contains(specialFeature.getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                specialFeature = (IdAndName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(element.getId());
            }
            list.addAll((List)destination$iv$iv);
        }
        $this$forEach$iv = this.getStacks();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TCFStack stack = (TCFStack)element$iv;
            boolean bl = false;
            $this$map$iv = stack.getSpecialFeatureIds();
            list = specialFeatureIdsFromStacks;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int specialFeatureId = ((Number)element$iv$iv).intValue();
                boolean bl4 = false;
                if (!(!tcf2Settings.getDisabledSpecialFeatures().contains(specialFeatureId))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        }
        List specialFeatureIdsFromVendorsAndStacks = new ArrayList();
        specialFeatureIdsFromVendorsAndStacks.addAll(specialFeatureIdsFromVendors);
        specialFeatureIdsFromVendorsAndStacks.addAll(specialFeatureIdsFromStacks);
        return CollectionsKt.distinct((Iterable)specialFeatureIdsFromVendorsAndStacks);
    }

    @Override
    public boolean getGdprAppliesOnTCF() {
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        boolean gdprAppliesOnlyEU = tCF2Settings != null ? tCF2Settings.getGdprApplies() : false;
        UsercentricsLocation location = this.locationService.getLocation();
        boolean isUserInEU = location.isInEU();
        return !gdprAppliesOnlyEU || isUserInEU;
    }

    private final void updateIABTCFKeys(String tcString) {
        AssertionsKt.assertNotUIThread();
        TCModel tCModel = this.tcModel;
        if (tCModel == null) {
            return;
        }
        TCModel safeTCModel = tCModel;
        int gdprApplies = this.getGdprAppliesOnTCF() ? 1 : 0;
        TCFKeys keys = new TCFKeysEncoder(safeTCModel, tcString, gdprApplies).encode();
        TCFStoragePayload tcfStoragePayload = keys.saveKeys();
        this.storageInstance.storeStringOrIntValuesDefaultStorage(tcfStoragePayload.getValues());
    }

    @NotNull
    public final String getTCStringFromModel() {
        TCModel tCModel = this.tcModel;
        Intrinsics.checkNotNull((Object)tCModel);
        return TCString.Companion.encode$usercentrics_release(tCModel);
    }

    private final void updatePolicyVersion() {
        TCModel tCModel = this.tcModel;
        Intrinsics.checkNotNull((Object)tCModel);
        if (tCModel.getPolicyVersion() != 4) {
            TCModel tCModel2 = this.tcModel;
            Intrinsics.checkNotNull((Object)tCModel2);
            tCModel2.setPolicyVersion(new StringOrNumber.Int(4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTCString(TCFDecisionUILayer fromLayer) {
        TCModel tCModel = this.tcModel;
        if (tCModel != null) {
            tCModel.setConsentScreen(new StringOrNumber.Int(fromLayer.getValue()));
        }
        TCModel tCModel2 = this.tcModel;
        if (tCModel2 != null) {
            tCModel2.updated();
        }
        this.resetTCFData();
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TCF this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TCF.access$getSemaphore$p(this.this$0).acquire();
                        TCF.access$updatePolicyVersion(this.this$0);
                        String updatedTCString = this.this$0.getTCStringFromModel();
                        TCF.access$updateIABTCFKeys(this.this$0, updatedTCString);
                        Map map2 = TCF.access$getDisclosedVendorsMap$p(this.this$0);
                        TCF.access$getStorageInstance$p(this.this$0).saveTCFData(new StorageTCF(updatedTCString, map2, null, 4, null));
                        TCF.access$setTCFData(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }).onSuccess((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ TCF this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TCF.access$getConsentsService$p(this.this$0).saveConsentsState(UsercentricsConsentAction.TCF_STRING_CHANGE);
                TCF.access$getSemaphore$p(this.this$0).release();
            }
        }).onFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ TCF this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TCF.access$getLogger$p(this.this$0).error("Failed while trying to updateTCString method", it);
                TCF.access$getSemaphore$p(this.this$0).release();
            }
        }));
    }

    @Override
    public void setCmpId(int id) {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, id, null){
            int label;
            final /* synthetic */ TCF this$0;
            final /* synthetic */ int $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TCModel tCModel = TCF.access$getTcModel$p(this.this$0);
                        if (tCModel != null) {
                            tCModel.setCmpId(new StringOrNumber.Int(this.$id));
                        }
                        String updatedTCString = this.this$0.getTCStringFromModel();
                        TCF.access$updateIABTCFKeys(this.this$0, updatedTCString);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }).onFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ TCF this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TCF.access$getLogger$p(this.this$0).error("Failed while trying to setCmpId method", it);
            }
        }));
    }

    @Override
    public void updateChoices(@NotNull TCFUserDecisions decisions, @NotNull TCFDecisionUILayer fromLayer) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)decisions, (String)"decisions");
            Intrinsics.checkNotNullParameter((Object)((Object)fromLayer), (String)"fromLayer");
            Object object2 = this;
            try {
                TCF $this$updateChoices_u24lambda_u2448 = object2;
                boolean bl = false;
                TCF2Settings tCF2Settings = $this$updateChoices_u24lambda_u2448.getTCF2Settings();
                Intrinsics.checkNotNull((Object)tCF2Settings);
                TCF2Settings tcf2Settings = tCF2Settings;
                TCFUserDecisions mergedDecisions = $this$updateChoices_u24lambda_u2448.createTCFUserDecisionsMergingWithCurrentData(decisions);
                if (mergedDecisions.getPurposes() != null) {
                    List<TCFUserDecisionOnPurpose> list = mergedDecisions.getPurposes();
                    Intrinsics.checkNotNull(list);
                    $this$updateChoices_u24lambda_u2448.savePurposes(list);
                }
                if (mergedDecisions.getSpecialFeatures() != null) {
                    List<TCFUserDecisionOnSpecialFeature> list = mergedDecisions.getSpecialFeatures();
                    Intrinsics.checkNotNull(list);
                    $this$updateChoices_u24lambda_u2448.saveSpecialFeatures(list);
                }
                if (mergedDecisions.getVendors() != null) {
                    List<TCFUserDecisionOnVendor> list = mergedDecisions.getVendors();
                    Intrinsics.checkNotNull(list);
                    $this$updateChoices_u24lambda_u2448.saveVendors(list);
                }
                TCF2Settings tCF2Settings2 = $this$updateChoices_u24lambda_u2448.getTCF2Settings();
                Intrinsics.checkNotNull((Object)tCF2Settings2);
                $this$updateChoices_u24lambda_u2448.setDisclosedVendors(tCF2Settings2, TCFKt.access$toStorageVendorMap($this$updateChoices_u24lambda_u2448.getVendors()));
                if (tcf2Settings.getHideLegitimateInterestToggles()) {
                    TCModel tCModel = $this$updateChoices_u24lambda_u2448.tcModel;
                    Intrinsics.checkNotNull((Object)tCModel);
                    tCModel.unsetAllVendorLegitimateInterests();
                    TCModel tCModel2 = $this$updateChoices_u24lambda_u2448.tcModel;
                    Intrinsics.checkNotNull((Object)tCModel2);
                    tCModel2.unsetAllPurposeLegitimateInterests();
                }
                if (mergedDecisions.getPurposes() != null || mergedDecisions.getSpecialFeatures() != null || mergedDecisions.getVendors() != null) {
                    $this$updateChoices_u24lambda_u2448.updateTCString(fromLayer);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block7;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Something went wrong with TCF updateChoices method: " + it, (Throwable)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TCFUserDecisions createTCFUserDecisionsMergingWithCurrentData(TCFUserDecisions decisions) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv4;
        List list;
        List decisionsPurposes;
        List list2 = decisions.getPurposes();
        if (list2 == null) {
            list2 = decisionsPurposes = CollectionsKt.emptyList();
        }
        if ((list = decisions.getVendors()) == null) {
            list = CollectionsKt.emptyList();
        }
        List decisionsVendors = list;
        Iterable $this$map$iv = this.purposes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
            void it;
            TCFPurpose tCFPurpose = (TCFPurpose)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IdAndConsent(it.getId(), it.getConsent(), it.getLegitimateInterestConsent()));
        }
        List purposesData = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.vendors;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
            void it;
            TCFVendor bl = (TCFVendor)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new IdAndConsent(it.getId(), it.getConsent(), it.getLegitimateInterestConsent()));
        }
        List vendorsData = (List)destination$iv$iv2;
        List<TCFConsentDecision> mergedPurposes = this.mergeConsentsWithUserDecisions(purposesData, decisionsPurposes);
        List<TCFConsentDecision> mergedVendors = this.mergeConsentsWithUserDecisions(vendorsData, decisionsVendors);
        Iterable $this$map$iv3 = mergedPurposes;
        boolean $i$f$map3 = false;
        item$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
            void it;
            TCFConsentDecision tCFConsentDecision = (TCFConsentDecision)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(new TCFUserDecisionOnPurpose(it.getId(), it.getConsent(), it.getLegitimateInterestConsent()));
        }
        List list3 = (List)destination$iv$iv3;
        Iterable $this$map$iv4 = mergedVendors;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv5 : $this$mapTo$iv$iv) {
            void it;
            TCFConsentDecision bl = (TCFConsentDecision)item$iv$iv5;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(new TCFUserDecisionOnVendor(it.getId(), it.getConsent(), it.getLegitimateInterestConsent()));
        }
        List list4 = (List)destination$iv$iv4;
        List<TCFUserDecisionOnSpecialFeature> list5 = decisions.getSpecialFeatures();
        return new TCFUserDecisions(list3, list5, list4);
    }

    private final List<TCFConsentDecision> mergeConsentsWithUserDecisions(List<IdAndConsent> data, List<? extends TCFConsentWithLegitimateInterestDecision> decisions) {
        List mergedPurposes = new ArrayList();
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean legitimateInterestConsent;
            Object v0;
            IdAndConsent consentModel;
            block3: {
                consentModel = (IdAndConsent)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = decisions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    TCFConsentWithLegitimateInterestDecision it = (TCFConsentWithLegitimateInterestDecision)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getId() == consentModel.getId())) continue;
                    v0 = element$iv2;
                    break block3;
                }
                v0 = null;
            }
            TCFConsentWithLegitimateInterestDecision userDecision = v0;
            Boolean bl = consentModel.getConsent();
            boolean consent = bl != null ? bl : false;
            Boolean bl3 = consentModel.getLegitimateInterestConsent();
            boolean bl4 = legitimateInterestConsent = bl3 != null ? bl3 : true;
            if (userDecision != null) {
                Boolean bl5 = userDecision.getConsent();
                consent = bl5 != null ? bl5 : consent;
                Boolean bl6 = userDecision.getLegitimateInterestConsent();
                legitimateInterestConsent = bl6 != null ? bl6 : legitimateInterestConsent;
            }
            int n = consentModel.getId();
            boolean bl7 = consent;
            boolean bl8 = legitimateInterestConsent;
            mergedPurposes.add(new TCFConsentDecision(bl7, n, bl8));
        }
        return mergedPurposes;
    }

    private final List<TCFFeature> getFeaturesFromVendors() {
        List<Integer> featureIds = this.getFeatureIdsFromVendors();
        List featuresFromVendorsList = new ArrayList();
        Iterable $this$forEach$iv = featureIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int featureId = ((Number)element$iv).intValue();
            boolean bl = false;
            Object object = this.tcModel;
            Feature feature = object != null && (object = ((TCModel)object).getGvl()) != null && (object = ((GVL)object).getFeatures()) != null ? object.get(String.valueOf(featureId)) : null;
            if (feature == null) continue;
            featuresFromVendorsList.add(new TCFFeature(feature.getDescription(), feature.getIllustrations(), feature.getId(), feature.getName()));
        }
        return CollectionsKt.toList((Iterable)featuresFromVendorsList);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getFeatureIdsFromVendors() {
        List featureIdsFromVendorsList = new ArrayList();
        Iterable $this$forEach$iv = this.getVendors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TCFVendor vendor = (TCFVendor)element$iv;
            boolean bl = false;
            Iterable iterable = vendor.getFeatures();
            List list = featureIdsFromVendorsList;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void feature;
                IdAndName idAndName = (IdAndName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(feature.getId());
            }
            list.addAll((List)destination$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)featureIdsFromVendorsList);
    }

    private final List<TCFPurpose> getPurposesFromVendors() {
        if (this.purposes.isEmpty()) {
            this.setPurposes();
        }
        return CollectionsKt.toList((Iterable)this.purposes);
    }

    /*
     * WARNING - void declaration
     */
    private final void setPurposes() {
        Iterable $this$forEach$iv;
        IdAndName legitPurpose;
        List<String> list;
        Object object;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        List<String> destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        TCFVendor vendor;
        Collection collection;
        Object object2;
        Object item$iv$iv;
        Iterator $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        List<Integer> purposeIds = this.getPurposeIdsFromVendorsAndStacks();
        List<TCFStack> stacks2 = this.getStacks();
        List<TCFVendor> vendors = this.getVendors();
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        TCF2Settings tcf2Settings = tCF2Settings;
        List vendorsPurposes = null;
        vendorsPurposes = new ArrayList();
        List vendorsLegitimateInterestPurposes = null;
        vendorsLegitimateInterestPurposes = new ArrayList();
        List purposesFromVendors = new ArrayList();
        List<TCFPurpose> list2 = (List<TCFPurpose>)vendors;
        boolean $i$f$map2 = false;
        void var10_11 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            object2 = (TCFVendor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            $this$map$iv = vendor.getLegitimateInterestPurposes();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                object = (IdAndName)item$iv$iv2;
                list = destination$iv$iv;
                boolean bl2 = false;
                list.add((String)((Object)Integer.valueOf(legitPurpose.getId())));
            }
            collection.add((List)destination$iv$iv);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list3 = (List)element$iv;
            boolean bl = false;
            vendorsLegitimateInterestPurposes.addAll(list3);
        }
        vendorsLegitimateInterestPurposes = CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)vendorsLegitimateInterestPurposes));
        $this$forEach$iv = vendors;
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        Iterator bl = $this$mapTo$iv$iv2.iterator();
        while (bl.hasNext()) {
            item$iv$iv = bl.next();
            vendor = (TCFVendor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            $this$map$iv = vendor.getPurposes();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void purpose;
                legitPurpose = (IdAndName)item$iv$iv2;
                list = destination$iv$iv;
                boolean bl4 = false;
                list.add((String)((Object)Integer.valueOf(purpose.getId())));
            }
            collection.add((List)destination$iv$iv);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list4 = (List)element$iv;
            boolean bl5 = false;
            vendorsPurposes.addAll(list4);
        }
        vendorsPurposes = CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)vendorsPurposes));
        $this$forEach$iv = purposeIds;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object3;
            Object v2;
            Purpose purpose;
            int purposeId;
            block8: {
                purposeId = ((Number)element$iv).intValue();
                boolean bl6 = false;
                Object object4 = this.tcModel;
                purpose = object4 != null && (object4 = ((TCModel)object4).getGvl()) != null && (object4 = ((GVL)object4).getPurposes()) != null ? object4.get(String.valueOf(purposeId)) : null;
                object2 = stacks2;
                Iterator iterator3 = object2.iterator();
                while (iterator3.hasNext()) {
                    Object t = iterator3.next();
                    TCFStack stack = (TCFStack)t;
                    boolean bl7 = false;
                    if (!stack.getPurposeIds().contains(purposeId)) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            TCFStack stackIncludingPurpose = v2;
            if (purpose == null) continue;
            Object object5 = this.tcModel;
            Boolean bl8 = object5 != null && (object5 = ((TCModel)object5).getPurposeConsents()) != null ? Boolean.valueOf(((Vector)object5).has(purposeId)) : null;
            object2 = purpose.getDescription();
            int n = purpose.getId();
            boolean bl9 = stackIncludingPurpose != null;
            Boolean bl10 = !this.disclosedVendorsMap.isEmpty() ? ((object3 = this.tcModel) != null && (object3 = ((TCModel)object3).getPurposeLegitimateInterests()) != null ? Boolean.valueOf(((Vector)object3).has(purposeId)) : null) : null;
            String string = purpose.getName();
            boolean bl11 = vendorsPurposes.contains(purposeId) && tcf2Settings.getUseGranularChoice();
            boolean bl12 = purpose.getId() != 1 && vendorsLegitimateInterestPurposes.contains(purposeId) && tcf2Settings.getUseGranularChoice() && !tcf2Settings.getHideLegitimateInterestToggles();
            TCFStack tCFStack = stackIncludingPurpose;
            object = tCFStack != null ? Integer.valueOf(tCFStack.getId()) : null;
            list = purpose.getIllustrations();
            purposesFromVendors.add(new TCFPurpose((String)object2, list, n, string, bl8, bl9, bl10, bl11, bl12, (Integer)object));
        }
        List<TCFPurpose> $this$setPurposes_u24lambda_u2467 = list2 = this.purposes;
        boolean bl13 = false;
        $this$setPurposes_u24lambda_u2467.clear();
        $this$setPurposes_u24lambda_u2467.addAll(ArrayExtensionsKt.sortedAlphaBy$default(CollectionsKt.toList((Iterable)purposesFromVendors), false, setPurposes.6.1.INSTANCE, 1, null));
    }

    private final List<TCFSpecialFeature> getSpecialFeaturesFromVendorsAndStacks() {
        List<Integer> specialFeatureIds = this.getSpecialFeatureIdsFromVendorsAndStacks();
        List<TCFStack> stacks2 = this.getStacks();
        TCF2Settings tCF2Settings = this.getTCF2Settings();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        TCF2Settings tcf2Settings = tCF2Settings;
        List specialFeaturesFromVendorsAndStacks = new ArrayList();
        Iterable $this$forEach$iv = specialFeatureIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v2;
            Object object;
            Object object2;
            Feature specialFeature;
            int specialFeatureId;
            block2: {
                specialFeatureId = ((Number)element$iv).intValue();
                boolean bl = false;
                Object object3 = this.tcModel;
                specialFeature = object3 != null && (object3 = ((TCModel)object3).getGvl()) != null && (object3 = ((GVL)object3).getSpecialFeatures()) != null ? object3.get(String.valueOf(specialFeatureId)) : null;
                object2 = stacks2;
                object = object2.iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    TCFStack stack = (TCFStack)t;
                    boolean bl2 = false;
                    if (!stack.getSpecialFeatureIds().contains(specialFeatureId)) continue;
                    v2 = t;
                    break block2;
                }
                v2 = null;
            }
            TCFStack stackIncludingSpecialFeature = v2;
            if (specialFeature == null) continue;
            Object object4 = this.tcModel;
            Boolean bl = object4 != null && (object4 = ((TCModel)object4).getSpecialFeatureOptins()) != null ? Boolean.valueOf(((Vector)object4).has(specialFeatureId)) : null;
            object2 = specialFeature.getDescription();
            object = specialFeature.getIllustrations();
            int n = specialFeature.getId();
            boolean bl3 = stackIncludingSpecialFeature != null;
            String string = specialFeature.getName();
            boolean bl4 = tcf2Settings.getUseGranularChoice();
            TCFStack tCFStack = stackIncludingSpecialFeature;
            Integer n2 = tCFStack != null ? Integer.valueOf(tCFStack.getId()) : null;
            specialFeaturesFromVendorsAndStacks.add(new TCFSpecialFeature((String)object2, (List<String>)object, n, string, bl, bl3, n2, bl4));
        }
        return CollectionsKt.toList((Iterable)specialFeaturesFromVendorsAndStacks);
    }

    private final List<TCFSpecialPurpose> getSpecialPurposesFromVendors() {
        List<Integer> specialPurposeIds = this.getSpecialPurposeIdsFromVendors();
        List specialPurposesFromVendors = new ArrayList();
        Iterable $this$forEach$iv = specialPurposeIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int specialPurposeId = ((Number)element$iv).intValue();
            boolean bl = false;
            Object object = this.tcModel;
            Purpose specialPurpose = object != null && (object = ((TCModel)object).getGvl()) != null && (object = ((GVL)object).getSpecialPurposes()) != null ? object.get(String.valueOf(specialPurposeId)) : null;
            if (specialPurpose == null) continue;
            specialPurposesFromVendors.add(new TCFSpecialPurpose(specialPurpose.getDescription(), specialPurpose.getIllustrations(), specialPurpose.getId(), specialPurpose.getName()));
        }
        return CollectionsKt.toList((Iterable)specialPurposesFromVendors);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSpecialPurposeIdsFromVendors() {
        List specialPurposeIdsFromVendors = new ArrayList();
        Iterable $this$forEach$iv = this.getVendors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TCFVendor vendor = (TCFVendor)element$iv;
            boolean bl = false;
            Iterable iterable = vendor.getSpecialPurposes();
            List list = specialPurposeIdsFromVendors;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                IdAndName idAndName = (IdAndName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(element.getId());
            }
            list.addAll((List)destination$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)specialPurposeIdsFromVendors);
    }

    private final void savePurposes(List<TCFUserDecisionOnPurpose> decisions) {
        Iterable $this$forEach$iv = decisions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TCFUserDecisionOnPurpose purpose = (TCFUserDecisionOnPurpose)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)purpose.getConsent(), (Object)true)) {
                Object object = this.tcModel;
                if (object != null && (object = ((TCModel)object).getPurposeConsents()) != null) {
                    ((Vector)object).set(purpose.getId());
                }
            } else {
                Object object = this.tcModel;
                if (object != null && (object = ((TCModel)object).getPurposeConsents()) != null) {
                    ((Vector)object).unset(purpose.getId());
                }
            }
            if (Intrinsics.areEqual((Object)purpose.getLegitimateInterestConsent(), (Object)true)) {
                Object object = this.tcModel;
                if (object != null && (object = ((TCModel)object).getPurposeLegitimateInterests()) != null) {
                    ((Vector)object).set(purpose.getId());
                }
                continue;
            }
            Object object = this.tcModel;
            if (object == null || (object = ((TCModel)object).getPurposeLegitimateInterests()) == null) continue;
            ((Vector)object).unset(purpose.getId());
        }
    }

    private final void saveSpecialFeatures(List<TCFUserDecisionOnSpecialFeature> decisions) {
        Iterable $this$forEach$iv = decisions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TCFUserDecisionOnSpecialFeature specialFeature = (TCFUserDecisionOnSpecialFeature)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)specialFeature.getConsent(), (Object)true)) {
                Object object = this.tcModel;
                if (object != null && (object = ((TCModel)object).getSpecialFeatureOptins()) != null) {
                    ((Vector)object).set(specialFeature.getId());
                }
                continue;
            }
            Object object = this.tcModel;
            if (object == null || (object = ((TCModel)object).getSpecialFeatureOptins()) == null) continue;
            ((Vector)object).unset(specialFeature.getId());
        }
    }

    private final void saveVendors(List<TCFUserDecisionOnVendor> decisions) {
        TCModel tCModel = this.tcModel;
        Intrinsics.checkNotNull((Object)tCModel);
        TCModel internalTCModel = tCModel;
        List tempSetVendorConsents = new ArrayList();
        List tempUnsetVendorConsents = new ArrayList();
        List tempSetLegitimateInterest = new ArrayList();
        List tempUnsetLegitimateInterest = new ArrayList();
        Iterable $this$forEach$iv = decisions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TCFUserDecisionOnVendor vendor = (TCFUserDecisionOnVendor)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)vendor.getConsent(), (Object)true)) {
                tempSetVendorConsents.add(vendor.getId());
            } else {
                tempUnsetVendorConsents.add(vendor.getId());
            }
            if (Intrinsics.areEqual((Object)vendor.getLegitimateInterestConsent(), (Object)true)) {
                tempSetLegitimateInterest.add(vendor.getId());
                continue;
            }
            tempUnsetLegitimateInterest.add(vendor.getId());
        }
        internalTCModel.getVendorConsents().set(tempSetVendorConsents);
        internalTCModel.getVendorConsents().unset(tempUnsetVendorConsents);
        internalTCModel.getVendorLegitimateInterests().set(tempSetLegitimateInterest);
        internalTCModel.getVendorLegitimateInterests().unset(tempUnsetLegitimateInterest);
    }

    private final void resetGVLWithLanguage(String language, Function0<Unit> onSuccess, Function1<? super UsercentricsException, Unit> onError2) {
        try {
            TCModel tCModel = this.tcModel;
            GVL gVL = tCModel != null ? tCModel.getGvl() : null;
            Intrinsics.checkNotNull((Object)gVL);
            GVL gvl = gVL;
            gvl.changeLanguage(language, onSuccess, (Function1<? super GVLError, Unit>)((Function1)new Function1<GVLError, Unit>(onError2){
                final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
                {
                    this.$onError = $onError;
                    super(1);
                }

                public final void invoke(@NotNull GVLError it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$onError.invoke((Object)new UsercentricsException(TCF_WARN_MESSAGES.RESET_GVL_FAILURE.getMessage() + ": " + it.getMessage(), it));
                }
            }));
        }
        catch (Throwable error) {
            onError2.invoke((Object)new UsercentricsException(TCF_WARN_MESSAGES.RESET_GVL_FAILURE.getMessage() + ": " + error.getMessage(), error));
        }
    }

    public static final /* synthetic */ TCModel access$getTcModel$p(TCF $this) {
        return $this.tcModel;
    }

    public static final /* synthetic */ List access$getRawSelectedVendorIds(TCF $this) {
        return $this.getRawSelectedVendorIds();
    }

    public static final /* synthetic */ void access$resetTCFData(TCF $this) {
        $this.resetTCFData();
    }

    public static final /* synthetic */ UsercentricsSettings access$getSettings(TCF $this) {
        return $this.getSettings();
    }

    public static final /* synthetic */ void access$resetGVLWithLanguage(TCF $this, String language, Function0 onSuccess, Function1 onError2) {
        $this.resetGVLWithLanguage(language, (Function0<Unit>)onSuccess, (Function1<? super UsercentricsException, Unit>)onError2);
    }

    public static final /* synthetic */ void access$initDisclosedVendors(TCF $this, TCF2Settings tcf2Settings, List allVendors) {
        $this.initDisclosedVendors(tcf2Settings, allVendors);
    }

    public static final /* synthetic */ List access$getVendors(TCF $this) {
        return $this.getVendors();
    }

    public static final /* synthetic */ void access$initTCModelApplyVendorPurposeRestrictions(TCF $this, List purposes2, TCF_VENDOR_PURPOSE_TYPE targetPurposeType) {
        $this.initTCModelApplyVendorPurposeRestrictions(purposes2, targetPurposeType);
    }

    public static final /* synthetic */ Semaphore access$getSemaphore$p(TCF $this) {
        return $this.semaphore;
    }

    public static final /* synthetic */ void access$updatePolicyVersion(TCF $this) {
        $this.updatePolicyVersion();
    }

    public static final /* synthetic */ void access$updateIABTCFKeys(TCF $this, String tcString) {
        $this.updateIABTCFKeys(tcString);
    }

    public static final /* synthetic */ DeviceStorage access$getStorageInstance$p(TCF $this) {
        return $this.storageInstance;
    }

    public static final /* synthetic */ Map access$getDisclosedVendorsMap$p(TCF $this) {
        return $this.disclosedVendorsMap;
    }

    public static final /* synthetic */ void access$setTCFData(TCF $this) {
        $this.setTCFData();
    }

    public static final /* synthetic */ ConsentsService access$getConsentsService$p(TCF $this) {
        return $this.consentsService;
    }

    public static final /* synthetic */ UsercentricsLogger access$getLogger$p(TCF $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/usercentrics/sdk/services/tcf/TCF$Companion;", "", "()V", "resolveLanguage", "", "language", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLanguage(@NotNull String language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            ConsentLanguages consentLanguages = GVL.Companion.getConsentLanguages();
            String string = language.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            if (consentLanguages.has(string)) {
                return language;
            }
            return "en";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestrictionType.values().length];
            try {
                nArray[RestrictionType.REQUIRE_LI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictionType.REQUIRE_CONSENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestrictionType.NOT_ALLOWED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

