/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui;

import com.usercentrics.sdk.ActualKt;
import com.usercentrics.sdk.core.ClassLocator;
import com.usercentrics.sdk.extensions.ArrayExtensionsKt;
import com.usercentrics.sdk.models.settings.PredefinedUIVariant;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage;
import com.usercentrics.sdk.services.deviceStorage.StorageKeys;
import com.usercentrics.sdk.ui.PredefinedUIMediator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/usercentrics/sdk/ui/PredefinedUIMediatorImpl;", "Lcom/usercentrics/sdk/ui/PredefinedUIMediator;", "classLocator", "Lcom/usercentrics/sdk/core/ClassLocator;", "keyValueStorage", "Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;", "(Lcom/usercentrics/sdk/core/ClassLocator;Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;)V", "isModulePresent", "", "popStoredVariant", "Lcom/usercentrics/sdk/models/settings/PredefinedUIVariant;", "storeVariant", "", "variant", "usercentrics_release"})
public final class PredefinedUIMediatorImpl
implements PredefinedUIMediator {
    @NotNull
    private final ClassLocator classLocator;
    @NotNull
    private final KeyValueStorage keyValueStorage;

    public PredefinedUIMediatorImpl(@NotNull ClassLocator classLocator2, @NotNull KeyValueStorage keyValueStorage) {
        Intrinsics.checkNotNullParameter((Object)classLocator2, (String)"classLocator");
        Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
        this.classLocator = classLocator2;
        this.keyValueStorage = keyValueStorage;
    }

    @Override
    public boolean isModulePresent() {
        return this.classLocator.locate(ActualKt.getPredefinedUIFlagClassName()) || this.classLocator.locate(ActualKt.getPredefinedUITVFlagClassName());
    }

    @Override
    public void storeVariant(@NotNull PredefinedUIVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        this.keyValueStorage.put(StorageKeys.UI_VARIANT.getText(), variant.name());
    }

    @Override
    @Nullable
    public PredefinedUIVariant popStoredVariant() {
        String string = this.keyValueStorage.getString(StorageKeys.UI_VARIANT.getText(), null);
        if (string == null || (string = ArrayExtensionsKt.emptyToNull(string)) == null) {
            return null;
        }
        String variant = string;
        this.keyValueStorage.deleteKey(StorageKeys.UI_VARIANT.getText());
        return PredefinedUIVariant.valueOf(variant);
    }
}

