/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.gdpr;

import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerDetailsEntry;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceLabels;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0010\u001c\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0019\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRDetailsMapperTV;", "", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "labels", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceLabels;", "(Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceLabels;)V", "getCookiePolicy", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerDetailsEntry;", "service", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "getDataCollected", "getDataProcessingAgreement", "getDataPurposes", "getDataRecipients", "getLegalBasis", "getOptOutLink", "getPrivacyPolicy", "getProcessingCompany", "getProcessingLocation", "getRetentionPeriod", "getServiceDescription", "getTechnologiesUsed", "getThirdPartyCountriesDistribution", "map", "", "filterNotBlank", "T", "", "", "usercentrics_release"})
public final class GDPRDetailsMapperTV {
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final PredefinedUIServiceLabels labels;

    public GDPRDetailsMapperTV(@NotNull UsercentricsSettings settings, @NotNull PredefinedUIServiceLabels labels) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.settings = settings;
        this.labels = labels;
    }

    @NotNull
    public final List<PredefinedTVSecondLayerDetailsEntry> map(@NotNull LegacyService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Object[] objectArray = new PredefinedTVSecondLayerDetailsEntry[]{this.getServiceDescription(service), this.getProcessingCompany(service), this.getDataPurposes(service), this.getTechnologiesUsed(service), this.getDataCollected(service), this.getLegalBasis(service), this.getProcessingLocation(service), this.getRetentionPeriod(service), this.getThirdPartyCountriesDistribution(service), this.getDataRecipients(service), this.getPrivacyPolicy(service), this.getCookiePolicy(service), this.getOptOutLink(service), this.getDataProcessingAgreement(service)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final PredefinedTVSecondLayerDetailsEntry getServiceDescription(LegacyService service) {
        return !StringsKt.isBlank((CharSequence)service.getServiceDescription()) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDescriptionTitle(), service.getServiceDescription()) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getProcessingCompany(LegacyService service) {
        String address;
        StringBuilder processingCompanyBld = new StringBuilder();
        String name = service.getProcessingCompany().getName();
        if (!StringsKt.isBlank((CharSequence)name)) {
            processingCompanyBld.append(name);
        }
        if (!StringsKt.isBlank((CharSequence)(address = service.getProcessingCompany().getAddress()))) {
            if (((CharSequence)processingCompanyBld).length() > 0) {
                processingCompanyBld.append("\n");
            }
            processingCompanyBld.append(address);
        }
        String string = processingCompanyBld.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingCompanyBld.toString()");
        String processingCompany = string;
        return !StringsKt.isBlank((CharSequence)processingCompany) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getProcessingCompanyTitle(), processingCompany) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataPurposes(LegacyService service) {
        List dataPurposes = this.filterNotBlank((Iterable)service.getDataPurposes());
        return !((Collection)dataPurposes).isEmpty() ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDataPurposes().getTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release(dataPurposes, this.labels.getDataPurposes().getTitleDescription())) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getTechnologiesUsed(LegacyService service) {
        List technologiesUsed = this.filterNotBlank((Iterable)service.getTechnologiesUsed());
        return !((Collection)technologiesUsed).isEmpty() ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getTechnologiesUsed().getTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release(technologiesUsed, this.labels.getTechnologiesUsed().getTitleDescription())) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataCollected(LegacyService service) {
        List dataCollected = this.filterNotBlank((Iterable)service.getDataCollected());
        return !((Collection)dataCollected).isEmpty() ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDataCollected().getTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release(dataCollected, this.labels.getDataCollected().getTitleDescription())) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getLegalBasis(LegacyService service) {
        List legalBasisList = this.filterNotBlank((Iterable)service.getLegalBasis());
        return !((Collection)legalBasisList).isEmpty() ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getLegalBasis().getTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release(legalBasisList, this.labels.getLegalBasis().getTitleDescription())) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getProcessingLocation(LegacyService service) {
        String processingLocation = service.getDataDistribution().getProcessingLocation();
        return !StringsKt.isBlank((CharSequence)processingLocation) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDataDistribution().getProcessingLocationTitle(), processingLocation) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getRetentionPeriod(LegacyService service) {
        return !StringsKt.isBlank((CharSequence)service.getRetentionPeriodDescription()) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getRetentionPeriodTitle(), service.getRetentionPeriodDescription()) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getThirdPartyCountriesDistribution(LegacyService service) {
        String thirdPartyCountries = service.getDataDistribution().getThirdPartyCountries();
        return !StringsKt.isBlank((CharSequence)thirdPartyCountries) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDataDistribution().getThirdPartyCountriesTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release(CollectionsKt.listOf((Object)thirdPartyCountries), this.labels.getDataDistribution().getThirdPartyCountriesDescription())) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataRecipients(LegacyService service) {
        List dataRecipients = this.filterNotBlank((Iterable)service.getDataRecipients());
        return !((Collection)dataRecipients).isEmpty() ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.labels.getDataRecipientsTitle(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContent$usercentrics_release$default(PredefinedTVSecondLayerDetailsEntry.Companion, dataRecipients, null, 2, null)) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getPrivacyPolicy(LegacyService service) {
        String privacyPolicy = service.getUrls().getPrivacyPolicy();
        return !StringsKt.isBlank((CharSequence)privacyPolicy) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.Link(this.settings.getLabels().getPrivacyPolicyLinkText(), this.labels.getUrls().getPrivacyPolicyTitle(), privacyPolicy) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getCookiePolicy(LegacyService service) {
        String cookiePolicy = service.getUrls().getCookiePolicy();
        return !StringsKt.isBlank((CharSequence)cookiePolicy) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.Link(this.settings.getLabels().getCookiePolicyLinkText(), this.labels.getUrls().getCookiePolicyTitle(), cookiePolicy) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getOptOutLink(LegacyService service) {
        String optOut = service.getUrls().getOptOut();
        return !StringsKt.isBlank((CharSequence)optOut) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.Link(this.settings.getLabels().getFurtherInformationOptOut(), this.labels.getUrls().getOptOutTitle(), optOut) : null;
    }

    private final PredefinedTVSecondLayerDetailsEntry getDataProcessingAgreement(LegacyService service) {
        String dataProcessingAgreement = service.getUrls().getDataProcessingAgreement();
        return !StringsKt.isBlank((CharSequence)dataProcessingAgreement) ? (PredefinedTVSecondLayerDetailsEntry)new PredefinedTVSecondLayerDetailsEntry.Link(this.settings.getLabels().getLinkToDpaInfo(), dataProcessingAgreement, dataProcessingAgreement) : null;
    }

    private final <T extends CharSequence> List<T> filterNotBlank(Iterable<? extends T> $this$filterNotBlank) {
        ArrayList<CharSequence> destination = new ArrayList<CharSequence>();
        for (CharSequence element : $this$filterNotBlank) {
            if (!(!StringsKt.isBlank((CharSequence)element))) continue;
            destination.add(element);
        }
        return destination;
    }
}

