/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.gdpr;

import com.usercentrics.sdk.CategoryProps;
import com.usercentrics.sdk.UsercentricsAnalyticsEventType;
import com.usercentrics.sdk.UsercentricsMaps;
import com.usercentrics.sdk.extensions.ArrayExtensionsKt;
import com.usercentrics.sdk.models.settings.LegacyPoweredBy;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerSettings;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerSettingsContent;
import com.usercentrics.sdk.models.settings.PredefinedUIButtonType;
import com.usercentrics.sdk.models.settings.PredefinedUICardContent;
import com.usercentrics.sdk.models.settings.PredefinedUICardUI;
import com.usercentrics.sdk.models.settings.PredefinedUICardUISection;
import com.usercentrics.sdk.models.settings.PredefinedUICategoriesContent;
import com.usercentrics.sdk.models.settings.PredefinedUIControllerIDSettings;
import com.usercentrics.sdk.models.settings.PredefinedUICustomization;
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorButton;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterButton;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterEntry;
import com.usercentrics.sdk.models.settings.PredefinedUIFooterSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIHeaderSettings;
import com.usercentrics.sdk.models.settings.PredefinedUILanguage;
import com.usercentrics.sdk.models.settings.PredefinedUILanguageSettings;
import com.usercentrics.sdk.models.settings.PredefinedUILink;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceDetails;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceLabels;
import com.usercentrics.sdk.models.settings.PredefinedUIServicesCardContent;
import com.usercentrics.sdk.models.settings.PredefinedUIServicesContent;
import com.usercentrics.sdk.models.settings.PredefinedUISingleServiceCardContent;
import com.usercentrics.sdk.models.settings.PredefinedUISwitchSettingsUI;
import com.usercentrics.sdk.models.settings.PredefinedUITabSettings;
import com.usercentrics.sdk.models.settings.PredefinedUIToggleLocalizations;
import com.usercentrics.sdk.models.settings.UCUISecondLayerSettings;
import com.usercentrics.sdk.v2.banner.service.mapper.FooterButtonLayoutMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.GenericSecondLayerMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.PoweredByMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.gdpr.GDPRSectionMapperTV;
import com.usercentrics.sdk.v2.settings.data.FirstLayerLogoPosition;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCustomization;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u0001:\u00010BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0015\u001a\u00020\tH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000bH\u0002J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRSecondLayerMapper;", "Lcom/usercentrics/sdk/v2/banner/service/mapper/GenericSecondLayerMapper;", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "translations", "Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;", "customization", "Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;", "controllerId", "", "categories", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsCategory;", "services", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "serviceLabels", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceLabels;", "(Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceLabels;)V", "hideDataProcessingServices", "", "hideTogglesForServices", "acceptAllText", "content", "Lcom/usercentrics/sdk/models/settings/PredefinedUITabSettings;", "contentCategorySection", "Lcom/usercentrics/sdk/models/settings/PredefinedUICardUISection;", "contentServiceSection", "denyAllText", "footer", "Lcom/usercentrics/sdk/models/settings/PredefinedUIFooterSettings;", "getControllerID", "Lcom/usercentrics/sdk/models/settings/PredefinedUIControllerIDSettings;", "getPredefinedUICardUI", "Lcom/usercentrics/sdk/models/settings/PredefinedUICardUI;", "entry", "Lcom/usercentrics/sdk/CategoryProps;", "header", "Lcom/usercentrics/sdk/models/settings/PredefinedUIHeaderSettings;", "headerLanguageSettings", "Lcom/usercentrics/sdk/models/settings/PredefinedUILanguageSettings;", "headerLinks", "Lcom/usercentrics/sdk/models/settings/PredefinedUILink;", "map", "Lcom/usercentrics/sdk/models/settings/UCUISecondLayerSettings;", "mapTV", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerSettings;", "poweredBy", "Lcom/usercentrics/sdk/models/settings/PredefinedUIFooterEntry;", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nGDPRSecondLayerMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GDPRSecondLayerMapper.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRSecondLayerMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1549#2:266\n1620#2,3:267\n1045#2:270\n766#2:271\n857#2,2:272\n1549#2:274\n1620#2,3:275\n1549#2:278\n1620#2,3:279\n766#2:282\n857#2,2:283\n1549#2:285\n1620#2,3:286\n*S KotlinDebug\n*F\n+ 1 GDPRSecondLayerMapper.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRSecondLayerMapper\n*L\n82#1:266\n82#1:267,3\n83#1:270\n107#1:271\n107#1:272,2\n193#1:274\n193#1:275,3\n213#1:278\n213#1:279,3\n232#1:282\n232#1:283,2\n235#1:285\n235#1:286,3\n*E\n"})
public final class GDPRSecondLayerMapper
extends GenericSecondLayerMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final LegalBasisLocalization translations;
    @NotNull
    private final PredefinedUICustomization customization;
    @NotNull
    private final String controllerId;
    @NotNull
    private final List<UsercentricsCategory> categories;
    @NotNull
    private final List<LegacyService> services;
    @NotNull
    private final PredefinedUIServiceLabels serviceLabels;
    private final boolean hideTogglesForServices;
    private final boolean hideDataProcessingServices;
    @NotNull
    private static final FirstLayerLogoPosition defaultLogoPosition = FirstLayerLogoPosition.LEFT;

    public GDPRSecondLayerMapper(@NotNull UsercentricsSettings settings, @NotNull LegalBasisLocalization translations, @NotNull PredefinedUICustomization customization, @NotNull String controllerId, @NotNull List<UsercentricsCategory> categories, @NotNull List<LegacyService> services, @NotNull PredefinedUIServiceLabels serviceLabels) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)translations, (String)"translations");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)serviceLabels, (String)"serviceLabels");
        super(settings);
        this.settings = settings;
        this.translations = translations;
        this.customization = customization;
        this.controllerId = controllerId;
        this.categories = categories;
        this.services = services;
        this.serviceLabels = serviceLabels;
        this.hideTogglesForServices = this.settings.getSecondLayer().getHideTogglesForServices();
        this.hideDataProcessingServices = this.settings.getSecondLayer().getHideDataProcessingServices();
    }

    @NotNull
    public final UCUISecondLayerSettings map() {
        return new UCUISecondLayerSettings(this.header(), this.footer(), this.content());
    }

    @NotNull
    public final PredefinedTVSecondLayerSettings mapTV() {
        Object object;
        String string = this.settings.getLabels().getSecondLayerTitle();
        if (string == null) {
            string = "";
        }
        String string2 = this.settings.getLabels().getBtnSave();
        Object object2 = this.settings.getTcf2();
        if (object2 == null || (object2 = ((TCF2Settings)object2).getTogglesSpecialFeaturesToggleOn()) == null) {
            object2 = "On";
        }
        if ((object = this.settings.getTcf2()) == null || (object = ((TCF2Settings)object).getTogglesSpecialFeaturesToggleOff()) == null) {
            object = "Off";
        }
        return new PredefinedTVSecondLayerSettings(string, string2, new PredefinedUIToggleLocalizations((String)object2, (String)object), new PredefinedTVSecondLayerSettingsContent.Cards(CollectionsKt.listOf((Object)new GDPRSectionMapperTV(this.settings.getSecondLayer().getTabsCategoriesLabel(), this.settings.getSecondLayer().getTabsServicesLabel(), this.settings.getLabels().getConsent(), this.hideTogglesForServices, this.settings, this.serviceLabels, this.translations).map(UsercentricsMaps.Companion.mapCategories(this.categories, this.services)))));
    }

    private final PredefinedUIHeaderSettings header() {
        String string;
        String string2;
        String string3 = ArrayExtensionsKt.emptyToNull(this.settings.getLabels().getSecondLayerDescriptionHtml());
        if (string3 == null) {
            string3 = string2 = this.settings.getLabels().getHeaderModal();
        }
        if ((string = this.settings.getLabels().getSecondLayerTitle()) == null) {
            string = "";
        }
        String string4 = string;
        FirstLayerLogoPosition firstLayerLogoPosition = defaultLogoPosition;
        PredefinedUILanguageSettings predefinedUILanguageSettings = this.headerLanguageSettings();
        UsercentricsCustomization usercentricsCustomization = this.settings.getCustomization();
        String string5 = usercentricsCustomization != null ? usercentricsCustomization.getLogoUrl() : null;
        List<PredefinedUILink> list = this.headerLinks();
        return new PredefinedUIHeaderSettings(string4, null, string2, list, firstLayerLogoPosition, string5, predefinedUILanguageSettings, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedUILanguageSettings headerLanguageSettings() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.settings.getLanguagesAvailable();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PredefinedUILanguage((String)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List availableLanguages = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PredefinedUILanguage it = (PredefinedUILanguage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getFullName());
                it = (PredefinedUILanguage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFullName())));
            }
        });
        boolean hideLanguage = Intrinsics.areEqual((Object)this.settings.getSecondLayer().getHideLanguageSwitch(), (Object)true) || !ArrayExtensionsKt.isMultiple(availableLanguages);
        return hideLanguage ? null : new PredefinedUILanguageSettings(availableLanguages, new PredefinedUILanguage(this.settings.getLanguage()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PredefinedUILink> headerLinks() {
        List list;
        if (this.hideDataProcessingServices) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterTo$iv$iv;
            Object[] objectArray = new PredefinedUILink[]{PredefinedUILink.Companion.legalLinkUrl(this.settings.getLabels().getPrivacyPolicyLinkText(), this.settings.getPrivacyPolicyUrl(), UsercentricsAnalyticsEventType.PRIVACY_POLICY_LINK), PredefinedUILink.Companion.legalLinkUrl(this.settings.getLabels().getImprintLinkText(), this.settings.getImprintUrl(), UsercentricsAnalyticsEventType.IMPRINT_LINK)};
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PredefinedUILink it = (PredefinedUILink)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it.getLabel()).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final PredefinedUIFooterSettings footer() {
        Object object;
        Object object2;
        PredefinedUIFooterButton predefinedUIFooterButton;
        if (Intrinsics.areEqual((Object)this.settings.getSecondLayer().getHideButtonDeny(), (Object)true)) {
            predefinedUIFooterButton = null;
        } else {
            String string = this.denyAllText();
            object2 = this.customization.getColor().getDenyAllButton();
            object = PredefinedUIButtonType.DENY_ALL;
            predefinedUIFooterButton = new PredefinedUIFooterButton(string, (PredefinedUIButtonType)((Object)object), (PredefinedUICustomizationColorButton)object2);
        }
        PredefinedUIFooterButton denyAllButton = predefinedUIFooterButton;
        object2 = this.acceptAllText();
        object = this.customization.getColor().getAcceptAllButton();
        Object object3 = PredefinedUIButtonType.ACCEPT_ALL;
        PredefinedUIFooterButton acceptAllButton = new PredefinedUIFooterButton((String)object2, (PredefinedUIButtonType)((Object)object3), (PredefinedUICustomizationColorButton)object);
        object = this.settings.getLabels().getBtnSave();
        object3 = this.customization.getColor().getSaveButton();
        PredefinedUIButtonType predefinedUIButtonType = PredefinedUIButtonType.SAVE_SETTINGS;
        PredefinedUIFooterButton saveSettingsButton = new PredefinedUIFooterButton((String)object, predefinedUIButtonType, (PredefinedUICustomizationColorButton)object3);
        FooterButtonLayoutMapper buttonLayoutMapper = new FooterButtonLayoutMapper(acceptAllButton, denyAllButton, saveSettingsButton, null, null, 24, null);
        return new PredefinedUIFooterSettings(this.poweredBy(), null, false, buttonLayoutMapper.mapButtons(), buttonLayoutMapper.mapButtonsLandscape(), 6, null);
    }

    private final String denyAllText() {
        String string = this.settings.getSecondLayer().getDenyButtonText();
        return (string != null ? !StringsKt.isBlank((CharSequence)string) : false) ? this.settings.getSecondLayer().getDenyButtonText() : this.settings.getLabels().getBtnDeny();
    }

    private final String acceptAllText() {
        String string = this.settings.getSecondLayer().getAcceptButtonText();
        return (string != null ? !StringsKt.isBlank((CharSequence)string) : false) ? this.settings.getSecondLayer().getAcceptButtonText() : this.settings.getLabels().getBtnAcceptAll();
    }

    private final PredefinedUIFooterEntry poweredBy() {
        return PoweredByMapper.INSTANCE.mapPoweredBy(new LegacyPoweredBy(this.settings.getEnablePoweredBy(), null, null, 6, null));
    }

    private final List<PredefinedUITabSettings> content() {
        List list;
        if (this.hideDataProcessingServices) {
            list = CollectionsKt.listOf((Object)new PredefinedUITabSettings("", new PredefinedUICategoriesContent(CollectionsKt.listOf((Object)this.contentCategorySection()))));
        } else {
            Object[] objectArray = new PredefinedUITabSettings[]{new PredefinedUITabSettings(this.settings.getSecondLayer().getTabsCategoriesLabel(), new PredefinedUICategoriesContent(CollectionsKt.listOf((Object)this.contentCategorySection()))), new PredefinedUITabSettings(this.settings.getSecondLayer().getTabsServicesLabel(), new PredefinedUIServicesContent(CollectionsKt.listOf((Object)this.contentServiceSection())))};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedUICardUISection contentCategorySection() {
        void $this$mapTo$iv$iv;
        List<CategoryProps> categoriesEntries = UsercentricsMaps.Companion.mapCategories(this.categories, this.services);
        Iterable $this$map$iv = categoriesEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            CategoryProps categoryProps = (CategoryProps)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPredefinedUICardUI((CategoryProps)entry));
        }
        List categoriesEntriesMap = (List)destination$iv$iv;
        PredefinedUIControllerIDSettings controllerID = this.hideDataProcessingServices ? this.getControllerID() : null;
        return new PredefinedUICardUISection(null, categoriesEntriesMap, controllerID);
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedUICardUI getPredefinedUICardUI(CategoryProps entry) {
        PredefinedUIServicesCardContent predefinedUIServicesCardContent;
        if (this.hideDataProcessingServices) {
            predefinedUIServicesCardContent = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = entry.getServices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LegacyService legacyService = (LegacyService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PredefinedUIServiceDetails((LegacyService)it, null, this.hideTogglesForServices, this.settings.getDpsDisplayFormat(), this.predefinedUIServiceConsent(it.getConsent()), 2, null));
            }
            List list = (List)destination$iv$iv;
            predefinedUIServicesCardContent = new PredefinedUIServicesCardContent(list);
        }
        PredefinedUIServicesCardContent content2 = predefinedUIServicesCardContent;
        return new PredefinedUICardUI(entry, (PredefinedUICardContent)content2, entry.getCategory().getDescription());
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedUICardUISection contentServiceSection() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LegacyService it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.services;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LegacyService)element$iv$iv;
            boolean bl = false;
            if (!(!it.isHidden())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List servicesToShow = (List)destination$iv$iv;
        $this$filter$iv = servicesToShow;
        String string = null;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void service;
            it = (LegacyService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PredefinedUISwitchSettingsUI mainSwitchSettings = this.hideTogglesForServices ? null : new PredefinedUISwitchSettingsUI((LegacyService)service);
            PredefinedUISingleServiceCardContent predefinedUISingleServiceCardContent = new PredefinedUISingleServiceCardContent(new PredefinedUIServiceDetails((LegacyService)service, null, false, this.settings.getDpsDisplayFormat(), this.predefinedUIServiceConsent(service.getConsent()), 6, null));
            collection.add(new PredefinedUICardUI((LegacyService)service, mainSwitchSettings, predefinedUISingleServiceCardContent));
        }
        PredefinedUIControllerIDSettings predefinedUIControllerIDSettings = this.getControllerID();
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new PredefinedUICardUISection(string2, list, predefinedUIControllerIDSettings);
    }

    private final PredefinedUIControllerIDSettings getControllerID() {
        return new PredefinedUIControllerIDSettings(this.translations.getLabels$usercentrics_release().getControllerIdTitle(), this.controllerId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/gdpr/GDPRSecondLayerMapper$Companion;", "", "()V", "defaultLogoPosition", "Lcom/usercentrics/sdk/v2/settings/data/FirstLayerLogoPosition;", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

