/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.tcf;

import com.usercentrics.sdk.CategoryProps;
import com.usercentrics.sdk.PurposeProps;
import com.usercentrics.sdk.SpecialFeatureProps;
import com.usercentrics.sdk.UsercentricsMaps;
import com.usercentrics.sdk.VendorProps;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerCardEntry;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerCardSection;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerDetailsEntry;
import com.usercentrics.sdk.models.settings.PredefinedTVSecondLayerSettingsContent;
import com.usercentrics.sdk.models.settings.PredefinedUIToggleSettings;
import com.usercentrics.sdk.models.settings.ServicesIdStrategy;
import com.usercentrics.sdk.models.tcf.TCFLabels;
import com.usercentrics.sdk.services.tcf.interfaces.TCFData;
import com.usercentrics.sdk.services.tcf.interfaces.TCFFeature;
import com.usercentrics.sdk.services.tcf.interfaces.TCFSpecialPurpose;
import com.usercentrics.sdk.v2.banner.service.mapper.gdpr.GDPRSectionMapperTV;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.TCFDetailsMapperTV;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rJ$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0019H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFSectionMapperTV;", "", "tcfData", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFData;", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "translations", "Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;", "labels", "Lcom/usercentrics/sdk/models/tcf/TCFLabels;", "skipNonIAB", "", "categories", "", "Lcom/usercentrics/sdk/CategoryProps;", "(Lcom/usercentrics/sdk/services/tcf/interfaces/TCFData;Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;Lcom/usercentrics/sdk/models/tcf/TCFLabels;ZLjava/util/List;)V", "detailsLabel", "", "getDetailsLabel", "()Ljava/lang/String;", "tcf2", "Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "getTcf2", "()Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "map", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerCardSection;", "mapEntriesWithIllustrations", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerDetailsEntry;", "description", "illustrations", "tvFeaturesSection", "tvNonIABSection", "tvPurposeContent", "Lcom/usercentrics/sdk/models/settings/PredefinedTVSecondLayerSettingsContent;", "property", "Lcom/usercentrics/sdk/PurposeProps;", "tvPurposesSection", "tvVendorContent", "Lcom/usercentrics/sdk/VendorProps;", "tvVendorsSection", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCFSectionMapperTV.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCFSectionMapperTV.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFSectionMapperTV\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1549#2:228\n1620#2,3:229\n1549#2:232\n1620#2,3:233\n1549#2:236\n1620#2,3:237\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n*S KotlinDebug\n*F\n+ 1 TCFSectionMapperTV.kt\ncom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFSectionMapperTV\n*L\n40#1:228\n40#1:229,3\n59#1:232\n59#1:233,3\n103#1:236\n103#1:237,3\n116#1:240\n116#1:241,3\n184#1:244\n184#1:245,3\n*E\n"})
public final class TCFSectionMapperTV {
    @NotNull
    private final TCFData tcfData;
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final LegalBasisLocalization translations;
    @NotNull
    private final TCFLabels labels;
    private final boolean skipNonIAB;
    @NotNull
    private final List<CategoryProps> categories;

    public TCFSectionMapperTV(@NotNull TCFData tcfData, @NotNull UsercentricsSettings settings, @NotNull LegalBasisLocalization translations, @NotNull TCFLabels labels, boolean skipNonIAB, @NotNull List<CategoryProps> categories) {
        Intrinsics.checkNotNullParameter((Object)tcfData, (String)"tcfData");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)translations, (String)"translations");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        this.tcfData = tcfData;
        this.settings = settings;
        this.translations = translations;
        this.labels = labels;
        this.skipNonIAB = skipNonIAB;
        this.categories = categories;
    }

    private final String getDetailsLabel() {
        return this.translations.getLabels$usercentrics_release().getDetails();
    }

    private final TCF2Settings getTcf2() {
        TCF2Settings tCF2Settings = this.settings.getTcf2();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        return tCF2Settings;
    }

    @NotNull
    public final List<PredefinedTVSecondLayerCardSection> map() {
        Object[] objectArray = new PredefinedTVSecondLayerCardSection[]{this.tvPurposesSection(this.tcfData), this.tvFeaturesSection(), this.tvNonIABSection(), this.tvVendorsSection()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerCardSection tvPurposesSection(TCFData tcfData) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = UsercentricsMaps.Companion.mapPurposes(tcfData);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            PredefinedUIToggleSettings predefinedUIToggleSettings;
            void it;
            PurposeProps purposeProps = (PurposeProps)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (it.getPurpose().getShowConsentToggle()) {
                String string = ServicesIdStrategy.Companion.id(it.getPurpose());
                String string2 = this.settings.getLabels().getConsent();
                boolean bl2 = it.getChecked();
                List list = CollectionsKt.emptyList();
                predefinedUIToggleSettings = new PredefinedUIToggleSettings(string, string2, "consent", true, bl2, null, list);
            } else {
                predefinedUIToggleSettings = null;
            }
            PredefinedUIToggleSettings consentToggle = predefinedUIToggleSettings;
            collection.add(new PredefinedTVSecondLayerCardEntry("PurposesSection-" + it.getPurpose().getId(), it.getPurpose().getName(), null, consentToggle, this.tvPurposeContent((PurposeProps)it)));
        }
        List purposes2 = (List)destination$iv$iv;
        Iterable $this$map$iv2 = tcfData.getSpecialPurposes();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TCFSpecialPurpose bl = (TCFSpecialPurpose)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(new PredefinedTVSecondLayerCardEntry("SpecialPurposesSection-" + it.getId(), it.getName(), null, null, new PredefinedTVSecondLayerSettingsContent.DetailsWithIllustrations(null, this.mapEntriesWithIllustrations(it.getPurposeDescription(), it.getIllustrations()))));
        }
        List specialPurposes = (List)destination$iv$iv2;
        List entries = CollectionsKt.plus((Collection)purposes2, (Iterable)specialPurposes);
        if (entries.isEmpty()) {
            return null;
        }
        return new PredefinedTVSecondLayerCardSection(this.getTcf2().getLabelsPurposes(), entries);
    }

    private final PredefinedTVSecondLayerSettingsContent tvPurposeContent(PurposeProps property) {
        PredefinedUIToggleSettings predefinedUIToggleSettings;
        if (property.getPurpose().getShowLegitimateInterestToggle()) {
            String string = ServicesIdStrategy.Companion.id(property.getPurpose());
            String string2 = this.getTcf2().getTogglesLegIntToggleLabel();
            boolean bl = property.getLegitimateInterestChecked();
            List list = CollectionsKt.emptyList();
            predefinedUIToggleSettings = new PredefinedUIToggleSettings(string, string2, "legitimateInterest", true, bl, null, list);
        } else {
            predefinedUIToggleSettings = null;
        }
        PredefinedUIToggleSettings legitimateInterestToggle = predefinedUIToggleSettings;
        return new PredefinedTVSecondLayerSettingsContent.DetailsWithIllustrations(legitimateInterestToggle, this.mapEntriesWithIllustrations(property.getPurpose().getPurposeDescription(), property.getPurpose().getIllustrations()));
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerCardSection tvFeaturesSection() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = this.tcfData.getFeatures();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TCFFeature tCFFeature = (TCFFeature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PredefinedTVSecondLayerCardEntry("FeaturesSection-" + it.getId(), it.getName(), null, null, new PredefinedTVSecondLayerSettingsContent.DetailsWithIllustrations(null, this.mapEntriesWithIllustrations(it.getPurposeDescription(), it.getIllustrations()))));
        }
        List features = (List)destination$iv$iv;
        Iterable $this$map$iv2 = UsercentricsMaps.Companion.mapSpecialFeatures(this.tcfData);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpecialFeatureProps bl = (SpecialFeatureProps)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = ServicesIdStrategy.Companion.id(it.getSpecialFeature());
            String string2 = this.settings.getLabels().getConsent();
            boolean bl3 = it.getChecked();
            List list = CollectionsKt.emptyList();
            PredefinedUIToggleSettings consentToggle = new PredefinedUIToggleSettings(string, string2, "consent", true, bl3, null, list);
            collection.add(new PredefinedTVSecondLayerCardEntry("SpecialFeaturesSection-" + it.getSpecialFeature().getId(), it.getSpecialFeature().getName(), null, consentToggle, new PredefinedTVSecondLayerSettingsContent.DetailsWithIllustrations(null, this.mapEntriesWithIllustrations(it.getSpecialFeature().getPurposeDescription(), it.getSpecialFeature().getIllustrations()))));
        }
        List specialFeatures = (List)destination$iv$iv2;
        List entries = CollectionsKt.plus((Collection)features, (Iterable)specialFeatures);
        if (entries.isEmpty()) {
            return null;
        }
        return new PredefinedTVSecondLayerCardSection(this.getTcf2().getLabelsFeatures(), entries);
    }

    private final List<PredefinedTVSecondLayerDetailsEntry> mapEntriesWithIllustrations(String description, List<String> illustrations) {
        Object[] objectArray = new PredefinedTVSecondLayerDetailsEntry[]{new PredefinedTVSecondLayerDetailsEntry.TitleContent(this.getDetailsLabel(), description)};
        List entries = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!((Collection)illustrations).isEmpty()) {
            TCF2Settings tCF2Settings = this.settings.getTcf2();
            Intrinsics.checkNotNull((Object)tCF2Settings);
            entries.add(new PredefinedTVSecondLayerDetailsEntry.TitleContent(tCF2Settings.getExamplesLabel(), PredefinedTVSecondLayerDetailsEntry.Companion.mapContentIllustrations$usercentrics_release((Iterable<String>)illustrations)));
        }
        return entries;
    }

    private final PredefinedTVSecondLayerCardSection tvNonIABSection() {
        if (this.skipNonIAB) {
            return null;
        }
        return new GDPRSectionMapperTV(this.getTcf2().getLabelsNonIabPurposes(), this.getTcf2().getLabelsNonIabVendors(), this.settings.getLabels().getConsent(), false, this.settings, this.labels.getNonTCFLabels().getService(), this.translations).map(this.categories);
    }

    /*
     * WARNING - void declaration
     */
    private final PredefinedTVSecondLayerCardSection tvVendorsSection() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.tcfData.getVendors().isEmpty()) {
            return null;
        }
        Iterable iterable = UsercentricsMaps.Companion.mapVendors(this.tcfData);
        String string = this.getTcf2().getLabelsIabVendors();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VendorProps vendorProps = (VendorProps)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = ServicesIdStrategy.Companion.id(it.getVendor());
            String string3 = this.settings.getLabels().getConsent();
            boolean bl2 = it.getChecked();
            List list = CollectionsKt.emptyList();
            PredefinedUIToggleSettings consentToggle = new PredefinedUIToggleSettings(string2, string3, "consent", true, bl2, null, list);
            collection.add(new PredefinedTVSecondLayerCardEntry("VendorsSection-" + it.getVendor().getId(), it.getVendor().getName(), null, consentToggle, this.tvVendorContent((VendorProps)it)));
        }
        List list = (List)destination$iv$iv;
        String string4 = string;
        return new PredefinedTVSecondLayerCardSection(string4, list);
    }

    private final PredefinedTVSecondLayerSettingsContent tvVendorContent(VendorProps property) {
        PredefinedUIToggleSettings predefinedUIToggleSettings;
        if (property.getVendor().getShowLegitimateInterestToggle()) {
            String string = ServicesIdStrategy.Companion.id(property.getVendor());
            String string2 = this.getTcf2().getTogglesLegIntToggleLabel();
            boolean bl = property.getLegitimateInterestChecked();
            List list = CollectionsKt.emptyList();
            predefinedUIToggleSettings = new PredefinedUIToggleSettings(string, string2, "legitimateInterest", true, bl, null, list);
        } else {
            predefinedUIToggleSettings = null;
        }
        PredefinedUIToggleSettings legitimateToggle = predefinedUIToggleSettings;
        return new PredefinedTVSecondLayerSettingsContent.DetailsWithVendors(this.getDetailsLabel(), legitimateToggle, new TCFDetailsMapperTV(this.settings, this.labels).map(property.getVendor()));
    }
}

