/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.tcf;

import com.usercentrics.sdk.VendorProps;
import com.usercentrics.sdk.models.settings.PredefinedUIHyperlinkServiceContent;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceContentSection;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceDetails;
import com.usercentrics.sdk.models.settings.PredefinedUISimpleServiceContent;
import com.usercentrics.sdk.models.settings.TCFHolder;
import com.usercentrics.sdk.models.tcf.TCFLabels;
import com.usercentrics.sdk.services.tcf.interfaces.IdAndName;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.TCFStorageInformationHolder;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.TCFStorageInformationMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.TCfVendorUrlsKt;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.tcf.core.model.gvl.DataRetention;
import com.usercentrics.tcf.core.model.gvl.RetentionPeriod;
import com.usercentrics.tcf.core.model.gvl.VendorUrl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0(H\u0002J\u0006\u0010-\u001a\u00020.J!\u0010/\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&2\b\u0010\u000b\u001a\u0004\u0018\u000100H\u0002\u00a2\u0006\u0002\u00101R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFVendorMapper;", "", "vendorProps", "Lcom/usercentrics/sdk/VendorProps;", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "labels", "Lcom/usercentrics/sdk/models/tcf/TCFLabels;", "(Lcom/usercentrics/sdk/VendorProps;Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/models/tcf/TCFLabels;)V", "categoriesOfData", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceContentSection;", "dataRetentionPeriod", "dataSharedOutsideEU", "getDataSharedOutsideEU", "()Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceContentSection;", "features", "legitimateInterestPurposes", "legitimateInterestURL", "getLegitimateInterestURL", "policyURL", "getPolicyURL", "purposesProcessedByConsent", "specialFeatures", "specialPurposes", "storageInformation", "getStorageInformation", "tcf2Settings", "Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "getTcf2Settings", "()Lcom/usercentrics/sdk/v2/settings/data/TCF2Settings;", "tcfHolder", "Lcom/usercentrics/sdk/models/settings/TCFHolder;", "getTcfHolder", "()Lcom/usercentrics/sdk/models/settings/TCFHolder;", "vendor", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendor;", "bulletServiceContentSection", "title", "", "idAndNameList", "", "Lcom/usercentrics/sdk/services/tcf/interfaces/IdAndName;", "retentionPeriod", "Lcom/usercentrics/tcf/core/model/gvl/RetentionPeriod;", "mapServiceContentSection", "mapServiceDetails", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceDetails;", "setDataRetentionPeriod", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceContentSection;", "usercentrics_release"})
public final class TCFVendorMapper {
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final TCFLabels labels;
    @NotNull
    private final TCFHolder tcfHolder;
    @NotNull
    private final TCFVendor vendor;
    @Nullable
    private final PredefinedUIServiceContentSection purposesProcessedByConsent;
    @Nullable
    private final PredefinedUIServiceContentSection categoriesOfData;
    @Nullable
    private final PredefinedUIServiceContentSection dataRetentionPeriod;
    @Nullable
    private final PredefinedUIServiceContentSection legitimateInterestPurposes;
    @Nullable
    private final PredefinedUIServiceContentSection specialPurposes;
    @Nullable
    private final PredefinedUIServiceContentSection features;
    @Nullable
    private final PredefinedUIServiceContentSection specialFeatures;

    public TCFVendorMapper(@NotNull VendorProps vendorProps, @NotNull UsercentricsSettings settings, @NotNull TCFLabels labels) {
        Intrinsics.checkNotNullParameter((Object)vendorProps, (String)"vendorProps");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.settings = settings;
        this.labels = labels;
        TCF2Settings tCF2Settings = this.settings.getTcf2();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        this.tcfHolder = new TCFHolder(vendorProps, tCF2Settings.getHideLegitimateInterestToggles());
        this.vendor = vendorProps.getVendor();
        DataRetention dataRetention = this.vendor.getDataRetention();
        this.purposesProcessedByConsent = this.bulletServiceContentSection(this.getTcf2Settings().getVendorPurpose(), this.vendor.getPurposes(), dataRetention != null ? dataRetention.getPurposes() : null);
        this.categoriesOfData = TCFVendorMapper.bulletServiceContentSection$default(this, this.getTcf2Settings().getCategoriesOfDataLabel(), this.vendor.getDataCategories(), null, 4, null);
        DataRetention dataRetention2 = this.vendor.getDataRetention();
        this.dataRetentionPeriod = this.setDataRetentionPeriod(this.getTcf2Settings().getDataRetentionPeriodLabel(), dataRetention2 != null ? dataRetention2.getStdRetention() : null);
        this.legitimateInterestPurposes = TCFVendorMapper.bulletServiceContentSection$default(this, this.getTcf2Settings().getVendorLegitimateInterestPurposes(), this.vendor.getLegitimateInterestPurposes(), null, 4, null);
        DataRetention dataRetention3 = this.vendor.getDataRetention();
        this.specialPurposes = this.bulletServiceContentSection(this.getTcf2Settings().getVendorSpecialPurposes(), this.vendor.getSpecialPurposes(), dataRetention3 != null ? dataRetention3.getSpecialPurposes() : null);
        this.features = TCFVendorMapper.bulletServiceContentSection$default(this, this.getTcf2Settings().getVendorFeatures(), this.vendor.getFeatures(), null, 4, null);
        this.specialFeatures = TCFVendorMapper.bulletServiceContentSection$default(this, this.getTcf2Settings().getVendorSpecialFeatures(), this.vendor.getSpecialFeatures(), null, 4, null);
    }

    private final TCF2Settings getTcf2Settings() {
        TCF2Settings tCF2Settings = this.settings.getTcf2();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        return tCF2Settings;
    }

    @NotNull
    public final TCFHolder getTcfHolder() {
        return this.tcfHolder;
    }

    @NotNull
    public final PredefinedUIServiceDetails mapServiceDetails() {
        return new PredefinedUIServiceDetails(this.tcfHolder.getId(), null, this.mapServiceContentSection(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 524282, null);
    }

    private final List<PredefinedUIServiceContentSection> mapServiceContentSection() {
        Object[] objectArray = new PredefinedUIServiceContentSection[]{this.purposesProcessedByConsent, this.legitimateInterestPurposes, this.specialPurposes, this.features, this.specialFeatures, this.categoriesOfData, this.getDataSharedOutsideEU(), this.getPolicyURL(), this.getLegitimateInterestURL(), this.getStorageInformation(), this.dataRetentionPeriod};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final PredefinedUIServiceContentSection getDataSharedOutsideEU() {
        String title = this.settings.getLabels().getTransferToThirdCountries();
        String description = this.labels.getVendorsOutsideEU();
        boolean hasInfo = !StringsKt.isBlank((CharSequence)title) && !StringsKt.isBlank((CharSequence)description);
        return Intrinsics.areEqual((Object)this.vendor.getDataSharedOutsideEU(), (Object)true) && hasInfo ? new PredefinedUIServiceContentSection(title, new PredefinedUISimpleServiceContent(description)) : null;
    }

    private final PredefinedUIServiceContentSection getPolicyURL() {
        Object object = TCfVendorUrlsKt.getVendorUrls(this.vendor, this.settings);
        if (object == null || (object = ((VendorUrl)object).getPrivacy()) == null) {
            return null;
        }
        Object policyUrl = object;
        return new PredefinedUIServiceContentSection(this.settings.getLabels().getPrivacyPolicyLinkText(), new PredefinedUIHyperlinkServiceContent((String)policyUrl));
    }

    private final PredefinedUIServiceContentSection getLegitimateInterestURL() {
        Object object = TCfVendorUrlsKt.getVendorUrls(this.vendor, this.settings);
        if (object == null || (object = ((VendorUrl)object).getLegIntClaim()) == null) {
            return null;
        }
        Object legIntClaimUrl = object;
        return new PredefinedUIServiceContentSection(this.getTcf2Settings().getLegitimateInterestLabel(), new PredefinedUIHyperlinkServiceContent((String)legIntClaimUrl));
    }

    private final PredefinedUIServiceContentSection getStorageInformation() {
        Double d = this.vendor.getCookieMaxAgeSeconds();
        TCFStorageInformationMapper tcfStorageInformationMapper = new TCFStorageInformationMapper(new TCFStorageInformationHolder(d != null ? Long.valueOf((long)d.doubleValue()) : null, this.vendor.getUsesNonCookieAccess(), this.vendor.getDeviceStorageDisclosureUrl(), this.vendor.getDeviceStorage(), this.vendor.getUsesCookies(), this.vendor.getCookieRefresh(), this.labels.getCookieInformation()), false);
        return tcfStorageInformationMapper.map();
    }

    private final PredefinedUIServiceContentSection bulletServiceContentSection(String title, List<IdAndName> idAndNameList, RetentionPeriod retentionPeriod) {
        String content2 = CollectionsKt.joinToString$default((Iterable)idAndNameList, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<IdAndName, CharSequence>(retentionPeriod, this){
            final /* synthetic */ RetentionPeriod $retentionPeriod;
            final /* synthetic */ TCFVendorMapper this$0;
            {
                this.$retentionPeriod = $retentionPeriod;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IdAndName idAndName) {
                Intrinsics.checkNotNullParameter((Object)idAndName, (String)"idAndName");
                Object object = this.$retentionPeriod;
                Integer time = object != null && (object = ((RetentionPeriod)object).getIdAndPeriod()) != null ? (Integer)object.get(idAndName.getId()) : null;
                return time != null ? (CharSequence)("\u2022 " + ((Object)StringsKt.trim((CharSequence)idAndName.getName())).toString() + " (" + TCFVendorMapper.access$getTcf2Settings(this.this$0).getDataRetentionPeriodLabel() + ": " + time + ')') : (CharSequence)("\u2022 " + ((Object)StringsKt.trim((CharSequence)idAndName.getName())).toString());
            }
        }), (int)30, null);
        if (StringsKt.isBlank((CharSequence)content2)) {
            return null;
        }
        return new PredefinedUIServiceContentSection(title, new PredefinedUISimpleServiceContent(content2));
    }

    static /* synthetic */ PredefinedUIServiceContentSection bulletServiceContentSection$default(TCFVendorMapper tCFVendorMapper, String string, List list, RetentionPeriod retentionPeriod, int n, Object object) {
        if ((n & 4) != 0) {
            retentionPeriod = null;
        }
        return tCFVendorMapper.bulletServiceContentSection(string, list, retentionPeriod);
    }

    private final PredefinedUIServiceContentSection setDataRetentionPeriod(String title, Integer dataRetentionPeriod) {
        if (dataRetentionPeriod == null) {
            return null;
        }
        String content2 = "\u2022 " + dataRetentionPeriod;
        return new PredefinedUIServiceContentSection(title, new PredefinedUISimpleServiceContent(content2));
    }

    public static final /* synthetic */ TCF2Settings access$getTcf2Settings(TCFVendorMapper $this) {
        return $this.getTcf2Settings();
    }
}

