/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.tcf;

import com.usercentrics.sdk.models.settings.FirstLayerButtonLabels;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedTVViewSettings;
import com.usercentrics.sdk.models.settings.PredefinedUICustomization;
import com.usercentrics.sdk.models.settings.PredefinedUILabels;
import com.usercentrics.sdk.models.settings.PredefinedUIViewSettings;
import com.usercentrics.sdk.models.tcf.TCFLabels;
import com.usercentrics.sdk.services.tcf.interfaces.TCFData;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.TCFFirstLayerMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.TCFSecondLayerMapper;
import com.usercentrics.sdk.v2.settings.data.TCF2Settings;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFViewSettingsMapper;", "", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "translations", "Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;", "customization", "Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;", "labels", "Lcom/usercentrics/sdk/models/tcf/TCFLabels;", "tcfData", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFData;", "gdprAppliesOnTCF", "", "categories", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsCategory;", "services", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "controllerId", "", "(Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;Lcom/usercentrics/sdk/v2/translation/data/LegalBasisLocalization;Lcom/usercentrics/sdk/models/settings/PredefinedUICustomization;Lcom/usercentrics/sdk/models/tcf/TCFLabels;Lcom/usercentrics/sdk/services/tcf/interfaces/TCFData;ZLjava/util/List;Ljava/util/List;Ljava/lang/String;)V", "firstLayerMapper", "Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFFirstLayerMapper;", "secondLayerMapper", "Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/TCFSecondLayerMapper;", "Lcom/usercentrics/sdk/models/settings/PredefinedUILabels;", "map", "Lcom/usercentrics/sdk/models/settings/PredefinedUIViewSettings;", "mapTV", "Lcom/usercentrics/sdk/models/settings/PredefinedTVViewSettings;", "usercentrics_release"})
public final class TCFViewSettingsMapper {
    @NotNull
    private final UsercentricsSettings settings;
    @NotNull
    private final LegalBasisLocalization translations;
    @NotNull
    private final PredefinedUICustomization customization;
    @NotNull
    private final TCFLabels labels;
    @NotNull
    private final TCFFirstLayerMapper firstLayerMapper;
    @NotNull
    private final TCFSecondLayerMapper secondLayerMapper;

    public TCFViewSettingsMapper(@NotNull UsercentricsSettings settings, @NotNull LegalBasisLocalization translations, @NotNull PredefinedUICustomization customization, @NotNull TCFLabels labels, @NotNull TCFData tcfData, boolean gdprAppliesOnTCF, @NotNull List<UsercentricsCategory> categories, @NotNull List<LegacyService> services, @NotNull String controllerId) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)translations, (String)"translations");
        Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)tcfData, (String)"tcfData");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        this.settings = settings;
        this.translations = translations;
        this.customization = customization;
        this.labels = labels;
        this.firstLayerMapper = new TCFFirstLayerMapper(this.settings, tcfData, this.customization, gdprAppliesOnTCF, categories, services);
        this.secondLayerMapper = new TCFSecondLayerMapper(this.settings, tcfData, this.translations, this.customization, gdprAppliesOnTCF, categories, services, this.labels, controllerId);
    }

    @NotNull
    public final PredefinedUIViewSettings map() {
        return new PredefinedUIViewSettings(this.customization, this.labels(), this.firstLayerMapper.map(), this.secondLayerMapper.map());
    }

    @NotNull
    public final PredefinedTVViewSettings mapTV() {
        return new PredefinedTVViewSettings(this.customization, this.firstLayerMapper.mapTV(), this.secondLayerMapper.mapTV(), this.labels.getNonTCFLabels().getAriaLabels());
    }

    private final PredefinedUILabels labels() {
        TCF2Settings tCF2Settings = this.settings.getTcf2();
        Intrinsics.checkNotNull((Object)tCF2Settings);
        FirstLayerButtonLabels buttonLabels = new FirstLayerButtonLabels(tCF2Settings.getButtonsAcceptAllLabel(), this.settings.getTcf2().getButtonsDenyAllLabel(), this.settings.getTcf2().getLinksManageSettingsLabel(), this.settings.getTcf2().getButtonsSaveLabel());
        return new PredefinedUILabels(this.labels.getNonTCFLabels().getGeneral(), this.labels.getNonTCFLabels().getService(), buttonLabels, this.labels.getCookieInformation(), this.labels.getNonTCFLabels().getAriaLabels());
    }
}

