/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.api;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.core.settings.SettingsOrchestrator;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.consent.api.ConsentsDataDto;
import com.usercentrics.sdk.v2.consent.api.GetConsentsApi;
import com.usercentrics.sdk.v2.consent.api.GetConsentsV2ApiKt;
import com.usercentrics.sdk.v2.consent.data.GetConsentsData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/usercentrics/sdk/v2/consent/api/GetConsentsV2Api;", "Lcom/usercentrics/sdk/v2/consent/api/GetConsentsApi;", "requests", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "settingsOrchestrator", "Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/core/json/JsonParser;Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;)V", "createUrl", "", "settingsId", "controllerId", "getUserConsents", "", "onSuccess", "Lkotlin/Function1;", "Lcom/usercentrics/sdk/v2/consent/data/GetConsentsData;", "onError", "Lcom/usercentrics/sdk/errors/UsercentricsException;", "usercentrics_release"})
public final class GetConsentsV2Api
implements GetConsentsApi {
    @NotNull
    private final HttpRequests requests;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final SettingsOrchestrator settingsOrchestrator;

    public GetConsentsV2Api(@NotNull HttpRequests requests, @NotNull NetworkResolver networkResolver2, @NotNull JsonParser jsonParser, @NotNull SettingsOrchestrator settingsOrchestrator2) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)settingsOrchestrator2, (String)"settingsOrchestrator");
        this.requests = requests;
        this.networkResolver = networkResolver2;
        this.jsonParser = jsonParser;
        this.settingsOrchestrator = settingsOrchestrator2;
    }

    @Override
    public void getUserConsents(@NotNull String controllerId, @NotNull Function1<? super GetConsentsData, Unit> onSuccess, @NotNull Function1<? super UsercentricsException, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.settingsOrchestrator.getSettingsIdObservable().subscribe((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, controllerId, onSuccess, onError2){
            final /* synthetic */ GetConsentsV2Api this$0;
            final /* synthetic */ String $controllerId;
            final /* synthetic */ Function1<GetConsentsData, Unit> $onSuccess;
            final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
            {
                this.this$0 = $receiver;
                this.$controllerId = $controllerId;
                this.$onSuccess = $onSuccess;
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull String settingsId) {
                Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
                GetConsentsV2Api.access$getRequests$p(this.this$0).get(GetConsentsV2Api.access$createUrl(this.this$0, settingsId, this.$controllerId), null, (Function1<? super HttpResponse, Unit>)((Function1)new Function1<HttpResponse, Unit>(this.this$0, this.$onSuccess){
                    final /* synthetic */ GetConsentsV2Api this$0;
                    final /* synthetic */ Function1<GetConsentsData, Unit> $onSuccess;
                    {
                        this.this$0 = $receiver;
                        this.$onSuccess = $onSuccess;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull HttpResponse responseJson) {
                        void deserializer$iv;
                        Intrinsics.checkNotNullParameter((Object)responseJson, (String)"responseJson");
                        JsonParser jsonParser = GetConsentsV2Api.access$getJsonParser$p(this.this$0);
                        DeserializationStrategy deserializationStrategy = (DeserializationStrategy)ConsentsDataDto.Companion.serializer();
                        String str$iv = responseJson.getBody();
                        boolean $i$f$decodeFromString = false;
                        ConsentsDataDto response2 = (ConsentsDataDto)JsonParserKt.access$getJson$p().decodeFromString((DeserializationStrategy)deserializer$iv, str$iv);
                        this.$onSuccess.invoke((Object)GetConsentsV2ApiKt.mapToGetConsentsData(response2, GetConsentsV2Api.access$getJsonParser$p(this.this$0)));
                    }
                }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$onError){
                    final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
                    {
                        this.$onError = $onError;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$onError.invoke((Object)new UsercentricsException("Failed to get user consents V2: " + it.getMessage(), it));
                    }
                }));
            }
        }));
    }

    private final String createUrl(String settingsId, String controllerId) {
        return this.networkResolver.getConsentsV2BaseUrl() + "/?settingsId=" + settingsId + "&controllerId=" + controllerId;
    }

    public static final /* synthetic */ HttpRequests access$getRequests$p(GetConsentsV2Api $this) {
        return $this.requests;
    }

    public static final /* synthetic */ String access$createUrl(GetConsentsV2Api $this, String settingsId, String controllerId) {
        return $this.createUrl(settingsId, controllerId);
    }

    public static final /* synthetic */ JsonParser access$getJsonParser$p(GetConsentsV2Api $this) {
        return $this.jsonParser;
    }
}

