/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.api;

import com.usercentrics.sdk.core.hash.UUID;
import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.consent.api.ConsentString;
import com.usercentrics.sdk.v2.consent.api.GraphQLConsent;
import com.usercentrics.sdk.v2.consent.api.GraphQLQueryMutation;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsApi;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsVariables;
import com.usercentrics.sdk.v2.consent.data.DataTransferObject;
import com.usercentrics.sdk.v2.consent.data.DataTransferObjectService;
import com.usercentrics.sdk.v2.consent.data.SaveConsentsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00170\u001eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsLegacyApi;", "Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApi;", "requests", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/core/json/JsonParser;)V", "createGraphQLOptions", "", "", "createSaveConsentsQuery", "Lcom/usercentrics/sdk/v2/consent/api/GraphQLQueryMutation;", "consentsData", "Lcom/usercentrics/sdk/v2/consent/data/SaveConsentsData;", "createSaveConsentsQueryJson", "mapGraphQLConsents", "", "Lcom/usercentrics/sdk/v2/consent/api/GraphQLConsent;", "dataTransferObject", "Lcom/usercentrics/sdk/v2/consent/data/DataTransferObject;", "saveConsents", "", "analyticsFlag", "", "xdeviceFlag", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nSaveConsentsLegacyApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveConsentsLegacyApi.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsLegacyApi\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n40#2:120\n1549#3:121\n1620#3,3:122\n*S KotlinDebug\n*F\n+ 1 SaveConsentsLegacyApi.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsLegacyApi\n*L\n47#1:120\n65#1:121\n65#1:122,3\n*E\n"})
public final class SaveConsentsLegacyApi
implements SaveConsentsApi {
    @NotNull
    private final HttpRequests requests;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final JsonParser jsonParser;

    public SaveConsentsLegacyApi(@NotNull HttpRequests requests, @NotNull NetworkResolver networkResolver2, @NotNull JsonParser jsonParser) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        this.requests = requests;
        this.networkResolver = networkResolver2;
        this.jsonParser = jsonParser;
    }

    @Override
    public void saveConsents(@NotNull SaveConsentsData consentsData, boolean analyticsFlag, boolean xdeviceFlag, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Throwable, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)consentsData, (String)"consentsData");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        String query = this.createSaveConsentsQueryJson(consentsData);
        Map<String, String> options = this.createGraphQLOptions();
        this.requests.post(this.networkResolver.saveConsentsLegacyBaseUrl(), query, options, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(onSuccess){
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onSuccess.invoke();
            }
        }), onError2);
    }

    private final Map<String, String> createGraphQLOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Access-Control-Allow-Origin", (Object)"*"), TuplesKt.to((Object)"X-Request-ID", (Object)UUID.INSTANCE.random())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String createSaveConsentsQueryJson(SaveConsentsData consentsData) {
        GraphQLQueryMutation query = this.createSaveConsentsQuery(consentsData);
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)GraphQLQueryMutation.Companion.serializer();
        boolean $i$f$encodeToString = false;
        return JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)query);
    }

    private final GraphQLQueryMutation createSaveConsentsQuery(SaveConsentsData consentsData) {
        return new GraphQLQueryMutation("saveConsents", "mutation saveConsents($consents: [NewCreateConsentInput], $consentString: ConsentString) { saveConsents(consents: $consents, consentString: $consentString) { data { consentId } } }", new SaveConsentsVariables(this.mapGraphQLConsents(consentsData.getDataTransferObject()), new ConsentString(null, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphQLConsent> mapGraphQLConsents(DataTransferObject dataTransferObject) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = dataTransferObject.getServices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void DTOservice;
            DataTransferObjectService dataTransferObjectService = (DataTransferObjectService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = dataTransferObject.getConsent().getAction().getText$usercentrics_release();
            String string2 = dataTransferObject.getApplicationVersion();
            String string3 = DTOservice.getStatus() ? "1" : "0";
            String string4 = DTOservice.getId();
            String string5 = DTOservice.getVersion();
            String string6 = dataTransferObject.getSettings().getControllerId();
            String string7 = dataTransferObject.getSettings().getLanguage();
            String string8 = DTOservice.getProcessorId();
            String string9 = dataTransferObject.getSettings().getId();
            String string10 = dataTransferObject.getSettings().getVersion();
            String string11 = dataTransferObject.getConsent().getType().getText$usercentrics_release();
            collection.add(new GraphQLConsent(string, string2, string6, string3, string4, string5, string7, string8, "", string9, string10, string11));
        }
        return (List)destination$iv$iv;
    }
}

