/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.api;

import com.usercentrics.sdk.core.hash.UUID;
import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.extensions.TimeExtensionsKt;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.ui.userAgent.UserAgentProvider;
import com.usercentrics.sdk.ui.userAgent.UsercentricsUserAgentInfo;
import com.usercentrics.sdk.v2.consent.api.ConsentStatusV2Dto;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsApi;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsV2Dto;
import com.usercentrics.sdk.v2.consent.data.ConsentStringObject;
import com.usercentrics.sdk.v2.consent.data.ConsentStringObjectDto;
import com.usercentrics.sdk.v2.consent.data.DataTransferObjectService;
import com.usercentrics.sdk.v2.consent.data.SaveConsentsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002JB\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001c0 H\u0016J\f\u0010\"\u001a\u00020#*\u00020$H\u0002J$\u0010\"\u001a\u00020%*\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsV2Api;", "Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApi;", "requests", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "userAgentProvider", "Lcom/usercentrics/sdk/ui/userAgent/UserAgentProvider;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/core/json/JsonParser;Lcom/usercentrics/sdk/ui/userAgent/UserAgentProvider;)V", "userAgentInfo", "Lcom/usercentrics/sdk/ui/userAgent/UsercentricsUserAgentInfo;", "getUserAgentInfo", "()Lcom/usercentrics/sdk/ui/userAgent/UsercentricsUserAgentInfo;", "userAgentInfo$delegate", "Lkotlin/Lazy;", "createPayload", "", "consentsData", "Lcom/usercentrics/sdk/v2/consent/data/SaveConsentsData;", "analyticsFlag", "", "xdeviceFlag", "getHeaders", "", "getSaveEndpointUrl", "saveConsents", "", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "", "mapDto", "Lcom/usercentrics/sdk/v2/consent/api/ConsentStatusV2Dto;", "Lcom/usercentrics/sdk/v2/consent/data/DataTransferObjectService;", "Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsV2Dto;", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nSaveConsentsV2Api.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveConsentsV2Api.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsV2Api\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n40#2:134\n40#2:135\n1549#3:136\n1620#3,3:137\n*S KotlinDebug\n*F\n+ 1 SaveConsentsV2Api.kt\ncom/usercentrics/sdk/v2/consent/api/SaveConsentsV2Api\n*L\n65#1:134\n79#1:135\n90#1:136\n90#1:137,3\n*E\n"})
public final class SaveConsentsV2Api
implements SaveConsentsApi {
    @NotNull
    private final HttpRequests requests;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final UserAgentProvider userAgentProvider;
    @NotNull
    private final Lazy userAgentInfo$delegate;

    public SaveConsentsV2Api(@NotNull HttpRequests requests, @NotNull NetworkResolver networkResolver2, @NotNull JsonParser jsonParser, @NotNull UserAgentProvider userAgentProvider2) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider2, (String)"userAgentProvider");
        this.requests = requests;
        this.networkResolver = networkResolver2;
        this.jsonParser = jsonParser;
        this.userAgentProvider = userAgentProvider2;
        this.userAgentInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UsercentricsUserAgentInfo>(this){
            final /* synthetic */ SaveConsentsV2Api this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final UsercentricsUserAgentInfo invoke() {
                return SaveConsentsV2Api.access$getUserAgentProvider$p(this.this$0).provide();
            }
        }));
    }

    private final UsercentricsUserAgentInfo getUserAgentInfo() {
        Lazy lazy = this.userAgentInfo$delegate;
        return (UsercentricsUserAgentInfo)lazy.getValue();
    }

    @Override
    public void saveConsents(@NotNull SaveConsentsData consentsData, boolean analyticsFlag, boolean xdeviceFlag, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Throwable, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)consentsData, (String)"consentsData");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.requests.post(this.getSaveEndpointUrl(), this.createPayload(consentsData, analyticsFlag, xdeviceFlag), this.getHeaders(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(onSuccess){
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$onSuccess.invoke();
            }
        }), onError2);
    }

    private final Map<String, String> getHeaders() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Access-Control-Allow-Origin", (Object)"*"), TuplesKt.to((Object)"X-Request-ID", (Object)UUID.INSTANCE.random())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String createPayload(SaveConsentsData consentsData, boolean analyticsFlag, boolean xdeviceFlag) {
        SaveConsentsV2Dto dto = this.mapDto(consentsData, this.getUserAgentInfo(), analyticsFlag, xdeviceFlag);
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)SaveConsentsV2Dto.Companion.serializer();
        boolean $i$f$encodeToString = false;
        return JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)dto);
    }

    private final String getSaveEndpointUrl() {
        return this.networkResolver.saveConsentsV2BaseUrl() + "/consent/ua/2";
    }

    /*
     * WARNING - void declaration
     */
    private final SaveConsentsV2Dto mapDto(SaveConsentsData $this$mapDto, UsercentricsUserAgentInfo userAgentInfo2, boolean analyticsFlag, boolean xdeviceFlag) {
        Collection<ConsentStatusV2Dto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        ConsentStringObjectDto consentMetaPayload;
        Object consentString;
        Object object = $this$mapDto.getConsentStringObject();
        if (object == null || (object = ((ConsentStringObject)object).getString()) == null) {
            object = consentString = "";
        }
        if ((consentMetaPayload = ConsentStringObjectDto.Companion.create(TimeExtensionsKt.secondsToMillis($this$mapDto.getDataTransferObject().getTimestampInSeconds()), $this$mapDto.getConsentStringObject())) == null) {
            string = "";
        } else {
            JsonParser jsonParser = this.jsonParser;
            SerializationStrategy serializer$iv = (SerializationStrategy)ConsentStringObjectDto.Companion.serializer();
            boolean $i$f$encodeToString = false;
            string = JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)consentMetaPayload);
        }
        String consentMeta = string;
        Iterable this_$iv = $this$mapDto.getDataTransferObject().getServices();
        String string2 = consentMeta;
        Object object2 = consentString;
        String string3 = $this$mapDto.getDataTransferObject().getSettings().getVersion();
        String string4 = $this$mapDto.getDataTransferObject().getSettings().getId();
        String string5 = $this$mapDto.getDataTransferObject().getSettings().getLanguage();
        String string6 = $this$mapDto.getDataTransferObject().getSettings().getControllerId();
        String string7 = userAgentInfo2.getAppVersion();
        String string8 = $this$mapDto.getDataTransferObject().getConsent().getAction().getText$usercentrics_release();
        boolean $i$f$map = false;
        void $i$f$encodeToString = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataTransferObjectService dataTransferObjectService = (DataTransferObjectService)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapDto((DataTransferObjectService)it));
        }
        collection = (List)destination$iv$iv;
        boolean bl = analyticsFlag;
        boolean bl2 = xdeviceFlag;
        String string9 = userAgentInfo2.getPlatform();
        String string10 = userAgentInfo2.getSdkVersion();
        String string11 = userAgentInfo2.getAppID();
        Collection<ConsentStatusV2Dto> collection2 = collection;
        String string12 = string2;
        Object object3 = object2;
        String string13 = string3;
        String string14 = string4;
        String string15 = string5;
        String string16 = string6;
        String string17 = string7;
        String string18 = string8;
        return new SaveConsentsV2Dto(string18, string17, string16, string15, string14, string13, (String)object3, string12, (List<ConsentStatusV2Dto>)collection2, string11, string10, string9, bl2, bl);
    }

    private final ConsentStatusV2Dto mapDto(DataTransferObjectService $this$mapDto) {
        return new ConsentStatusV2Dto($this$mapDto.getStatus(), $this$mapDto.getId(), $this$mapDto.getVersion());
    }

    public static final /* synthetic */ UserAgentProvider access$getUserAgentProvider$p(SaveConsentsV2Api $this) {
        return $this.userAgentProvider;
    }
}

