/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.location.repository;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.v2.location.cache.ILocationCache;
import com.usercentrics.sdk.v2.location.data.LocationData;
import com.usercentrics.sdk.v2.location.data.LocationDataResponse;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.repository.ILocationRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/usercentrics/sdk/v2/location/repository/LocationRepository;", "Lcom/usercentrics/sdk/v2/location/repository/ILocationRepository;", "locationCache", "Lcom/usercentrics/sdk/v2/location/cache/ILocationCache;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "(Lcom/usercentrics/sdk/v2/location/cache/ILocationCache;Lcom/usercentrics/sdk/core/json/JsonParser;)V", "getCachedLocation", "Lcom/usercentrics/sdk/v2/location/data/LocationData;", "parseJson", "responseBody", "", "storeLocation", "", "location", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nLocationRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationRepository.kt\ncom/usercentrics/sdk/v2/location/repository/LocationRepository\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 5 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,39:1\n36#2:40\n28#2:44\n113#3:41\n32#4:42\n80#5:43\n*S KotlinDebug\n*F\n+ 1 LocationRepository.kt\ncom/usercentrics/sdk/v2/location/repository/LocationRepository\n*L\n32#1:40\n36#1:44\n32#1:41\n32#1:42\n32#1:43\n*E\n"})
public final class LocationRepository
implements ILocationRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ILocationCache locationCache;
    @NotNull
    private final JsonParser jsonParser;
    private static final int LOCATION_CACHE_PERIOD_IN_DAYS = 7;

    public LocationRepository(@NotNull ILocationCache locationCache2, @NotNull JsonParser jsonParser) {
        Intrinsics.checkNotNullParameter((Object)locationCache2, (String)"locationCache");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        this.locationCache = locationCache2;
        this.jsonParser = jsonParser;
    }

    @Override
    @Nullable
    public LocationData getCachedLocation() {
        String string = this.locationCache.getLocation();
        if (string == null) {
            return null;
        }
        String cachedLocation = string;
        long lastCacheTimestamp = this.locationCache.getLocationStorageTimestamp();
        DateTime lastCacheDateTime = new DateTime(lastCacheTimestamp).addDays(7);
        if (lastCacheDateTime.compareTo(new DateTime()) > 0) {
            return this.parseJson(cachedLocation);
        }
        return null;
    }

    @Override
    public void storeLocation(@NotNull UsercentricsLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        JsonParser jsonParser = this.jsonParser;
        LocationDataResponse input$iv = new LocationDataResponse(new LocationData(location));
        boolean $i$f$encodeToString = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$encodeToString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(LocationDataResponse.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        this.locationCache.storeLocation($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)input$iv));
    }

    private final LocationData parseJson(String responseBody) {
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializer$iv = (DeserializationStrategy)LocationDataResponse.Companion.serializer();
        boolean $i$f$decodeFromString = false;
        return ((LocationDataResponse)JsonParserKt.access$getJson$p().decodeFromString(deserializer$iv, responseBody)).getData();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/v2/location/repository/LocationRepository$Companion;", "", "()V", "LOCATION_CACHE_PERIOD_IN_DAYS", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

