/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.network;

import com.usercentrics.sdk.core.application.INetworkStrategy;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage;
import com.usercentrics.sdk.v2.etag.repository.EtagRepository;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/v2/network/NetworkOrchestrator;", "Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "etagCacheStorage", "Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;", "networkStrategy", "Lcom/usercentrics/sdk/core/application/INetworkStrategy;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;Lcom/usercentrics/sdk/core/application/INetworkStrategy;)V", "httpResponseFromCache", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "resolveHttp", "apiRequest", "Lkotlin/Function0;", "resolveHttpBody", "", "usercentrics_release"})
public abstract class NetworkOrchestrator
extends EtagRepository {
    @NotNull
    private final INetworkStrategy networkStrategy;

    public NetworkOrchestrator(@NotNull UsercentricsLogger logger2, @NotNull IEtagCacheStorage etagCacheStorage2, @NotNull INetworkStrategy networkStrategy2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)etagCacheStorage2, (String)"etagCacheStorage");
        Intrinsics.checkNotNullParameter((Object)networkStrategy2, (String)"networkStrategy");
        super(logger2, etagCacheStorage2);
        this.networkStrategy = networkStrategy2;
    }

    @NotNull
    public final String resolveHttpBody(@NotNull Function0<HttpResponse> apiRequest) {
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        return this.resolveHttp(apiRequest).getBody();
    }

    @NotNull
    public final HttpResponse resolveHttp(@NotNull Function0<HttpResponse> apiRequest) {
        String string;
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        if (this.networkStrategy.isOffline()) {
            return this.httpResponseFromCache();
        }
        HttpResponse response2 = (HttpResponse)apiRequest.invoke();
        switch (response2.getStatusCode()) {
            case 200: {
                string = this.getApiBody(response2);
                break;
            }
            case 304: {
                string = this.getEtagFile();
                break;
            }
            default: {
                throw new UsercentricsException("Invalid Network Response", null, 2, null);
            }
        }
        String body = string;
        return new HttpResponse(response2.getHeaders(), body, response2.getStatusCode());
    }

    private final HttpResponse httpResponseFromCache() {
        return new HttpResponse(MapsKt.emptyMap(), this.getEtagFile(), 304);
    }
}

